/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.common.primitives.UnsignedLongs;
import java.nio.ByteOrder;
import org.apache.tajo.util.UnsafeUtil;
import sun.misc.Unsafe;

public class UnSafeTupleBytesComparator {
    private static final Unsafe UNSAFE = UnsafeUtil.unsafe;
    static final boolean littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public static int compare(long ptr1, long ptr2) {
        int i;
        int lstrLen = UNSAFE.getInt(ptr1);
        int rstrLen = UNSAFE.getInt(ptr2);
        ptr1 += 4L;
        ptr2 += 4L;
        int minLength = Math.min(lstrLen, rstrLen);
        int minWords = minLength / 8;
        for (i = 0; i < minWords * 8; i += 8) {
            long rw;
            long lw = UNSAFE.getLong(ptr1);
            long diff = lw ^ (rw = UNSAFE.getLong(ptr2));
            if (diff != 0L) {
                int y;
                if (!littleEndian) {
                    return UnsignedLongs.compare((long)lw, (long)rw);
                }
                int n = 0;
                int x = (int)diff;
                if (x == 0) {
                    x = (int)(diff >>> 32);
                    n = 32;
                }
                if ((y = x << 16) == 0) {
                    n += 16;
                } else {
                    x = y;
                }
                y = x << 8;
                if (y == 0) {
                    n += 8;
                }
                return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
            }
            ptr1 += 8L;
            ptr2 += 8L;
        }
        for (i = minWords * 8; i < minLength; ++i) {
            int result;
            if ((result = UNSAFE.getByte(ptr1++) - UNSAFE.getByte(ptr2++)) == 0) continue;
            return result;
        }
        return lstrLen - rstrLen;
    }
}

