/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.annotation.Nullable;

public abstract class ClassUtil {
    private static final Log LOG = LogFactory.getLog(ClassUtil.class);

    public static Set<Class> findClasses(@Nullable Class targetClass, String packageFilter) {
        return ClassUtil.findClasses(targetClass, packageFilter, null);
    }

    public static Set<Class> findClasses(@Nullable Class targetClass, String packageFilter, Predicate predicate) {
        String[] paths;
        HashSet<Class> classSet = new HashSet<Class>();
        String classpath = System.getProperty("java.class.path");
        for (String path : paths = classpath.split(System.getProperty("path.separator"))) {
            File file = new File(path);
            if (!file.exists()) continue;
            ClassUtil.findClasses(classSet, file, file, true, targetClass, packageFilter, predicate);
        }
        return classSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void findClasses(Set<Class> matchedClassSet, File root, File file, boolean includeJars, @Nullable Class type, String packageFilter, @Nullable Predicate predicate) {
        String qualifiedClassName;
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                ClassUtil.findClasses(matchedClassSet, root, child, includeJars, type, packageFilter, predicate);
            }
            return;
        }
        if (file.getName().toLowerCase().endsWith(".jar") && includeJars) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String qualifiedClassName2;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                int extIndex = name.lastIndexOf(".class");
                if (extIndex <= 0 || (qualifiedClassName2 = name.substring(0, extIndex).replace("/", ".")).indexOf(packageFilter) < 0 || ClassUtil.isTestClass(qualifiedClassName2)) continue;
                try {
                    Class<?> clazz = Class.forName(qualifiedClassName2);
                    if (!ClassUtil.isMatched(clazz, type, predicate)) continue;
                    matchedClassSet.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                jar.close();
                return;
            }
            catch (IOException e) {
                LOG.warn((Object)("Closing " + file.getName() + " was failed."));
            }
            return;
        }
        if (!file.getName().toLowerCase().endsWith(".class") || (qualifiedClassName = ClassUtil.createClassName(root, file)).indexOf(packageFilter) < 0 || ClassUtil.isTestClass(qualifiedClassName)) return;
        try {
            Class<?> clazz = Class.forName(qualifiedClassName);
            if (!ClassUtil.isMatched(clazz, type, predicate)) return;
            matchedClassSet.add(clazz);
            return;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isMatched(Class clazz, Class targetClass, Predicate predicate) {
        return !(clazz.isInterface() || targetClass != null && !ClassUtil.isClassMatched(targetClass, clazz) || predicate != null && !predicate.evaluate((Object)clazz));
    }

    private static boolean isTestClass(String qualifiedClassName) {
        String className = ClassUtil.getSimpleClassName(qualifiedClassName);
        if (className == null) {
            return false;
        }
        return className.startsWith("Test");
    }

    private static boolean isClassMatched(Class targetClass, Class loadedClass) {
        Class superClass;
        if (targetClass.equals(loadedClass)) {
            return true;
        }
        Class<?>[] classInterfaces = loadedClass.getInterfaces();
        if (classInterfaces != null) {
            for (Class<?> eachInterfaceClass : classInterfaces) {
                if (eachInterfaceClass.equals(targetClass)) {
                    return true;
                }
                if (!ClassUtil.isClassMatched(targetClass, eachInterfaceClass)) continue;
                return true;
            }
        }
        return (superClass = loadedClass.getSuperclass()) != null && ClassUtil.isClassMatched(targetClass, superClass);
    }

    private static String getSimpleClassName(String qualifiedClassName) {
        String[] tokens = qualifiedClassName.split("\\.");
        if (tokens.length == 0) {
            return qualifiedClassName;
        }
        return tokens[tokens.length - 1];
    }

    private static String createClassName(File root, File file) {
        StringBuffer sb = new StringBuffer();
        String fileName = file.getName();
        sb.append(fileName.substring(0, fileName.lastIndexOf(".class")));
        for (file = file.getParentFile(); file != null && !file.equals(root); file = file.getParentFile()) {
            sb.insert(0, '.').insert(0, file.getName());
        }
        return sb.toString();
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return Class.forName(name);
    }
}

