/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NetUtils {
    public static String normalizeInetSocketAddress(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public static InetSocketAddress createSocketAddr(String addr) {
        String[] splitted = addr.split(":");
        return new InetSocketAddress(splitted[0], Integer.parseInt(splitted[1]));
    }

    public static InetSocketAddress createSocketAddr(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    public static InetSocketAddress createUnresolved(String addr) {
        String[] splitted = addr.split(":");
        return InetSocketAddress.createUnresolved(splitted[0], Integer.parseInt(splitted[1]));
    }

    public static InetSocketAddress getConnectAddress(InetSocketAddress addr) {
        if (!addr.isUnresolved() && addr.getAddress().isAnyLocalAddress()) {
            try {
                addr = new InetSocketAddress(InetAddress.getLocalHost(), addr.getPort());
            }
            catch (UnknownHostException uhe) {
                addr = new InetSocketAddress("127.0.0.1", addr.getPort());
            }
        }
        InetSocketAddress canonicalAddress = new InetSocketAddress(addr.getAddress().getCanonicalHostName(), addr.getPort());
        return canonicalAddress;
    }

    public static boolean isLocalAddress(InetAddress addr) {
        boolean local;
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        return local;
    }

    public static String normalizeHost(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            if (NetUtils.isLocalAddress(address)) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            return address.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return host;
        }
    }
}

