/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

public class PlatformUtil {
    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static OsType getOsType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (PlatformUtil.isWindows(osName)) {
            return OsType.WINDOWS;
        }
        if (PlatformUtil.isMac(osName)) {
            return OsType.MAC;
        }
        if (PlatformUtil.isUnix(osName)) {
            return OsType.LINUX_OR_UNIX;
        }
        if (PlatformUtil.isSolaris(osName)) {
            return OsType.SOLARIS;
        }
        throw new RuntimeException("Unknown OS Type: " + osName);
    }

    private static boolean isWindows(String osName) {
        return osName.indexOf("win") >= 0;
    }

    private static boolean isMac(String osName) {
        return osName.indexOf("mac") >= 0;
    }

    private static boolean isUnix(String osName) {
        return osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0 || osName.indexOf("aix") > 0;
    }

    private static boolean isSolaris(String osName) {
        return osName.indexOf("sunos") >= 0 || osName.indexOf("solaris") >= 0;
    }

    public static enum OsType {
        WINDOWS,
        MAC,
        LINUX_OR_UNIX,
        SOLARIS,
        UNKNOWN;

    }
}

