/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.tajo.common.ProtoObject;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.TUtil;

public class ProtoUtil {
    public static final PrimitiveProtos.BoolProto TRUE = PrimitiveProtos.BoolProto.newBuilder().setValue(true).build();
    public static final PrimitiveProtos.BoolProto FALSE = PrimitiveProtos.BoolProto.newBuilder().setValue(false).build();
    public static final PrimitiveProtos.NullProto NULL_PROTO = PrimitiveProtos.NullProto.newBuilder().build();

    public static PrimitiveProtos.StringProto convertString(String value) {
        return PrimitiveProtos.StringProto.newBuilder().setValue(value).build();
    }

    public static PrimitiveProtos.StringListProto convertStrings(Collection<String> strings) {
        return PrimitiveProtos.StringListProto.newBuilder().addAllValues(strings).build();
    }

    public static Collection<String> convertStrings(PrimitiveProtos.StringListProto strings) {
        return strings.getValuesList();
    }

    public static Map<String, String> convertToMap(PrimitiveProtos.KeyValueSetProto proto) {
        Map<String, String> keyVals = TUtil.newHashMap();
        for (PrimitiveProtos.KeyValueProto keyval : proto.getKeyvalList()) {
            keyVals.put(keyval.getKey(), keyval.getValue());
        }
        return keyVals;
    }

    public static PrimitiveProtos.KeyValueSetProto convertFromMap(Map<String, String> map) {
        return new KeyValueSet(map).getProto();
    }

    public static <T> Iterable<T> toProtoObjects(ProtoObject[] protoObjects) {
        ArrayList converted = Lists.newArrayList();
        for (int i = 0; i < protoObjects.length; ++i) {
            converted.add(protoObjects[i].getProto());
        }
        return converted;
    }
}

