/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import com.google.common.base.Preconditions;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.tajo.util.Deallocatable;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeUtil {
    public static final Unsafe unsafe;
    public static final AddressMode ADDRESS_MODE;
    public static final int ARRAY_BOOLEAN_BASE_OFFSET;
    public static final int ARRAY_BYTE_BASE_OFFSET;
    public static final int ARRAY_SHORT_BASE_OFFSET;
    public static final int ARRAY_CHAR_BASE_OFFSET;
    public static final int ARRAY_INT_BASE_OFFSET;
    public static final int ARRAY_LONG_BASE_OFFSET;
    public static final int ARRAY_FLOAT_BASE_OFFSET;
    public static final int ARRAY_DOUBLE_BASE_OFFSET;
    public static final int ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE;
    public static final int ARRAY_BYTE_INDEX_SCALE;
    public static final int ARRAY_SHORT_INDEX_SCALE;
    public static final int ARRAY_CHAR_INDEX_SCALE;
    public static final int ARRAY_INT_INDEX_SCALE;
    public static final int ARRAY_LONG_INDEX_SCALE;
    public static final int ARRAY_FLOAT_INDEX_SCALE;
    public static final int ARRAY_DOUBLE_INDEX_SCALE;
    public static final int ARRAY_OBJECT_INDEX_SCALE;

    public static int alignedSize(int size) {
        int remain = size % 8;
        if (remain > 0) {
            return size + (8 - remain);
        }
        return size;
    }

    public static long getAddress(ByteBuffer buffer) {
        Preconditions.checkArgument((boolean)buffer.isDirect(), (Object)"ByteBuffer must be DirectBuffer");
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static void free(Deallocatable obj) {
        obj.release();
    }

    public static void free(ByteBuffer bb) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)bb);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ARRAY_BOOLEAN_BASE_OFFSET = unsafe.arrayBaseOffset(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = unsafe.arrayBaseOffset(short[].class);
        ARRAY_CHAR_BASE_OFFSET = unsafe.arrayBaseOffset(char[].class);
        ARRAY_INT_BASE_OFFSET = unsafe.arrayBaseOffset(int[].class);
        ARRAY_LONG_BASE_OFFSET = unsafe.arrayBaseOffset(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = unsafe.arrayBaseOffset(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = unsafe.arrayBaseOffset(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = unsafe.arrayBaseOffset(Object[].class);
        ARRAY_BOOLEAN_INDEX_SCALE = unsafe.arrayIndexScale(boolean[].class);
        ARRAY_BYTE_INDEX_SCALE = unsafe.arrayIndexScale(byte[].class);
        ARRAY_SHORT_INDEX_SCALE = unsafe.arrayIndexScale(short[].class);
        ARRAY_CHAR_INDEX_SCALE = unsafe.arrayIndexScale(char[].class);
        ARRAY_INT_INDEX_SCALE = unsafe.arrayIndexScale(int[].class);
        ARRAY_LONG_INDEX_SCALE = unsafe.arrayIndexScale(long[].class);
        ARRAY_FLOAT_INDEX_SCALE = unsafe.arrayIndexScale(float[].class);
        ARRAY_DOUBLE_INDEX_SCALE = unsafe.arrayIndexScale(double[].class);
        ARRAY_OBJECT_INDEX_SCALE = unsafe.arrayIndexScale(Object[].class);
        int addressSize = unsafe.addressSize();
        int referenceSize = unsafe.arrayIndexScale(Object[].class);
        ADDRESS_MODE = addressSize == 4 ? AddressMode.MEM_32BIT : (addressSize == 8 && referenceSize == 8 ? AddressMode.MEM_64BIT : (addressSize == 8 && referenceSize == 4 ? AddressMode.MEM_64BIT_COMPRESSED_OOPS : AddressMode.UNKNOWN));
    }

    public static enum AddressMode {
        UNKNOWN,
        MEM_32BIT,
        MEM_64BIT,
        MEM_64BIT_COMPRESSED_OOPS;

    }
}

