/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ClassUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog(VersionInfo.class);
    private Properties info = new Properties();
    private static VersionInfo TAJO_VERSION_INFO = new VersionInfo("tajo");

    protected VersionInfo(String component) {
        String versionInfoFile = component + "-version-info.properties";
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionInfoFile);
            if (is == null) {
                throw new IOException("Resource not found");
            }
            this.info.load(is);
        }
        catch (IOException ex) {
            LogFactory.getLog(this.getClass()).warn((Object)("Could not read '" + versionInfoFile + "', " + ex.toString()), (Throwable)ex);
        }
    }

    protected String _getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    protected String _getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    protected String _getBranch() {
        return this.info.getProperty("branch", "Unknown");
    }

    protected String _getDate() {
        return this.info.getProperty("date", "Unknown");
    }

    protected String _getUser() {
        return this.info.getProperty("user", "Unknown");
    }

    protected String _getUrl() {
        return this.info.getProperty("url", "Unknown");
    }

    protected String _getSrcChecksum() {
        return this.info.getProperty("srcChecksum", "Unknown");
    }

    protected String _getBuildVersion() {
        return VersionInfo.getVersion() + " from " + this._getRevision() + " by " + this._getUser() + " source checksum " + this._getSrcChecksum();
    }

    protected String _getProtocVersion() {
        return this.info.getProperty("protocVersion", "Unknown");
    }

    public static String getVersion() {
        return TAJO_VERSION_INFO._getVersion();
    }

    public static String getRevision() {
        return TAJO_VERSION_INFO._getRevision();
    }

    public static String getBranch() {
        return TAJO_VERSION_INFO._getBranch();
    }

    public static String getDate() {
        return TAJO_VERSION_INFO._getDate();
    }

    public static String getUser() {
        return TAJO_VERSION_INFO._getUser();
    }

    public static String getUrl() {
        return TAJO_VERSION_INFO._getUrl();
    }

    public static String getSrcChecksum() {
        return TAJO_VERSION_INFO._getSrcChecksum();
    }

    public static String getBuildVersion() {
        return TAJO_VERSION_INFO._getBuildVersion();
    }

    public static String getProtocVersion() {
        return TAJO_VERSION_INFO._getProtocVersion();
    }

    public static String getDisplayVersion() {
        StringBuilder displayVersion = new StringBuilder("Tajo ").append(VersionInfo.getVersion()).append(" (").append("rev. " + VersionInfo.getRevision().substring(0, 7)).append(" source checksum ").append(VersionInfo.getSrcChecksum().substring(0, 7)).append(" compiled by ").append(VersionInfo.getUser()).append(" ").append(VersionInfo.getDate()).append(")");
        return displayVersion.toString();
    }

    public static void main(String[] args) {
        LOG.debug((Object)("version: " + VersionInfo.getVersion()));
        System.out.println("Tajo " + VersionInfo.getVersion());
        System.out.println("Git " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("Compiled with protoc " + VersionInfo.getProtocVersion());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
        System.out.println("This command was run using " + ClassUtil.findContainingJar(VersionInfo.class));
    }
}

