/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.datetime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class DateTimeFormat {
    static final String[] months_full = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", null};
    static String[] days_short = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", null};
    static String[] months_short = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", null};
    static String[] days_full = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", null};
    static int[][] ysum = new int[][]{{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365}, {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366}};
    static final String A_D_STR = "A.D.";
    static final String a_d_STR = "a.d.";
    static final String AD_STR = "AD";
    static final String ad_STR = "ad";
    static final String B_C_STR = "B.C.";
    static final String b_c_STR = "b.c.";
    static final String BC_STR = "BC";
    static final String bc_STR = "bc";
    static final String[] adbc_strings = new String[]{"ad", "bc", "AD", "BC", null};
    static final String[] adbc_strings_long = new String[]{"a.d.", "b.c.", "A.D.", "B.C.", null};
    static final String A_M_STR = "A.M.";
    static final String a_m_STR = "a.m.";
    static final String AM_STR = "AM";
    static final String am_STR = "am";
    static final String P_M_STR = "P.M.";
    static final String p_m_STR = "p.m.";
    static final String PM_STR = "PM";
    static final String pm_STR = "pm";
    static final String[] ampm_strings = new String[]{"am", "pm", "AM", "PM", null};
    static final String[] ampm_strings_long = new String[]{"a.m.", "p.m.", "A.M.", "P.M.", null};
    static final String[] rm_months_upper = new String[]{"XII", "XI", "X", "IX", "VIII", "VII", "VI", "V", "IV", "III", "II", "I", null};
    static final String[] rm_months_lower = new String[]{"xii", "xi", "x", "ix", "viii", "vii", "vi", "v", "iv", "iii", "ii", "i", null};
    static final String[] rm1 = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", null};
    static final String[] rm10 = new String[]{"X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", null};
    static final String[] rm100 = new String[]{"C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", null};
    static final String[] numTH = new String[]{"ST", "ND", "RD", "TH", null};
    static final String[] numth = new String[]{"st", "nd", "rd", "th", null};
    static final int ONE_UPPER = 1;
    static final int ALL_UPPER = 2;
    static final int ALL_LOWER = 3;
    static final int MAX_MONTH_LEN = 9;
    static final int MAX_MON_LEN = 3;
    static final int MAX_DAY_LEN = 9;
    static final int MAX_DY_LEN = 3;
    static final int MAX_RM_LEN = 4;
    static final int DCH_S_FM = 1;
    static final int DCH_S_TH = 2;
    static final int DCH_S_th = 4;
    static final int DCH_S_SP = 8;
    static final int DCH_S_TM = 16;
    static final int NODE_TYPE_END = 1;
    static final int NODE_TYPE_ACTION = 2;
    static final int NODE_TYPE_CHAR = 3;
    static final int SUFFTYPE_PREFIX = 1;
    static final int SUFFTYPE_POSTFIX = 2;
    static final int CLOCK_24_HOUR = 0;
    static final int CLOCK_12_HOUR = 1;
    static final int MONTHS_PER_YEAR = 12;
    static final int HOURS_PER_DAY = 24;
    static final int DCH_MAX_ITEM_SIZ = 9;
    static final int NUM_MAX_ITEM_SIZ = 8;
    static KeySuffix[] DCH_suff = new KeySuffix[]{new KeySuffix("FM", 2, 1, 1), new KeySuffix("fm", 2, 1, 1), new KeySuffix("TM", 2, 16, 1), new KeySuffix("tm", 2, 16, 1), new KeySuffix("TH", 2, 2, 2), new KeySuffix("th", 2, 4, 2), new KeySuffix("SP", 2, 8, 2)};
    static final Object[][] DCH_keywordValues = new Object[][]{{"A.D.", 4, DCH_poz.DCH_A_D, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"A.M.", 4, DCH_poz.DCH_A_M, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"AD", 2, DCH_poz.DCH_AD, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"AM", 2, DCH_poz.DCH_AM, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"B.C.", 4, DCH_poz.DCH_B_C, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"BC", 2, DCH_poz.DCH_BC, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"CC", 2, DCH_poz.DCH_CC, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"DAY", 3, DCH_poz.DCH_DAY, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"DDD", 3, DCH_poz.DCH_DDD, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"DD", 2, DCH_poz.DCH_DD, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"DY", 2, DCH_poz.DCH_DY, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"Day", 3, DCH_poz.DCH_Day, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"Dy", 2, DCH_poz.DCH_Dy, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"D", 1, DCH_poz.DCH_D, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"FX", 2, DCH_poz.DCH_FX, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"HH24", 4, DCH_poz.DCH_HH24, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"HH12", 4, DCH_poz.DCH_HH12, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"HH", 2, DCH_poz.DCH_HH, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"IDDD", 4, DCH_poz.DCH_IDDD, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"ID", 2, DCH_poz.DCH_ID, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"IW", 2, DCH_poz.DCH_IW, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"IYYY", 4, DCH_poz.DCH_IYYY, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"IYY", 3, DCH_poz.DCH_IYY, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"IY", 2, DCH_poz.DCH_IY, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"I", 1, DCH_poz.DCH_I, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"J", 1, DCH_poz.DCH_J, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"MI", 2, DCH_poz.DCH_MI, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"MM", 2, DCH_poz.DCH_MM, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"MONTH", 5, DCH_poz.DCH_MONTH, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"MON", 3, DCH_poz.DCH_MON, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"MS", 2, DCH_poz.DCH_MS, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"Month", 5, DCH_poz.DCH_Month, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"Mon", 3, DCH_poz.DCH_Mon, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"P.M.", 4, DCH_poz.DCH_P_M, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"PM", 2, DCH_poz.DCH_PM, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"Q", 1, DCH_poz.DCH_Q, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"RM", 2, DCH_poz.DCH_RM, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"SSSS", 4, DCH_poz.DCH_SSSS, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"SS", 2, DCH_poz.DCH_SS, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"TZ", 2, DCH_poz.DCH_TZ, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"US", 2, DCH_poz.DCH_US, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"WW", 2, DCH_poz.DCH_WW, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"W", 1, DCH_poz.DCH_W, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"Y,YYY", 5, DCH_poz.DCH_Y_YYY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"YYYY", 4, DCH_poz.DCH_YYYY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"YYY", 3, DCH_poz.DCH_YYY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"YY", 2, DCH_poz.DCH_YY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"Y", 1, DCH_poz.DCH_Y, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"a.d.", 4, DCH_poz.DCH_a_d, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"a.m.", 4, DCH_poz.DCH_a_m, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"ad", 2, DCH_poz.DCH_ad, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"am", 2, DCH_poz.DCH_am, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"b.c.", 4, DCH_poz.DCH_b_c, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"bc", 2, DCH_poz.DCH_bc, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"cc", 2, DCH_poz.DCH_CC, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"day", 3, DCH_poz.DCH_day, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"ddd", 3, DCH_poz.DCH_DDD, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"dd", 2, DCH_poz.DCH_DD, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"dy", 2, DCH_poz.DCH_dy, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"d", 1, DCH_poz.DCH_D, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"fx", 2, DCH_poz.DCH_FX, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"hh24", 4, DCH_poz.DCH_HH24, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"hh12", 4, DCH_poz.DCH_HH12, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"hh", 2, DCH_poz.DCH_HH, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"iddd", 4, DCH_poz.DCH_IDDD, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"id", 2, DCH_poz.DCH_ID, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"iw", 2, DCH_poz.DCH_IW, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"iyyy", 4, DCH_poz.DCH_IYYY, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"iyy", 3, DCH_poz.DCH_IYY, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"iy", 2, DCH_poz.DCH_IY, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"i", 1, DCH_poz.DCH_I, true, FromCharDateMode.FROM_CHAR_DATE_ISOWEEK}, {"j", 1, DCH_poz.DCH_J, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"mi", 2, DCH_poz.DCH_MI, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"mm", 2, DCH_poz.DCH_MM, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"month", 5, DCH_poz.DCH_month, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"mon", 3, DCH_poz.DCH_mon, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"ms", 2, DCH_poz.DCH_MS, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"p.m.", 4, DCH_poz.DCH_p_m, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"pm", 2, DCH_poz.DCH_pm, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"q", 1, DCH_poz.DCH_Q, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"rm", 2, DCH_poz.DCH_rm, false, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"ssss", 4, DCH_poz.DCH_SSSS, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"ss", 2, DCH_poz.DCH_SS, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"tz", 2, DCH_poz.DCH_tz, false, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"us", 2, DCH_poz.DCH_US, true, FromCharDateMode.FROM_CHAR_DATE_NONE}, {"ww", 2, DCH_poz.DCH_WW, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"w", 1, DCH_poz.DCH_W, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"y,yyy", 5, DCH_poz.DCH_Y_YYY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"yyyy", 4, DCH_poz.DCH_YYYY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"yyy", 3, DCH_poz.DCH_YYY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"yy", 2, DCH_poz.DCH_YY, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}, {"y", 1, DCH_poz.DCH_Y, true, FromCharDateMode.FROM_CHAR_DATE_GREGORIAN}};
    static final KeyWord[] DCH_keywords = new KeyWord[DCH_keywordValues.length];
    static Map<Character, Integer> DCH_index = new HashMap<Character, Integer>();
    static Map<String, FormatNode[]> formatNodeCache;
    static final int TH_UPPER = 1;
    static final int TH_LOWER = 2;
    private static final char[][] zeroStrings;

    static int ADJUST_YEAR(int year, boolean is_interval) {
        return is_interval ? year : (year <= 0 ? -(year - 1) : year);
    }

    static int SKIP_THth(int suf) {
        return DateTimeFormat.S_THth(suf) != 0 ? 2 : 0;
    }

    static int S_THth(int s) {
        return (s & 2) != 0 || (s & 4) != 0 ? 1 : 0;
    }

    static int S_TH(int s) {
        return (s & 2) != 0 ? 1 : 0;
    }

    static int S_th(int s) {
        return (s & 4) != 0 ? 1 : 0;
    }

    static int S_TH_TYPE(int s) {
        return (s & 2) != 0 ? 1 : 2;
    }

    static int S_FM(int s) {
        return (s & 1) != 0 ? 1 : 0;
    }

    static int S_SP(int s) {
        return (s & 8) != 0 ? 1 : 0;
    }

    static int S_TM(int s) {
        return (s & 0x10) != 0 ? 1 : 0;
    }

    public static TimeMeta parseDateTime(String dateText, String formatText) {
        TimeMeta tm = new TimeMeta();
        DateTimeFormat.doToTimestamp(dateText, formatText, tm);
        if (tm.dayOfMonth == 0) {
            tm.dayOfMonth = 1;
        }
        if (tm.dayOfYear > 0 && tm.dayOfMonth > 0) {
            tm.dayOfYear = 0;
        }
        return tm;
    }

    public static TimestampDatum toTimestamp(String dateText, String formatText) {
        TimeMeta tm = DateTimeFormat.parseDateTime(dateText, formatText);
        return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doToTimestamp(String dateText, String formatText, TimeMeta tm) {
        TmFromChar tmfc = new TmFromChar();
        int formatLength = formatText.length();
        if (formatLength > 0) {
            FormatNode[] formatNodes;
            Map<String, FormatNode[]> map = formatNodeCache;
            synchronized (map) {
                formatNodes = formatNodeCache.get(formatText);
            }
            if (formatNodes == null) {
                formatNodes = new FormatNode[formatLength + 1];
                for (int i = 0; i < formatNodes.length; ++i) {
                    formatNodes[i] = new FormatNode();
                }
                DateTimeFormat.parseFormat(formatNodes, formatText, FORMAT_TYPE.DCH_TYPE);
                formatNodes[formatLength].type = 1;
                Map<String, FormatNode[]> i = formatNodeCache;
                synchronized (i) {
                    formatNodeCache.put(formatText, formatNodes);
                }
            }
            DateTimeFormat.DCH_from_char(formatNodes, dateText, tmfc);
        }
        if (tmfc.ssss != 0) {
            int x = tmfc.ssss;
            tm.hours = x / 3600;
            tm.minutes = (x %= 3600) / 60;
            tm.secs = x %= 60;
        }
        if (tmfc.ss != 0) {
            tm.secs = tmfc.ss;
        }
        if (tmfc.mi != 0) {
            tm.minutes = tmfc.mi;
        }
        if (tmfc.hh != 0) {
            tm.hours = tmfc.hh;
        }
        if (tmfc.clock == 1) {
            if (tm.hours < 1 || tm.hours > 12) {
                throw new IllegalArgumentException("hour \"" + tm.hours + "\" is invalid for the 12-hour clock, " + "Use the 24-hour clock, or give an hour between 1 and 12.");
            }
            if (tmfc.pm != 0 && tm.hours < 12) {
                tm.hours += 12;
            } else if (tmfc.pm == 0 && tm.hours == 12) {
                tm.hours = 0;
            }
        }
        if (tmfc.year != 0) {
            if (tmfc.cc != 0 && tmfc.yysz <= 2) {
                if (tmfc.bc != 0) {
                    tmfc.cc = -tmfc.cc;
                }
                tm.years = tmfc.year % 100;
                tm.years = tm.years != 0 ? (tmfc.cc >= 0 ? (tm.years += (tmfc.cc - 1) * 100) : (tmfc.cc + 1) * 100 - tm.years + 1) : tmfc.cc * 100 + (tmfc.cc >= 0 ? 0 : 1);
            } else {
                tm.years = tmfc.year;
                if (tmfc.bc != 0 && tm.years > 0) {
                    tm.years = -(tm.years - 1);
                }
            }
        } else if (tmfc.cc != 0) {
            if (tmfc.bc != 0) {
                tmfc.cc = -tmfc.cc;
            }
            tm.years = tmfc.cc >= 0 ? (tmfc.cc - 1) * 100 + 1 : tmfc.cc * 100 + 1;
        }
        if (tmfc.j != 0) {
            DateTimeUtil.j2date(tmfc.j, tm);
        }
        if (tmfc.ww != 0) {
            if (tmfc.mode == FromCharDateMode.FROM_CHAR_DATE_ISOWEEK) {
                if (tmfc.d != 0) {
                    DateTimeUtil.isoweekdate2date(tmfc.ww, tmfc.d, tm);
                } else {
                    DateTimeUtil.isoweek2date(tmfc.ww, tm);
                }
            } else {
                tmfc.ddd = (tmfc.ww - 1) * 7 + 1;
            }
        }
        if (tmfc.w != 0) {
            tmfc.dd = (tmfc.w - 1) * 7 + 1;
        }
        if (tmfc.d != 0) {
            // empty if block
        }
        if (tmfc.dd != 0) {
            tm.dayOfMonth = tmfc.dd;
        }
        if (tmfc.ddd != 0) {
            tm.dayOfYear = tmfc.ddd;
        }
        if (tmfc.mm != 0) {
            tm.monthOfYear = tmfc.mm;
        }
        if (tmfc.ddd != 0 && (tm.monthOfYear <= 1 || tm.dayOfMonth <= 1)) {
            if (tm.years == 0 && tmfc.bc == 0) {
                throw new IllegalArgumentException("cannot calculate day of year without year information");
            }
            if (tmfc.mode == FromCharDateMode.FROM_CHAR_DATE_ISOWEEK) {
                int j0 = DateTimeUtil.isoweek2j(tm.years, 1) - 1;
                DateTimeUtil.j2date(j0 + tmfc.ddd, tm);
            } else {
                int i;
                boolean leap = DateTimeUtil.isLeapYear(tm.years);
                int[] y = ysum[leap ? 1 : 0];
                for (i = 1; i <= 12 && tmfc.ddd >= y[i]; ++i) {
                }
                if (tm.monthOfYear <= 1) {
                    tm.monthOfYear = i;
                }
                if (tm.dayOfMonth <= 1) {
                    tm.dayOfMonth = tmfc.ddd - y[i - 1];
                }
                tm.dayOfYear = 0;
            }
        }
        if (tmfc.ms != 0) {
            tm.fsecs += tmfc.ms * 1000;
        }
        if (tmfc.us != 0) {
            tm.fsecs += tmfc.us;
        }
    }

    static void parseFormat(FormatNode[] node, String str, FORMAT_TYPE ver) {
        boolean node_set = false;
        int last = 0;
        int nodeIndex = 0;
        int charIdx = 0;
        char[] chars = str.toCharArray();
        while (charIdx < chars.length) {
            KeySuffix s;
            int suffix = 0;
            if (ver == FORMAT_TYPE.DCH_TYPE && (s = DateTimeFormat.suff_search(chars, charIdx, 1)) != null) {
                suffix |= s.id;
                if (s.len > 0) {
                    charIdx += s.len;
                }
            }
            if (charIdx < chars.length && (node[nodeIndex].key = DateTimeFormat.index_seq_search(chars, charIdx)) != null) {
                node[nodeIndex].type = 2;
                node[nodeIndex].suffix = 0;
                node_set = true;
                if (node[nodeIndex].key.len > 0) {
                    charIdx += node[nodeIndex].key.len;
                }
                if (ver == FORMAT_TYPE.NUM_TYPE) {
                    // empty if block
                }
                if (ver == FORMAT_TYPE.DCH_TYPE && charIdx < chars.length && (s = DateTimeFormat.suff_search(chars, charIdx, 2)) != null) {
                    suffix |= s.id;
                    if (s.len > 0) {
                        charIdx += s.len;
                    }
                }
            } else if (charIdx < chars.length) {
                if (chars[charIdx] == '\"' && last != 92) {
                    int x = 0;
                    while (charIdx < chars.length) {
                        if (chars[++charIdx] == '\"' && x != 92) {
                            ++charIdx;
                            break;
                        }
                        if (chars[charIdx] == '\\' && x != 92) {
                            x = 92;
                            continue;
                        }
                        node[nodeIndex].type = 3;
                        node[nodeIndex].character = chars[charIdx];
                        node[nodeIndex].key = null;
                        node[nodeIndex].suffix = 0;
                        ++nodeIndex;
                        x = chars[charIdx];
                    }
                    node_set = false;
                    suffix = 0;
                    last = 0;
                } else if (charIdx < chars.length - 1 && chars[charIdx] == '\\' && last != 92 && chars[charIdx + 1] == '\"') {
                    last = chars[charIdx];
                    ++charIdx;
                } else if (charIdx < chars.length) {
                    node[nodeIndex].type = 3;
                    node[nodeIndex].character = chars[charIdx];
                    node[nodeIndex].key = null;
                    node_set = true;
                    last = 0;
                    ++charIdx;
                }
            }
            if (!node_set) continue;
            if (node[nodeIndex].type == 2) {
                node[nodeIndex].suffix = suffix;
            }
            node[++nodeIndex].suffix = 0;
            node_set = false;
        }
        node[nodeIndex].type = 1;
        node[nodeIndex].suffix = 0;
    }

    static void DCH_from_char(FormatNode[] nodes, String dateText, TmFromChar out) {
        AtomicInteger value = new AtomicInteger();
        boolean fx_mode = false;
        char[] chars = dateText.toCharArray();
        int charIdx = 0;
        block37: for (int nodeIdx = 0; nodeIdx < nodes.length; ++nodeIdx) {
            FormatNode node = nodes[nodeIdx];
            if (node.type == 1 || charIdx >= chars.length) break;
            if (node.type != 2) {
                ++charIdx;
                if (!Character.isSpaceChar(node.character) || fx_mode) continue;
                while (charIdx < chars.length && Character.isSpaceChar(chars[charIdx])) {
                    ++charIdx;
                }
                continue;
            }
            DateTimeFormat.from_char_set_mode(out, node.key.date_mode);
            switch (node.key.idType) {
                case DCH_FX: {
                    fx_mode = true;
                    continue block37;
                }
                case DCH_A_M: 
                case DCH_P_M: 
                case DCH_a_m: 
                case DCH_p_m: {
                    value.set(out.pm);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, ampm_strings_long, 2, node.key.len, node);
                    DateTimeFormat.assertOutValue(out.pm, value.get() % 2, node);
                    out.pm = value.get() % 2;
                    out.clock = 1;
                    continue block37;
                }
                case DCH_AM: 
                case DCH_PM: 
                case DCH_am: 
                case DCH_pm: {
                    value.set(out.pm);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, ampm_strings, 2, node.key.len, node);
                    DateTimeFormat.assertOutValue(out.pm, value.get() % 2, node);
                    out.pm = value.get() % 2;
                    out.clock = 1;
                    continue block37;
                }
                case DCH_HH: 
                case DCH_HH12: {
                    value.set(out.hh);
                    charIdx += DateTimeFormat.from_char_parse_int_len(value, dateText, charIdx, 2, nodes, nodeIdx);
                    out.hh = value.get();
                    out.clock = 1;
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_HH24: {
                    value.set(out.hh);
                    charIdx += DateTimeFormat.from_char_parse_int_len(value, dateText, charIdx, 2, nodes, nodeIdx);
                    out.hh = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_MI: {
                    value.set(out.mi);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.mi = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_SS: {
                    value.set(out.ss);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.ss = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_MS: {
                    value.set(out.ms);
                    int len = DateTimeFormat.from_char_parse_int_len(value, dateText, charIdx, 3, nodes, nodeIdx);
                    charIdx += len;
                    out.ms = value.get();
                    out.ms = out.ms * (len == 1 ? 100 : (len == 2 ? 10 : 1));
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_US: {
                    value.set(out.us);
                    int len = DateTimeFormat.from_char_parse_int_len(value, dateText, charIdx, 6, nodes, nodeIdx);
                    charIdx += len;
                    out.us = value.get();
                    out.us = out.us * (len == 1 ? 100000 : (len == 2 ? 10000 : (len == 3 ? 1000 : (len == 4 ? 100 : (len == 5 ? 10 : 1)))));
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_SSSS: {
                    value.set(out.ssss);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.ssss = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_tz: 
                case DCH_TZ: {
                    throw new IllegalArgumentException("\"TZ\"/\"tz\" format patterns are not supported in to_date");
                }
                case DCH_A_D: 
                case DCH_B_C: 
                case DCH_a_d: 
                case DCH_b_c: {
                    value.set(out.bc);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, adbc_strings_long, 2, node.key.len, node);
                    DateTimeFormat.assertOutValue(out.bc, value.get() % 2, node);
                    out.bc = value.get() % 2;
                    continue block37;
                }
                case DCH_AD: 
                case DCH_BC: 
                case DCH_ad: 
                case DCH_bc: {
                    value.set(out.bc);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, adbc_strings, 2, node.key.len, node);
                    DateTimeFormat.assertOutValue(out.bc, value.get() % 2, node);
                    out.bc = value.get() % 2;
                    continue block37;
                }
                case DCH_MONTH: 
                case DCH_Month: 
                case DCH_month: {
                    value.set(out.mm);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, months_full, 1, 9, node);
                    DateTimeFormat.assertOutValue(out.mm, value.get() + 1, node);
                    out.mm = value.get() + 1;
                    continue block37;
                }
                case DCH_MON: 
                case DCH_Mon: 
                case DCH_mon: {
                    value.set(out.mm);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, months_short, 1, 3, node);
                    DateTimeFormat.assertOutValue(out.mm, value.get() + 1, node);
                    out.mm = value.get() + 1;
                    continue block37;
                }
                case DCH_MM: {
                    value.set(out.mm);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.mm = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_DAY: 
                case DCH_Day: 
                case DCH_day: {
                    value.set(out.d);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, days_full, 1, 9, node);
                    DateTimeFormat.assertOutValue(out.d, value.get(), node);
                    out.d = value.get();
                    ++out.d;
                    continue block37;
                }
                case DCH_DY: 
                case DCH_Dy: 
                case DCH_dy: {
                    value.set(out.d);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, days_full, 1, 3, node);
                    DateTimeFormat.assertOutValue(out.d, value.get(), node);
                    out.d = value.get();
                    ++out.d;
                    continue block37;
                }
                case DCH_DDD: {
                    value.set(out.ddd);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.ddd = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_IDDD: {
                    value.set(out.ddd);
                    charIdx += DateTimeFormat.from_char_parse_int_len(value, dateText, charIdx, 3, nodes, nodeIdx);
                    out.ddd = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_DD: {
                    value.set(out.dd);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.dd = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_D: {
                    value.set(out.d);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.d = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_ID: {
                    value.set(out.d);
                    charIdx += DateTimeFormat.from_char_parse_int_len(value, dateText, charIdx, 1, nodes, nodeIdx);
                    out.d = value.get();
                    if (++out.d > 7) {
                        out.d = 1;
                    }
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_WW: 
                case DCH_IW: {
                    value.set(out.ww);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.ww = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_Q: {
                    charIdx += DateTimeFormat.from_char_parse_int(null, dateText, charIdx, nodes, nodeIdx);
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_CC: {
                    value.set(out.cc);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.cc = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_Y_YYY: {
                    int commaIndex = dateText.indexOf(",", charIdx);
                    if (commaIndex <= 0) {
                        throw new IllegalArgumentException("invalid input string for \"Y,YYY\"");
                    }
                    int millenia = Integer.parseInt(dateText.substring(charIdx, commaIndex));
                    int years = Integer.parseInt(dateText.substring(commaIndex + 1, commaIndex + 1 + 3));
                    DateTimeFormat.assertOutValue(out.year, years += millenia * 1000, node);
                    out.year = years;
                    out.yysz = 4;
                    charIdx += DateTimeFormat.strdigits_len(dateText, charIdx) + 4 + DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_YYYY: 
                case DCH_IYYY: {
                    value.set(out.year);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.year = value.get();
                    out.yysz = 4;
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_YYY: 
                case DCH_IYY: {
                    int retVal = DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    charIdx += retVal;
                    out.year = value.get();
                    if (retVal < 4) {
                        out.year = DateTimeFormat.adjust_partial_year_to_2020(out.year);
                    }
                    out.yysz = 3;
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_YY: 
                case DCH_IY: {
                    value.set(out.year);
                    int retVal = DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    charIdx += retVal;
                    out.year = value.get();
                    if (retVal < 4) {
                        out.year = DateTimeFormat.adjust_partial_year_to_2020(out.year);
                    }
                    out.yysz = 2;
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_Y: 
                case DCH_I: {
                    value.set(out.year);
                    int retVal = DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    charIdx += retVal;
                    out.year = value.get();
                    if (retVal < 4) {
                        out.year = DateTimeFormat.adjust_partial_year_to_2020(out.year);
                    }
                    out.yysz = 1;
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_RM: {
                    value.set(out.mm);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, rm_months_upper, 2, 4, node);
                    DateTimeFormat.assertOutValue(out.mm, 12 - value.get(), node);
                    out.mm = 12 - value.get();
                    continue block37;
                }
                case DCH_rm: {
                    value.set(out.mm);
                    charIdx += DateTimeFormat.from_char_seq_search(value, dateText, charIdx, rm_months_lower, 3, 4, node);
                    DateTimeFormat.assertOutValue(out.mm, 12 - value.get(), node);
                    out.mm = 12 - value.get();
                    continue block37;
                }
                case DCH_W: {
                    value.set(out.w);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.w = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
                case DCH_J: {
                    value.set(out.j);
                    charIdx += DateTimeFormat.from_char_parse_int(value, dateText, charIdx, nodes, nodeIdx);
                    out.j = value.get();
                    charIdx += DateTimeFormat.SKIP_THth(node.suffix);
                    continue block37;
                }
            }
        }
    }

    static KeySuffix suff_search(char[] chars, int startIdx, int type) {
        for (KeySuffix eachSuffix : DCH_suff) {
            if (eachSuffix.type != type || !DateTimeFormat.strncmp(chars, startIdx, eachSuffix.name, eachSuffix.len)) continue;
            return eachSuffix;
        }
        return null;
    }

    static KeyWord index_seq_search(char[] chars, int startIdx) {
        if (DateTimeFormat.KeyWord_INDEX_FILTER(chars[startIdx]) == 0) {
            return null;
        }
        Integer pos = DCH_index.get(Character.valueOf(chars[startIdx]));
        if (pos != null) {
            KeyWord keyword = DCH_keywords[pos];
            do {
                if (DateTimeFormat.strncmp(chars, startIdx, keyword.name, keyword.len)) {
                    return keyword;
                }
                Integer n = pos;
                Integer n2 = pos = Integer.valueOf(pos + 1);
                if (pos >= DCH_keywords.length) {
                    return null;
                }
                keyword = DCH_keywords[pos];
            } while (chars[startIdx] == keyword.name.charAt(0));
        }
        return null;
    }

    static boolean strncmp(char[] chars, int startIdx, String str, int len) {
        if (chars.length - startIdx < len) {
            return false;
        }
        int index = startIdx;
        int i = 0;
        while (i < len) {
            if (chars[index] != str.charAt(i)) {
                return false;
            }
            ++i;
            ++index;
        }
        return true;
    }

    static int KeyWord_INDEX_FILTER(char c) {
        return c <= ' ' || c >= '~' ? 0 : 1;
    }

    static void from_char_set_mode(TmFromChar tmfc, FromCharDateMode mode) {
        if (mode != FromCharDateMode.FROM_CHAR_DATE_NONE) {
            if (tmfc.mode == FromCharDateMode.FROM_CHAR_DATE_NONE) {
                tmfc.mode = mode;
            } else if (tmfc.mode != mode) {
                throw new IllegalArgumentException("invalid combination of date conventions: Do not mix Gregorian and ISO week date conventions in a formatting template.");
            }
        }
    }

    static int from_char_seq_search(AtomicInteger dest, String src, int charIdx, String[] array, int type, int max, FormatNode node) {
        AtomicInteger len = new AtomicInteger(0);
        dest.set(DateTimeFormat.seq_search(src, charIdx, array, type, max, len));
        if (len.get() <= 0) {
            String copy = charIdx + node.key.len >= src.length() ? src.substring(charIdx, charIdx + node.key.len) : src.substring(charIdx);
            throw new IllegalArgumentException("Invalid value \"" + copy + "\" for \"" + node.key.name + "\". " + "The given value did not match any of the allowed values for this field.");
        }
        return len.get();
    }

    static int seq_search(String name, int charIdx, String[] array, int type, int max, AtomicInteger len) {
        if (name == null || name.length() <= charIdx) {
            return -1;
        }
        char[] nameChars = name.toCharArray();
        char nameChar = nameChars[charIdx];
        if (type == 1 || type == 2) {
            nameChar = Character.toUpperCase(nameChar);
        } else if (type == 3) {
            nameChar = Character.toLowerCase(nameChar);
        }
        int arrayIndex = 0;
        int last = 0;
        while (array[arrayIndex] != null) {
            String arrayStr = array[arrayIndex];
            if (nameChar == arrayStr.charAt(0)) {
                int arrayStrLen = arrayStr.length();
                int arrayCharIdx = 1;
                int nameCharIdx = charIdx + 1;
                int idx = 1;
                while (true) {
                    if (max != 0 && idx == max) {
                        len.set(idx + 1);
                        return arrayIndex;
                    }
                    if (arrayCharIdx == arrayStrLen - 1) {
                        len.set(idx + 1);
                        return arrayIndex;
                    }
                    if (nameCharIdx == nameChars.length - 1) break;
                    nameChar = nameChars[nameCharIdx];
                    if (idx > last) {
                        if (type == 1 || type == 3) {
                            nameChar = Character.toLowerCase(nameChar);
                        } else if (type == 2) {
                            nameChar = Character.toUpperCase(nameChar);
                        }
                        last = idx;
                    }
                    if (nameChar != arrayStr.charAt(arrayCharIdx)) break;
                    ++nameCharIdx;
                    ++arrayCharIdx;
                    ++idx;
                }
            }
            ++arrayIndex;
        }
        return -1;
    }

    static int from_char_parse_int_len(AtomicInteger dest, String src, int charIdx, int len, FormatNode[] nodes, int nodeIndex) {
        long result;
        int used;
        int initCharIdx = charIdx;
        StringBuilder tempSb = new StringBuilder();
        charIdx = DateTimeFormat.strspace_len(src, charIdx);
        int n = used = src.length() <= charIdx + len ? src.length() - (charIdx + len) : len;
        if (used <= 0) {
            used = src.length() - charIdx;
        }
        String copy = src.substring(charIdx, charIdx + used);
        if (DateTimeFormat.S_FM(nodes[nodeIndex].suffix) != 0 || DateTimeFormat.is_next_separator(nodes, nodeIndex)) {
            result = DateTimeUtil.strtol(src, charIdx, tempSb);
            charIdx = src.length() - tempSb.length();
        } else {
            if (used < len) {
                throw new IllegalArgumentException("source string too short for \"" + nodes[nodeIndex].key.name + "\" + formatting field");
            }
            result = DateTimeUtil.strtol(copy, 0, tempSb);
            used = copy.length() - tempSb.length();
            if (used > 0 && used < len) {
                throw new IllegalArgumentException("invalid value \"" + copy + "\" for \"" + nodes[nodeIndex].key.name + "\"." + "Field requires " + len + " characters, but only " + used);
            }
            charIdx += used;
        }
        if (charIdx == initCharIdx) {
            throw new IllegalArgumentException("invalid value \"" + copy + "\" for \"" + nodes[nodeIndex].key.name + "\"." + "Value must be an integer.");
        }
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value for \"" + nodes[nodeIndex].key.name + "\"" + " in source string is out of range." + "Value must be in the range " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE + ".");
        }
        if (dest != null) {
            DateTimeFormat.assertOutValue(dest.get(), (int)result, nodes[nodeIndex]);
            dest.set((int)result);
        }
        return charIdx - initCharIdx;
    }

    static int from_char_parse_int(AtomicInteger dest, String src, int charIdx, FormatNode[] nodes, int nodeIdx) {
        return DateTimeFormat.from_char_parse_int_len(dest, src, charIdx, nodes[nodeIdx].key.len, nodes, nodeIdx);
    }

    static int strspace_len(String str, int charIdx) {
        int len = str.length();
        while (charIdx < len && Character.isSpaceChar(str.charAt(charIdx))) {
            ++charIdx;
        }
        return charIdx;
    }

    static int strdigits_len(String str, int charIdx) {
        int len = DateTimeFormat.strspace_len(str, charIdx);
        int strLen = str.length();
        for (int index = charIdx + len; index < strLen && Character.isDigit(str.charAt(index)) && len <= 9; ++len, ++index) {
        }
        return len;
    }

    static void assertOutValue(int dest, int value, FormatNode node) {
        if (dest != 0 && dest != value) {
            throw new IllegalArgumentException("conflicting values for \"" + node.key.name + "\" field in formatting string," + "This value contradicts a previous setting for the same field type(" + dest + "," + value + ")");
        }
    }

    static boolean is_next_separator(FormatNode[] nodes, int nodeIndex) {
        int index = nodeIndex;
        if (nodes[index].type == 1) {
            return false;
        }
        if (nodes[index].type == 2 && DateTimeFormat.S_THth(nodes[index].suffix) != 0) {
            return true;
        }
        if (nodes[++index].type == 1) {
            return true;
        }
        if (nodes[index].type == 2) {
            return !nodes[index].key.is_digit;
        }
        return !Character.isDigit(nodes[index].character);
    }

    static int adjust_partial_year_to_2020(int year) {
        if (year < 70) {
            return year + 2000;
        }
        if (year < 100) {
            return year + 1900;
        }
        if (year < 520) {
            return year + 2000;
        }
        if (year < 1000) {
            return year + 1000;
        }
        return year;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String to_char(TimeMeta tm, String formatText) {
        int fmt_len = formatText.length();
        StringBuilder out = new StringBuilder();
        if (fmt_len > 0) {
            FormatNode[] formatNodes;
            Map<String, FormatNode[]> map = formatNodeCache;
            synchronized (map) {
                formatNodes = formatNodeCache.get(formatText);
            }
            if (formatNodes == null) {
                formatNodes = new FormatNode[fmt_len + 1];
                for (int i = 0; i < formatNodes.length; ++i) {
                    formatNodes[i] = new FormatNode();
                }
                DateTimeFormat.parseFormat(formatNodes, formatText, FORMAT_TYPE.DCH_TYPE);
                formatNodes[fmt_len].type = 1;
                Map<String, FormatNode[]> map2 = formatNodeCache;
                synchronized (map2) {
                    formatNodeCache.put(formatText, formatNodes);
                }
            }
            DateTimeFormat.DCH_to_char(formatNodes, false, tm, out);
            return out.toString();
        }
        throw new IllegalArgumentException("No format text.");
    }

    private static String formatInteger(int value, int size) {
        boolean isPositive = value >= 0;
        int tempValue = isPositive ? value : -value;
        char[] tempArray = Integer.toString(tempValue).toCharArray();
        int targetArraySize = Math.max(tempArray.length, size + (isPositive ? 0 : 1));
        char[] targetArray = new char[targetArraySize];
        if (size > tempArray.length) {
            System.arraycopy(zeroStrings[size], 0, targetArray, targetArraySize - size, size);
        }
        System.arraycopy(tempArray, 0, targetArray, targetArraySize - tempArray.length, tempArray.length);
        if (!isPositive) {
            targetArray[0] = 45;
        }
        return new String(targetArray);
    }

    private static String formatString(String value, int width) {
        boolean isLeftJustified = width < 0;
        int minimalWidth = isLeftJustified ? -width : width;
        String result = value;
        if (minimalWidth > 0 && value != null) {
            char[] tempArray = value.toCharArray();
            int targetArraySize = Math.max(tempArray.length, minimalWidth);
            char[] targetArray = new char[targetArraySize];
            Arrays.fill(targetArray, ' ');
            System.arraycopy(tempArray, 0, targetArray, isLeftJustified ? 0 : targetArraySize - tempArray.length, tempArray.length);
            result = new String(targetArray);
        }
        return result;
    }

    private static void DCH_to_char(FormatNode[] nodes, boolean isInterval, TimeMeta tm, StringBuilder out) {
        block48: for (FormatNode node : nodes) {
            if (node.type == 1) break;
            if (node.type != 2) {
                out.append(node.character);
                continue;
            }
            switch (node.key.idType) {
                case DCH_A_M: 
                case DCH_P_M: {
                    out.append(tm.hours % 24 >= 12 ? P_M_STR : A_M_STR);
                    continue block48;
                }
                case DCH_AM: 
                case DCH_PM: {
                    out.append(tm.hours % 24 >= 12 ? PM_STR : AM_STR);
                    continue block48;
                }
                case DCH_a_m: 
                case DCH_p_m: {
                    out.append(tm.hours % 24 >= 12 ? p_m_STR : a_m_STR);
                    continue block48;
                }
                case DCH_am: 
                case DCH_pm: {
                    out.append(tm.hours % 24 >= 12 ? pm_STR : am_STR);
                    continue block48;
                }
                case DCH_HH: 
                case DCH_HH12: {
                    out.append(DateTimeFormat.formatInteger(tm.hours % 12 == 0 ? 12 : tm.hours % 12, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_HH24: {
                    out.append(DateTimeFormat.formatInteger(tm.hours, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_MI: {
                    out.append(DateTimeFormat.formatInteger(tm.minutes, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_SS: {
                    out.append(DateTimeFormat.formatInteger(tm.secs, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_MS: {
                    out.append(DateTimeFormat.formatInteger((int)((double)tm.fsecs / 1000.0), 3));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_US: {
                    out.append(DateTimeFormat.formatInteger(tm.fsecs, 6));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_SSSS: {
                    out.append(DateTimeFormat.formatInteger(tm.hours * 3600 + tm.minutes * 60 + tm.secs, 0));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_tz: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    continue block48;
                }
                case DCH_A_D: 
                case DCH_B_C: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    out.append(tm.years <= 0 ? B_C_STR : A_D_STR);
                    continue block48;
                }
                case DCH_AD: 
                case DCH_BC: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    out.append(tm.years <= 0 ? BC_STR : AD_STR);
                    continue block48;
                }
                case DCH_a_d: 
                case DCH_b_c: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    out.append(tm.years <= 0 ? b_c_STR : a_d_STR);
                    continue block48;
                }
                case DCH_ad: 
                case DCH_bc: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    out.append(tm.years <= 0 ? bc_STR : ad_STR);
                    continue block48;
                }
                case DCH_MONTH: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (tm.monthOfYear == 0) continue block48;
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(months_full[tm.monthOfYear - 1].toUpperCase());
                        continue block48;
                    }
                    out.append(DateTimeFormat.formatString(months_full[tm.monthOfYear - 1].toUpperCase(), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -9));
                    continue block48;
                }
                case DCH_Month: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (tm.monthOfYear == 0) continue block48;
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(months_full[tm.monthOfYear - 1]);
                        continue block48;
                    }
                    out.append(DateTimeFormat.formatString(months_full[tm.monthOfYear - 1], DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -9));
                    continue block48;
                }
                case DCH_month: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (tm.monthOfYear == 0) continue block48;
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(months_full[tm.monthOfYear - 1].toLowerCase());
                        continue block48;
                    }
                    out.append(DateTimeFormat.formatString(months_full[tm.monthOfYear - 1].toLowerCase(), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -9));
                    continue block48;
                }
                case DCH_MON: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (tm.monthOfYear == 0) continue block48;
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(months_short[tm.monthOfYear - 1].toUpperCase());
                        continue block48;
                    }
                    out.append(months_short[tm.monthOfYear - 1].toUpperCase());
                    continue block48;
                }
                case DCH_Mon: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (tm.monthOfYear == 0) continue block48;
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(months_short[tm.monthOfYear - 1]);
                        continue block48;
                    }
                    out.append(months_short[tm.monthOfYear - 1]);
                    continue block48;
                }
                case DCH_mon: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (tm.monthOfYear == 0) continue block48;
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(months_short[tm.monthOfYear - 1].toLowerCase());
                        continue block48;
                    }
                    out.append(months_short[tm.monthOfYear - 1].toLowerCase());
                    continue block48;
                }
                case DCH_MM: {
                    out.append(DateTimeFormat.formatInteger(tm.monthOfYear, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_DAY: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(days_full[tm.getDayOfWeek()].toUpperCase());
                        continue block48;
                    }
                    out.append(DateTimeFormat.formatString(days_full[tm.getDayOfWeek()].toUpperCase(), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -9));
                    continue block48;
                }
                case DCH_Day: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(days_full[tm.getDayOfWeek()]);
                        continue block48;
                    }
                    out.append(DateTimeFormat.formatString(days_full[tm.getDayOfWeek()], DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -9));
                    continue block48;
                }
                case DCH_day: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(days_full[tm.getDayOfWeek()].toLowerCase());
                        continue block48;
                    }
                    out.append(DateTimeFormat.formatString(days_full[tm.getDayOfWeek()].toLowerCase(), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -9));
                    continue block48;
                }
                case DCH_DY: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(days_short[tm.getDayOfWeek()]);
                        continue block48;
                    }
                    out.append(days_short[tm.getDayOfWeek()]);
                    continue block48;
                }
                case DCH_Dy: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(days_short[tm.getDayOfWeek()]);
                        continue block48;
                    }
                    out.append(days_short[tm.getDayOfWeek()]);
                    continue block48;
                }
                case DCH_dy: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    if (DateTimeFormat.S_TM(node.suffix) != 0) {
                        out.append(days_short[tm.getDayOfWeek()]);
                        continue block48;
                    }
                    out.append(days_short[tm.getDayOfWeek()]);
                    continue block48;
                }
                case DCH_DDD: 
                case DCH_IDDD: {
                    out.append(DateTimeFormat.formatInteger(node.key.idType == DCH_poz.DCH_DDD ? tm.getDayOfYear() : DateTimeUtil.date2isoyearday(tm.years, tm.monthOfYear, tm.dayOfMonth), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 3));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_DD: {
                    out.append(DateTimeFormat.formatInteger(tm.dayOfMonth, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_D: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    out.append(DateTimeFormat.formatInteger(tm.getDayOfWeek() + 1, 0));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_ID: {
                    DateTimeFormat.invalidForInterval(isInterval, node);
                    out.append(DateTimeFormat.formatInteger(tm.getDayOfWeek() == 0 ? 7 : tm.getDayOfWeek(), 0));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_WW: {
                    out.append(DateTimeFormat.formatInteger((tm.getDayOfYear() - 1) / 7 + 1, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_IW: {
                    out.append(DateTimeFormat.formatInteger(DateTimeUtil.date2isoweek(tm.years, tm.monthOfYear, tm.dayOfMonth), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_Q: {
                    if (tm.monthOfYear == 0) continue block48;
                    out.append(DateTimeFormat.formatInteger((tm.monthOfYear - 1) / 3 + 1, 0));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_CC: {
                    int i = isInterval ? tm.years / 100 : (tm.years > 0 ? (tm.years - 1) / 100 + 1 : tm.years / 100 - 1);
                    if (i <= 99 && i >= -99) {
                        out.append(DateTimeFormat.formatInteger(i, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    } else {
                        out.append(DateTimeFormat.formatInteger(i, 0));
                    }
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_Y_YYY: {
                    int i = DateTimeFormat.ADJUST_YEAR(tm.years, isInterval) / 1000;
                    out.append(DateTimeFormat.formatInteger(i, 0)).append(',').append(DateTimeFormat.formatInteger(DateTimeFormat.ADJUST_YEAR(tm.years, isInterval) - i * 1000, 3));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_YYYY: 
                case DCH_IYYY: {
                    out.append(DateTimeFormat.formatInteger(node.key.idType == DCH_poz.DCH_YYYY ? DateTimeFormat.ADJUST_YEAR(tm.years, isInterval) : DateTimeFormat.ADJUST_YEAR(DateTimeUtil.date2isoyear(tm.years, tm.monthOfYear, tm.dayOfMonth), isInterval), DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 4));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_YYY: 
                case DCH_IYY: {
                    out.append(DateTimeFormat.formatInteger((node.key.idType == DCH_poz.DCH_YYY ? DateTimeFormat.ADJUST_YEAR(tm.years, isInterval) : DateTimeFormat.ADJUST_YEAR(DateTimeUtil.date2isoyear(tm.years, tm.monthOfYear, tm.dayOfMonth), isInterval)) % 1000, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 3));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_YY: 
                case DCH_IY: {
                    out.append(DateTimeFormat.formatInteger((node.key.idType == DCH_poz.DCH_YY ? DateTimeFormat.ADJUST_YEAR(tm.years, isInterval) : DateTimeFormat.ADJUST_YEAR(DateTimeUtil.date2isoyear(tm.years, tm.monthOfYear, tm.dayOfMonth), isInterval)) % 100, DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : 2));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_Y: 
                case DCH_I: {
                    out.append(DateTimeFormat.formatInteger((node.key.idType == DCH_poz.DCH_Y ? DateTimeFormat.ADJUST_YEAR(tm.years, isInterval) : DateTimeFormat.ADJUST_YEAR(DateTimeUtil.date2isoyear(tm.years, tm.monthOfYear, tm.dayOfMonth), isInterval)) % 10, 1));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_RM: {
                    if (tm.monthOfYear == 0) continue block48;
                    out.append(DateTimeFormat.formatString(rm_months_upper[12 - tm.monthOfYear], DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -4));
                    continue block48;
                }
                case DCH_rm: {
                    if (tm.monthOfYear == 0) continue block48;
                    out.append(DateTimeFormat.formatString(rm_months_lower[12 - tm.monthOfYear], DateTimeFormat.S_FM(node.suffix) != 0 ? 0 : -4));
                    continue block48;
                }
                case DCH_W: {
                    out.append(DateTimeFormat.formatInteger((tm.dayOfMonth - 1) / 7 + 1, 0));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
                case DCH_J: {
                    out.append(DateTimeFormat.formatInteger(DateTimeUtil.date2j(tm.years, tm.monthOfYear, tm.dayOfMonth), 0));
                    if (DateTimeFormat.S_THth(node.suffix) == 0) continue block48;
                    DateTimeFormat.str_numth(out, out, DateTimeFormat.S_TH_TYPE(node.suffix));
                    continue block48;
                }
            }
        }
    }

    static String get_th(StringBuilder num, int type) {
        int len = num.length();
        char last = num.charAt(len - 1);
        if (!Character.isDigit(last)) {
            throw new IllegalArgumentException("\"" + num.toString() + "\" is not a number");
        }
        if (len > 1 && num.charAt(len - 2) == '1') {
            last = '\u0000';
        }
        switch (last) {
            case '1': {
                if (type == 1) {
                    return numTH[0];
                }
                return numth[0];
            }
            case '2': {
                if (type == 1) {
                    return numTH[1];
                }
                return numth[1];
            }
            case '3': {
                if (type == 1) {
                    return numTH[2];
                }
                return numth[2];
            }
        }
        if (type == 1) {
            return numTH[3];
        }
        return numth[3];
    }

    static void str_numth(StringBuilder dest, StringBuilder num, int type) {
        if (!dest.equals(num)) {
            dest.append((CharSequence)num);
        }
        dest.append(DateTimeFormat.get_th(num, type));
    }

    private static void invalidForInterval(boolean isInterval, FormatNode node) {
        if (isInterval) {
            throw new IllegalArgumentException("\"" + node.key.name + "\" not support for interval");
        }
    }

    static {
        int index = 0;
        for (Object[] eachKeywordValue : DCH_keywordValues) {
            KeyWord keyword = new KeyWord();
            keyword.name = (String)eachKeywordValue[0];
            keyword.len = (Integer)eachKeywordValue[1];
            keyword.idType = (DCH_poz)((Object)eachKeywordValue[2]);
            keyword.is_digit = (Boolean)eachKeywordValue[3];
            keyword.date_mode = (FromCharDateMode)((Object)eachKeywordValue[4]);
            Character c = Character.valueOf(keyword.name.charAt(0));
            Integer pos = DCH_index.get(c);
            if (pos == null) {
                DCH_index.put(c, index);
            }
            DateTimeFormat.DCH_keywords[index++] = keyword;
        }
        formatNodeCache = new HashMap<String, FormatNode[]>();
        zeroStrings = new char[][]{new char[0], {'0'}, {'0', '0'}, {'0', '0', '0'}, {'0', '0', '0', '0'}, {'0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0'}};
    }

    static class TmFromChar {
        FromCharDateMode mode = FromCharDateMode.FROM_CHAR_DATE_NONE;
        int hh;
        int pm;
        int mi;
        int ss;
        int ssss;
        int d;
        int dd;
        int ddd;
        int mm;
        int ms;
        int year;
        int bc;
        int ww;
        int w;
        int cc;
        int j;
        int us;
        int yysz;
        int clock;

        TmFromChar() {
        }
    }

    static class FormatNode {
        int type;
        KeyWord key;
        char character;
        int suffix;

        FormatNode() {
        }
    }

    static class KeyWord {
        String name;
        int len;
        DCH_poz idType;
        boolean is_digit;
        FromCharDateMode date_mode;

        KeyWord() {
        }
    }

    static class KeySuffix {
        String name;
        int len;
        int id;
        int type;

        public KeySuffix(String name, int len, int id, int type) {
            this.name = name;
            this.len = len;
            this.id = id;
            this.type = type;
        }
    }

    static enum FromCharDateMode {
        FROM_CHAR_DATE_NONE,
        FROM_CHAR_DATE_GREGORIAN,
        FROM_CHAR_DATE_ISOWEEK;

    }

    static enum DCH_poz {
        DCH_A_D(0),
        DCH_A_M(1),
        DCH_AD(2),
        DCH_AM(3),
        DCH_B_C(4),
        DCH_BC(5),
        DCH_CC(6),
        DCH_DAY(7),
        DCH_DDD(8),
        DCH_DD(9),
        DCH_DY(10),
        DCH_Day(11),
        DCH_Dy(12),
        DCH_D(13),
        DCH_FX(14),
        DCH_HH24(15),
        DCH_HH12(16),
        DCH_HH(17),
        DCH_IDDD(18),
        DCH_ID(19),
        DCH_IW(20),
        DCH_IYYY(21),
        DCH_IYY(22),
        DCH_IY(23),
        DCH_I(24),
        DCH_J(25),
        DCH_MI(26),
        DCH_MM(27),
        DCH_MONTH(28),
        DCH_MON(29),
        DCH_MS(30),
        DCH_Month(31),
        DCH_Mon(32),
        DCH_P_M(33),
        DCH_PM(34),
        DCH_Q(35),
        DCH_RM(36),
        DCH_SSSS(37),
        DCH_SS(38),
        DCH_TZ(39),
        DCH_US(40),
        DCH_WW(41),
        DCH_W(42),
        DCH_Y_YYY(43),
        DCH_YYYY(44),
        DCH_YYY(45),
        DCH_YY(46),
        DCH_Y(47),
        DCH_a_d(48),
        DCH_a_m(49),
        DCH_ad(50),
        DCH_am(51),
        DCH_b_c(52),
        DCH_bc(53),
        DCH_cc(54),
        DCH_day(55),
        DCH_ddd(56),
        DCH_dd(57),
        DCH_dy(58),
        DCH_d(59),
        DCH_fx(60),
        DCH_hh24(61),
        DCH_hh12(62),
        DCH_hh(63),
        DCH_iddd(64),
        DCH_id(65),
        DCH_iw(66),
        DCH_iyyy(67),
        DCH_iyy(68),
        DCH_iy(69),
        DCH_i(70),
        DCH_j(71),
        DCH_mi(72),
        DCH_mm(73),
        DCH_month(74),
        DCH_mon(75),
        DCH_ms(76),
        DCH_p_m(77),
        DCH_pm(78),
        DCH_q(79),
        DCH_rm(80),
        DCH_ssss(89),
        DCH_ss(90),
        DCH_tz(91),
        DCH_us(92),
        DCH_ww(93),
        DCH_w(94),
        DCH_y_yyy(95),
        DCH_yyyy(96),
        DCH_yyy(97),
        DCH_yy(98),
        DCH_y(99),
        _DCH_last_(Integer.MAX_VALUE);

        int value;

        private DCH_poz(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum FORMAT_TYPE {
        DCH_TYPE,
        NUM_TYPE;

    }
}

