/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.datetime;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.datum.Int8Datum;
import org.apache.tajo.exception.ValueOutOfRangeException;
import org.apache.tajo.util.datetime.DateTimeConstants;
import org.apache.tajo.util.datetime.TimeMeta;

public class DateTimeUtil {
    private static int MAX_FRACTION_LENGTH = 6;
    private static int MAXDATEFIELDS = 25;
    public static final int DAYS_FROM_JULIAN_TO_EPOCH = 2440588;

    public static boolean isJulianCalendar(int year, int month, int day) {
        return year <= 1752 && month <= 9 && day < 14;
    }

    public static int getCenturyOfEra(int year) {
        if (year > 0) {
            return (year - 1) / 100 + 1;
        }
        if (year < 0) {
            int pYear = -year;
            return -((pYear - 1) / 100 + 1);
        }
        return 0;
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int getDaysInYearMonth(int year, int month) {
        if (DateTimeUtil.isLeapYear(year)) {
            return DateTimeConstants.DAY_OF_MONTH[1][month - 1];
        }
        return DateTimeConstants.DAY_OF_MONTH[0][month - 1];
    }

    public static boolean isValidJulianDate(int years, int months, int days) {
        return years > -4713 || years == -4713 && months > 11 || months == 11 && days >= 24 && years < 5874898;
    }

    public static int date2j(int year, int month, int day) {
        if (month > 2) {
            ++month;
            year += 4800;
        } else {
            month += 13;
            year += 4799;
        }
        int century = year / 100;
        int julian = year * 365 - 32167;
        julian += year / 4 - century + century / 4;
        return julian += 7834 * month / 256 + day;
    }

    public static TimeMeta j2date(int julianDate) {
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.j2date(julianDate, tm);
        return tm;
    }

    public static void j2date(int julianDate, TimeMeta tm) {
        long y;
        long julian = julianDate;
        long quad = (julian += 32044L) / 146097L;
        long extra = (julian - quad * 146097L) * 4L + 3L;
        julian += 60L + quad * 3L + extra / 146097L;
        julian = ((y = (julian -= (quad = julian / 1461L) * 1461L) * 4L / 1461L) != 0L ? (julian + 305L) % 365L : (julian + 306L) % 366L) + 123L;
        tm.years = (int)((y += quad * 4L) - 4800L);
        quad = julian * 2141L / 65536L;
        tm.dayOfMonth = (int)(julian - 7834L * quad / 256L);
        tm.monthOfYear = (int)((quad + 10L) % 12L + 1L);
    }

    public static int j2day(int julianDate) {
        long day = julianDate;
        ++day;
        return (int)(day %= 7L);
    }

    public static int date2isoweek(int year, int mon, int mday) {
        double result;
        int day0;
        int day4;
        int dayn = DateTimeUtil.date2j(year, mon, mday);
        if (dayn < (day4 = DateTimeUtil.date2j(year, 1, 4)) - (day0 = DateTimeUtil.j2day(day4 - 1))) {
            day4 = DateTimeUtil.date2j(year - 1, 1, 4);
            day0 = DateTimeUtil.j2day(day4 - 1);
        }
        if ((result = (double)((dayn - (day4 - day0)) / 7 + 1)) >= 52.0 && dayn >= (day4 = DateTimeUtil.date2j(year + 1, 1, 4)) - (day0 = DateTimeUtil.j2day(day4 - 1))) {
            result = (dayn - (day4 - day0)) / 7 + 1;
        }
        return (int)result;
    }

    public static int date2isoyear(int year, int mon, int mday) {
        double result;
        int day0;
        int day4;
        int dayn = DateTimeUtil.date2j(year, mon, mday);
        if (dayn < (day4 = DateTimeUtil.date2j(year, 1, 4)) - (day0 = DateTimeUtil.j2day(day4 - 1))) {
            day4 = DateTimeUtil.date2j(year - 1, 1, 4);
            day0 = DateTimeUtil.j2day(day4 - 1);
            --year;
        }
        if ((result = (double)((dayn - (day4 - day0)) / 7 + 1)) >= 52.0 && dayn >= (day4 = DateTimeUtil.date2j(year + 1, 1, 4)) - (day0 = DateTimeUtil.j2day(day4 - 1))) {
            ++year;
        }
        return year;
    }

    public static int julianTimeToEpoch(long timestamp) {
        long totalSecs = timestamp / 1000000L;
        return (int)(totalSecs + 946684800L);
    }

    public static long julianTimeToJavaTime(long timestamp) {
        double totalSecs = (double)timestamp / 1000.0;
        return Math.round(totalSecs + 9.466848E11);
    }

    public static long javaTimeToJulianTime(long javaTimestamp) {
        double totalSecs = (double)javaTimestamp / 1000.0;
        return (long)((totalSecs - 9.466848E8) * 1000000.0);
    }

    public static long toTime(TimeMeta tm) {
        if (tm.timeZone != 0 && tm.timeZone != Integer.MAX_VALUE) {
            int timeZoneSecs = tm.timeZone;
            tm.timeZone = Integer.MAX_VALUE;
            tm.plusMillis(0 - timeZoneSecs * 1000);
        }
        return DateTimeUtil.toTime(tm.hours, tm.minutes, tm.secs, tm.fsecs);
    }

    public static long toTime(int hour, int min, int sec, int fsec) {
        return (long)((hour * 60 + min) * 60 + sec) * 1000000L + (long)fsec;
    }

    public static long toJavaTime(int hour, int min, int sec, int fsec) {
        return DateTimeUtil.toTime(hour, min, sec, fsec) / 1000L;
    }

    public static long toJulianTimestamp(int years, int months, int days, int hours, int minutes, int seconds, int fsec) {
        if (!DateTimeUtil.isValidJulianDate(years, months, days)) {
            throw new ValueOutOfRangeException("Out of Range Julian days_full");
        }
        long numJulianDays = DateTimeUtil.date2j(years, months, days) - 2451545;
        return DateTimeUtil.toJulianTimestamp(numJulianDays, hours, minutes, seconds, fsec);
    }

    private static long toJulianTimestamp(long numJulianDays, int hours, int minutes, int seconds, int fsec) {
        long time = DateTimeUtil.toTime(hours, minutes, seconds, fsec);
        long timestamp = numJulianDays * 86400000000L + time;
        if ((timestamp - time) / 86400000000L != numJulianDays) {
            throw new RuntimeException("Out of Range of Time");
        }
        if (timestamp < 0L && numJulianDays > 0L || timestamp > 0L && numJulianDays < -1L) {
            throw new RuntimeException("Out of Range of Date");
        }
        return timestamp;
    }

    public static long toJulianTimestamp(TimeMeta tm) {
        if (tm.timeZone != 0 && tm.timeZone != Integer.MAX_VALUE) {
            int timeZoneSecs = tm.timeZone;
            tm.timeZone = Integer.MAX_VALUE;
            tm.plusMillis(0 - timeZoneSecs * 1000);
        }
        if (tm.dayOfYear > 0) {
            return DateTimeUtil.toJulianTimestamp(DateTimeUtil.date2j(tm.years, 1, 1) + tm.dayOfYear - 1, tm.hours, tm.minutes, tm.secs, tm.fsecs);
        }
        return DateTimeUtil.toJulianTimestamp(tm.years, tm.monthOfYear, tm.dayOfMonth, tm.hours, tm.minutes, tm.secs, tm.fsecs);
    }

    public static void toJulianTimeMeta(long julianTimestamp, TimeMeta tm) {
        long time = julianTimestamp;
        long date = time / 86400000000L;
        if (date != 0L) {
            time -= date * 86400000000L;
        }
        if (time < 0L) {
            time += 86400000000L;
            --date;
        }
        if ((date += 2451545L) < 0L || date > Integer.MAX_VALUE) {
            throw new RuntimeException("Timestamp Out Of Scope");
        }
        DateTimeUtil.j2date((int)date, tm);
        DateTimeUtil.date2j(time, tm);
    }

    public static void date2j(long julianDate, TimeMeta tm) {
        long time = julianDate;
        tm.hours = (int)(time / 3600000000L);
        tm.minutes = (int)((time -= (long)tm.hours * 3600000000L) / 60000000L);
        tm.secs = (int)((time -= (long)tm.minutes * 60000000L) / 1000000L);
        tm.fsecs = (int)(time - (long)tm.secs * 1000000L);
    }

    private static void decodeDate(String str, int fmask, AtomicInteger tmaskValue, AtomicBoolean is2digits, TimeMeta tm) {
        int i;
        int nf;
        int idx = 0;
        DateTimeConstants.TokenField type = null;
        boolean val = false;
        AtomicInteger dmask = new AtomicInteger(0);
        int tmask = tmaskValue.get();
        boolean haveTextMonth = false;
        int length = str.length();
        char[] dateStr = str.toCharArray();
        String[] fields = new String[MAXDATEFIELDS];
        for (nf = 0; idx < length && nf < MAXDATEFIELDS; ++nf) {
            while (idx < length && !Character.isLetterOrDigit(dateStr[idx])) {
                ++idx;
            }
            if (idx == length) {
                throw new IllegalArgumentException("BAD Format: " + str);
            }
            int fieldStartIdx = idx;
            int fieldLength = idx;
            if (Character.isDigit(dateStr[idx])) {
                while (idx < length && Character.isDigit(dateStr[idx])) {
                    ++idx;
                }
                fieldLength = idx;
            } else if (Character.isLetterOrDigit(dateStr[idx])) {
                while (idx < length && Character.isLetterOrDigit(dateStr[idx])) {
                    ++idx;
                }
                fieldLength = idx;
            }
            fields[nf] = str.substring(fieldStartIdx, fieldLength);
        }
        for (i = 0; i < nf; ++i) {
            DateTimeConstants.DateToken dateToken;
            if (!Character.isLetter(fields[i].charAt(0)) || (type = (dateToken = DateTimeConstants.dateTokenMap.get(fields[i].toLowerCase())).getType()) == DateTimeConstants.TokenField.IGNORE_DTF) continue;
            dmask.set(DateTimeConstants.DTK_M(type));
            switch (type) {
                case MONTH: {
                    tm.monthOfYear = type.getValue();
                    haveTextMonth = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("BAD Format: " + str);
                }
            }
            if ((fmask & dmask.get()) != 0) {
                throw new IllegalArgumentException("BAD Format: " + str);
            }
            fmask |= dmask.get();
            tmask |= dmask.get();
            fields[i] = null;
        }
        for (i = 0; i < nf; ++i) {
            if (fields[i] == null) continue;
            length = fields[i].length();
            if (length <= 0) {
                throw new IllegalArgumentException("BAD Format: " + str);
            }
            DateTimeUtil.decodeNumber(length, fields[i], haveTextMonth, fmask, dmask, tm, new AtomicLong(0L), is2digits);
            if ((fmask & dmask.get()) != 0) {
                throw new IllegalArgumentException("BAD Format: " + str);
            }
            fmask |= dmask.get();
            tmask |= dmask.get();
        }
        tmaskValue.set(tmask);
        if ((fmask & ~(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DOY) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ))) != DateTimeConstants.DTK_DATE_M) {
            throw new IllegalArgumentException("BAD Format: " + str);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void decodeTime(String str, int fmask, int range, AtomicInteger tmask, TimeMeta tm, AtomicLong fsec) {
        StringBuilder cp = new StringBuilder();
        tmask.set(DateTimeConstants.DTK_TIME_M);
        tm.hours = DateTimeUtil.strtoi(str, 0, cp);
        if (cp.charAt(0) != ':') {
            throw new IllegalArgumentException("BAD Format: " + str);
        }
        tm.minutes = DateTimeUtil.strtoi(cp.toString(), 1, cp);
        if (cp.length() == 0) {
            tm.secs = 0;
            fsec.set(0L);
            if (range == (DateTimeConstants.INTERVAL_MASK(DateTimeConstants.TokenField.MINUTE) | DateTimeConstants.INTERVAL_MASK(DateTimeConstants.TokenField.SECOND))) {
                tm.secs = tm.minutes;
                tm.minutes = tm.hours;
                tm.hours = 0;
            }
        } else if (cp.charAt(0) == '.') {
            DateTimeUtil.parseFractionalSecond(cp, fsec);
            tm.secs = tm.minutes;
            tm.minutes = tm.hours;
            tm.hours = 0;
        } else {
            if (cp.charAt(0) != ':') throw new IllegalArgumentException("BAD Format: " + str);
            tm.secs = DateTimeUtil.strtoi(cp.toString(), 1, cp);
            if (cp.length() == 0) {
                fsec.set(0L);
            } else {
                if (cp.charAt(0) != '.') throw new IllegalArgumentException("BAD Format: " + str);
                DateTimeUtil.parseFractionalSecond(cp, fsec);
            }
        }
        if (tm.hours >= 0 && tm.minutes >= 0 && tm.minutes <= 59 && tm.secs >= 0 && tm.secs <= 60 && fsec.get() >= 0L && fsec.get() <= 1000000L) return;
        throw new IllegalArgumentException("BAD Format: FIELD_OVERFLOW: " + str);
    }

    public static long toJulianTimestamp(String str) {
        TimeMeta tm = DateTimeUtil.decodeDateTime(str, MAXDATEFIELDS);
        return DateTimeUtil.toJulianTimestamp(tm);
    }

    public static long toJulianTimestampWithTZ(String timestampStr, @Nullable TimeZone tz) {
        long timestamp = DateTimeUtil.toJulianTimestamp(timestampStr);
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.toJulianTimeMeta(timestamp, tm);
        if (tz != null) {
            DateTimeUtil.toUTCTimezone(tm, tz);
        }
        return DateTimeUtil.toJulianTimestamp(tm);
    }

    public static int toJulianDate(String dateStr) {
        TimeMeta tm = DateTimeUtil.decodeDateTime(dateStr);
        return DateTimeUtil.date2j(tm.years, tm.monthOfYear, tm.dayOfMonth);
    }

    public static long toJulianTime(String timeStr) {
        TimeMeta tm = DateTimeUtil.decodeDateTime(timeStr);
        return DateTimeUtil.toTime(tm);
    }

    public static TimeMeta decodeDateTime(String str) {
        return DateTimeUtil.decodeDateTime(str, MAXDATEFIELDS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeMeta decodeDateTime(String str, int maxFields) {
        int idx = 0;
        int nf = 0;
        int length = str.length();
        char[] timeStr = str.toCharArray();
        String[] fields = new String[maxFields];
        DateTimeConstants.TokenField[] fieldTypes = new DateTimeConstants.TokenField[maxFields];
        while (idx < length) {
            if (Character.isSpaceChar(timeStr[idx])) {
                ++idx;
                continue;
            }
            if (nf >= maxFields) {
                throw new IllegalArgumentException("Too many fields");
            }
            int startIdx = idx;
            if (Character.isDigit(timeStr[idx])) {
                ++idx;
                while (idx < length && Character.isDigit(timeStr[idx])) {
                    ++idx;
                }
                if (idx < length && timeStr[idx] == ':') {
                    fieldTypes[nf] = DateTimeConstants.TokenField.DTK_TIME;
                    while (idx < length && (Character.isDigit(timeStr[idx]) || timeStr[idx] == ':' || timeStr[idx] == '.')) {
                        ++idx;
                    }
                } else if (idx < length && (timeStr[idx] == '-' || timeStr[idx] == '/' || timeStr[idx] == '.')) {
                    char delim = timeStr[idx];
                    if (Character.isDigit(timeStr[++idx])) {
                        DateTimeConstants.TokenField tokenField = fieldTypes[nf] = delim == '.' ? DateTimeConstants.TokenField.DTK_NUMBER : DateTimeConstants.TokenField.DTK_DATE;
                        while (idx < length && Character.isDigit(timeStr[idx])) {
                            ++idx;
                        }
                        if (idx < length && timeStr[idx] == delim) {
                            fieldTypes[nf] = DateTimeConstants.TokenField.DTK_DATE;
                            ++idx;
                            while (idx < length && (Character.isDigit(timeStr[idx]) || timeStr[idx] == delim)) {
                                ++idx;
                            }
                        }
                    } else {
                        fieldTypes[nf] = DateTimeConstants.TokenField.DTK_DATE;
                        while (idx < length && Character.isLetterOrDigit(timeStr[idx]) || timeStr[idx] == delim) {
                            ++idx;
                        }
                    }
                } else {
                    fieldTypes[nf] = DateTimeConstants.TokenField.DTK_NUMBER;
                }
            } else if (timeStr[idx] == '.') {
                ++idx;
                while (idx < length && Character.isDigit(timeStr[idx])) {
                    ++idx;
                }
                fieldTypes[nf] = DateTimeConstants.TokenField.DTK_NUMBER;
            } else if (Character.isLetter(timeStr[idx])) {
                ++idx;
                while (idx < length && Character.isLetter(timeStr[idx])) {
                    ++idx;
                }
                boolean isDate = false;
                if (idx < length && (timeStr[idx] == '-' || timeStr[idx] == '/' || timeStr[idx] == '.')) {
                    isDate = true;
                } else if (idx < length && (timeStr[idx] == '+' || Character.isDigit(timeStr[idx]))) {
                    throw new IllegalArgumentException("Cannot parse this datetime field " + str.substring(startIdx, idx));
                }
                if (isDate) {
                    fieldTypes[nf] = DateTimeConstants.TokenField.DTK_DATE;
                    while (++idx < length && (timeStr[idx] == '+' || timeStr[idx] == '-' || timeStr[idx] == '/' || timeStr[idx] == '_' || timeStr[idx] == '.' || timeStr[idx] == ':' || Character.isLetterOrDigit(timeStr[idx]))) {
                    }
                } else {
                    fieldTypes[nf] = DateTimeConstants.TokenField.DTK_STRING;
                }
            } else if (timeStr[idx] == '+' || timeStr[idx] == '-') {
                ++idx;
                while (idx < length && Character.isSpaceChar(timeStr[idx])) {
                    ++idx;
                }
                if (idx < length && Character.isDigit(timeStr[idx])) {
                    fieldTypes[nf] = DateTimeConstants.TokenField.DTK_TZ;
                    ++idx;
                    while (idx < length && (Character.isDigit(timeStr[idx]) || timeStr[idx] == ':' || timeStr[idx] == '.' || timeStr[idx] == '-')) {
                        ++idx;
                    }
                } else {
                    if (idx >= length || !Character.isLetter(timeStr[idx])) throw new IllegalArgumentException("BAD Format: " + str.substring(startIdx, idx));
                    fieldTypes[nf] = DateTimeConstants.TokenField.DTK_SPECIAL;
                    ++idx;
                    while (idx < length && Character.isLetter(timeStr[idx])) {
                        ++idx;
                    }
                }
            } else {
                if (!DateTimeUtil.isPunctuation(timeStr[idx])) throw new IllegalArgumentException("BAD datetime format: " + str.substring(startIdx, idx));
                ++idx;
                continue;
            }
            fields[nf] = str.substring(startIdx, idx);
            ++nf;
        }
        return DateTimeUtil.decodeDateTime(fields, fieldTypes, nf);
    }

    public static void parseFractionalSecond(StringBuilder cp, AtomicLong fsec) {
        double frac = DateTimeUtil.strtod(cp.toString(), 1, cp);
        fsec.set(Math.round(frac * 1000000.0));
    }

    public static void decodeTimezone(String str, AtomicInteger tz) {
        int min = 0;
        int sec = 0;
        StringBuilder sb = new StringBuilder();
        int strIndex = 0;
        if (str.charAt(strIndex) != '+' && str.charAt(strIndex) != '-') {
            throw new IllegalArgumentException("BAD Format: " + str);
        }
        int hr = DateTimeUtil.strtoi(str, 1, sb);
        if (sb.length() > 0 && sb.charAt(0) == ':') {
            min = DateTimeUtil.strtoi(sb.toString(), 1, sb);
            if (sb.charAt(0) == ':') {
                sec = DateTimeUtil.strtoi(sb.toString(), 1, sb);
            }
        } else if (sb.length() == 0 && str.length() > 3) {
            min = hr % 100;
            hr /= 100;
        } else {
            min = 0;
        }
        if (hr < 0 || hr > 15) {
            throw new IllegalArgumentException("BAD Format: TZDISP_OVERFLOW: " + str);
        }
        if (min < 0 || min >= 60) {
            throw new IllegalArgumentException("BAD Format: TZDISP_OVERFLOW: " + str);
        }
        if (sec < 0 || sec >= 60) {
            throw new IllegalArgumentException("BAD Format: TZDISP_OVERFLOW: " + str);
        }
        int tzValue = (hr * 60 + min) * 60 + sec;
        if (str.charAt(strIndex) == '-') {
            tzValue = -tzValue;
        }
        tz.set(tzValue);
    }

    private static void decodeNumber(int flen, String str, boolean haveTextMonth, int fmask, AtomicInteger tmaskValue, TimeMeta tm, AtomicLong fsec, AtomicBoolean is2digits) {
        StringBuilder cp = new StringBuilder();
        int tmask = 0;
        tmaskValue.set(tmask);
        int val = DateTimeUtil.strtoi(str, 0, cp);
        if (cp.toString().equals(str)) {
            throw new IllegalArgumentException("BAD Format: " + str);
        }
        if (cp.length() > 0 && cp.charAt(0) == '.') {
            if (cp.length() - str.length() > 2) {
                DateTimeUtil.decodeNumberField(flen, str, fmask | DateTimeConstants.DTK_DATE_M, tmaskValue, tm, fsec, is2digits);
                return;
            }
            DateTimeUtil.parseFractionalSecond(cp, fsec);
        }
        if (flen == 3 && (fmask & DateTimeConstants.DTK_DATE_M) == DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR) && val >= 1 && val <= 366) {
            tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DOY) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
            tm.dayOfYear = val;
            return;
        }
        int checkValue = fmask & DateTimeConstants.DTK_DATE_M;
        if (checkValue == 0) {
            if (flen >= 3 || TajoConf.getDateOrder() == 0) {
                tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR));
                tm.years = val;
            } else if (TajoConf.getDateOrder() == 1) {
                tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                tm.dayOfMonth = val;
            } else {
                tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH));
                tm.monthOfYear = val;
            }
        } else if (checkValue == DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR)) {
            tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH));
            tm.monthOfYear = val;
        } else if (checkValue == DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH)) {
            if (haveTextMonth) {
                if (flen >= 3 || TajoConf.getDateOrder() == 0) {
                    tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR));
                    tm.years = val;
                } else {
                    tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                    tm.dayOfMonth = val;
                }
            } else {
                tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                tm.dayOfMonth = val;
            }
        } else if (checkValue == (DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH))) {
            if (haveTextMonth) {
                if (flen >= 3 && is2digits.get()) {
                    tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                    tm.dayOfMonth = tm.years;
                    tm.years = val;
                    is2digits.set(false);
                } else {
                    tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                    tm.dayOfMonth = val;
                }
            } else {
                tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                tm.dayOfMonth = val;
            }
        } else if (checkValue == DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY)) {
            tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH));
            tm.monthOfYear = val;
        } else if (checkValue == (DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY))) {
            tmaskValue.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR));
            tm.years = val;
        } else {
            if (checkValue == (DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY))) {
                DateTimeUtil.decodeNumberField(flen, str, fmask, tmaskValue, tm, fsec, is2digits);
                return;
            }
            throw new IllegalArgumentException("BAD Format: " + str);
        }
        if (tmaskValue.get() == DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR)) {
            is2digits.set(flen <= 2);
        }
    }

    static DateTimeConstants.TokenField decodeNumberField(int len, String str, int fmask, AtomicInteger tmaskValue, TimeMeta tm, AtomicLong fsec, AtomicBoolean is2digits) {
        int index = str.indexOf(46);
        if (index >= 0) {
            String cp = str.substring(index + 1);
            double frac = DateTimeUtil.strtod(cp, 0, null);
            fsec.set(Math.round(frac * 1000000.0));
            len = str.length();
        } else if ((fmask & DateTimeConstants.DTK_DATE_M) != DateTimeConstants.DTK_DATE_M) {
            if (len == 8) {
                tmaskValue.set(DateTimeConstants.DTK_DATE_M);
                tm.dayOfMonth = Integer.parseInt(str.substring(6));
                tm.monthOfYear = Integer.parseInt(str.substring(4, 6));
                tm.years = Integer.parseInt(str.substring(0, 4));
                return DateTimeConstants.TokenField.DTK_DATE;
            }
            if (len == 6) {
                tmaskValue.set(DateTimeConstants.DTK_DATE_M);
                tm.dayOfMonth = Integer.parseInt(str.substring(4));
                tm.monthOfYear = Integer.parseInt(str.substring(2, 4));
                tm.years = Integer.parseInt(str.substring(0, 2));
                is2digits.set(true);
                return DateTimeConstants.TokenField.DTK_DATE;
            }
        }
        if ((fmask & DateTimeConstants.DTK_TIME_M) != DateTimeConstants.DTK_TIME_M) {
            if (len == 6) {
                tmaskValue.set(DateTimeConstants.DTK_TIME_M);
                tm.secs = Integer.parseInt(str.substring(4));
                tm.minutes = Integer.parseInt(str.substring(2, 4));
                tm.hours = Integer.parseInt(str.substring(0, 2));
                return DateTimeConstants.TokenField.DTK_TIME;
            }
            if (len == 4) {
                tmaskValue.set(DateTimeConstants.DTK_TIME_M);
                tm.secs = 0;
                tm.minutes = Integer.parseInt(str.substring(2, 4));
                tm.hours = Integer.parseInt(str.substring(0, 2));
                return DateTimeConstants.TokenField.DTK_TIME;
            }
        }
        throw new IllegalArgumentException("BAD Format: " + str);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static TimeMeta decodeDateTime(String[] fields, DateTimeConstants.TokenField[] fieldTypes, int nf) {
        int fmask = 0;
        AtomicInteger tmask = new AtomicInteger(0);
        Enum ptype = null;
        boolean haveTextMonth = false;
        boolean isjulian = false;
        AtomicBoolean is2digits = new AtomicBoolean(false);
        boolean bc = false;
        int tzp = Integer.MAX_VALUE;
        String namedTimeZone = null;
        StringBuilder sb = new StringBuilder();
        DateTimeConstants.TokenField dtype = DateTimeConstants.TokenField.DTK_DATE;
        DateTimeConstants.TokenField mer = null;
        TimeMeta tm = new TimeMeta();
        TimeMeta cur_tm = new TimeMeta();
        AtomicLong fsec = new AtomicLong();
        AtomicInteger tz = new AtomicInteger(Integer.MAX_VALUE);
        tm.isDST = false;
        block43: for (int i = 0; i < nf; ++i) {
            if (fieldTypes[i] == null) continue;
            block0 : switch (fieldTypes[i]) {
                case DTK_DATE: {
                    if (ptype == DateTimeConstants.TokenField.DTK_JULIAN) {
                        if (tzp == Integer.MAX_VALUE) {
                            throw new IllegalArgumentException("BAD Format: " + fields[i]);
                        }
                        int val = DateTimeUtil.strtoi(fields[i], 0, sb);
                        DateTimeUtil.date2j(val, tm);
                        isjulian = true;
                        DateTimeUtil.decodeTimezone(sb.toString(), tz);
                        tmask.set(DateTimeConstants.DTK_DATE_M | DateTimeConstants.DTK_TIME_M | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                        ptype = null;
                        break;
                    }
                    if (ptype != null || (fmask & (DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY))) == (DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH) | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY))) {
                        if (tzp == Integer.MAX_VALUE) {
                            throw new IllegalArgumentException("BAD Format: " + fields[i]);
                        }
                        if (Character.isDigit(fields[i].charAt(0)) || ptype != null) {
                            if (ptype != null) {
                                if (ptype != DateTimeConstants.TokenField.DTK_TIME) {
                                    throw new IllegalArgumentException("BAD Format: " + fields[i]);
                                }
                                ptype = null;
                            }
                            if ((fmask & DateTimeConstants.DTK_TIME_M) == DateTimeConstants.DTK_TIME_M) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            int index = fields[i].indexOf("-");
                            if (index < 0) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            DateTimeUtil.decodeTimezone(fields[i].substring(index + 1), tz);
                            DateTimeUtil.decodeNumberField(fields[i].length(), fields[i], fmask, tmask, tm, fsec, is2digits);
                            tmask.set(tmask.get() | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                            break;
                        }
                        namedTimeZone = DateTimeUtil.pg_tzset(fields[i]);
                        if (namedTimeZone == null) {
                            throw new IllegalArgumentException("BAD Format: time zone \"%s\" not recognized: " + fields[i]);
                        }
                        tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                        break;
                    }
                    DateTimeUtil.decodeDate(fields[i], fmask, tmask, is2digits, tm);
                    break;
                }
                case DTK_TIME: {
                    DateTimeUtil.decodeTime(fields[i], fmask | DateTimeConstants.DTK_DATE_M, Short.MAX_VALUE, tmask, tm, fsec);
                    break;
                }
                case DTK_TZ: {
                    DateTimeUtil.decodeTimezone(fields[i], tz);
                    tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                    break;
                }
                case DTK_NUMBER: {
                    if (ptype != null) {
                        int val = DateTimeUtil.strtoi(fields[i], 0, sb);
                        if (sb.length() == 0) continue block43;
                        if (sb.charAt(0) != '.') {
                            throw new IllegalArgumentException("BAD Format: " + fields[i]);
                        }
                        switch (1.$SwitchMap$org$apache$tajo$util$datetime$DateTimeConstants$TokenField[ptype.ordinal()]) {
                            case 2: 
                            case 3: 
                            case 4: {
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                        }
                        switch (1.$SwitchMap$org$apache$tajo$util$datetime$DateTimeConstants$TokenField[ptype.ordinal()]) {
                            case 5: {
                                tm.years = val;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR));
                                break;
                            }
                            case 6: {
                                if ((fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH)) != 0 && (fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.HOUR)) != 0) {
                                    tm.minutes = val;
                                    tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MINUTE));
                                    break;
                                }
                                tm.monthOfYear = val;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH));
                                break;
                            }
                            case 7: {
                                tm.dayOfMonth = val;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                                break;
                            }
                            case 8: {
                                tm.hours = val;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.HOUR));
                                break;
                            }
                            case 9: {
                                tm.minutes = val;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MINUTE));
                                break;
                            }
                            case 4: {
                                tm.secs = val;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.SECOND));
                                if (sb.charAt(0) != '.') break;
                                DateTimeUtil.parseFractionalSecond(sb, fsec);
                                tmask.set(DateTimeConstants.DTK_ALL_SECS_M);
                                break;
                            }
                            case 10: {
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                                DateTimeUtil.decodeTimezone(fields[i], tz);
                                break;
                            }
                            case 2: {
                                if (val < 0) {
                                    throw new IllegalArgumentException("BAD Format: FIELD_OVERFLOW: " + fields[i]);
                                }
                                tmask.set(DateTimeConstants.DTK_DATE_M);
                                DateTimeUtil.date2j(val, tm);
                                isjulian = true;
                                if (sb.charAt(0) != '.') break;
                                double time = DateTimeUtil.strtod(sb.toString(), 0, sb);
                                DateTimeUtil.date2j((long)(time *= 8.64E10), tm);
                                tmask.set(tmask.get() | DateTimeConstants.DTK_TIME_M);
                                break;
                            }
                            case 3: {
                                DateTimeUtil.decodeNumberField(fields[i].length(), fields[i], fmask | DateTimeConstants.DTK_DATE_M, tmask, tm, fsec, is2digits);
                                if (tmask.get() == DateTimeConstants.DTK_TIME_M) break;
                                throw new IllegalArgumentException("BAD Format: FIELD_OVERFLOW: " + fields[i]);
                            }
                            default: {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                        }
                        ptype = null;
                        dtype = DateTimeConstants.TokenField.DTK_DATE;
                        break;
                    }
                    int flen = fields[i].length();
                    int index = fields[i].indexOf(".");
                    String cp = null;
                    if (index > 0) {
                        cp = fields[i].substring(index + 1);
                    }
                    if (cp != null && (fmask & DateTimeConstants.DTK_DATE_M) == 0) {
                        DateTimeUtil.decodeDate(fields[i], fmask, tmask, is2digits, tm);
                        break;
                    }
                    if (cp != null && flen - cp.length() > 2) {
                        DateTimeUtil.decodeNumberField(flen, fields[i], fmask, tmask, tm, fsec, is2digits);
                        break;
                    }
                    if (flen > 4) {
                        DateTimeUtil.decodeNumberField(flen, fields[i], fmask, tmask, tm, fsec, is2digits);
                        break;
                    }
                    DateTimeUtil.decodeNumber(flen, fields[i], haveTextMonth, fmask, tmask, tm, fsec, is2digits);
                    break;
                }
                case DTK_STRING: 
                case DTK_SPECIAL: {
                    DateTimeConstants.DateToken dateToken = DateTimeConstants.dateTokenMap.get(fields[i].toLowerCase());
                    if (dateToken == null) {
                        throw new IllegalArgumentException("BAD Format: " + fields[i]);
                    }
                    tmask.set(DateTimeConstants.DTK_M(dateToken.getType()));
                    switch (dateToken.getType()) {
                        case RESERV: {
                            switch (dateToken.getValueType()) {
                                case DTK_CURRENT: {
                                    throw new IllegalArgumentException("BAD Format: date/time value \"current\" is no longer supported" + fields[i]);
                                }
                                case DTK_NOW: {
                                    tmask.set(DateTimeConstants.DTK_DATE_M | DateTimeConstants.DTK_TIME_M | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                                    dtype = DateTimeConstants.TokenField.DTK_DATE;
                                    DateTimeUtil.date2j(DateTimeUtil.javaTimeToJulianTime(System.currentTimeMillis()), tm);
                                    break block0;
                                }
                                case DTK_YESTERDAY: {
                                    tmask.set(DateTimeConstants.DTK_DATE_M);
                                    dtype = DateTimeConstants.TokenField.DTK_DATE;
                                    DateTimeUtil.date2j(DateTimeUtil.javaTimeToJulianTime(System.currentTimeMillis()), tm);
                                    tm.plusDays(-1);
                                    break block0;
                                }
                                case DTK_TODAY: {
                                    tmask.set(DateTimeConstants.DTK_DATE_M);
                                    dtype = DateTimeConstants.TokenField.DTK_DATE;
                                    DateTimeUtil.date2j(DateTimeUtil.javaTimeToJulianTime(System.currentTimeMillis()), cur_tm);
                                    tm.years = cur_tm.years;
                                    tm.monthOfYear = cur_tm.monthOfYear;
                                    tm.dayOfMonth = cur_tm.dayOfMonth;
                                    break block0;
                                }
                                case DTK_TOMORROW: {
                                    tmask.set(DateTimeConstants.DTK_DATE_M);
                                    dtype = DateTimeConstants.TokenField.DTK_DATE;
                                    DateTimeUtil.date2j(DateTimeUtil.javaTimeToJulianTime(System.currentTimeMillis()), tm);
                                    tm.plusDays(1);
                                    break block0;
                                }
                                case DTK_ZULU: {
                                    tmask.set(DateTimeConstants.DTK_TIME_M | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                                    dtype = DateTimeConstants.TokenField.DTK_DATE;
                                    tm.hours = 0;
                                    tm.minutes = 0;
                                    tm.secs = 0;
                                    break block0;
                                }
                            }
                            dtype = dateToken.getValueType();
                            break block0;
                        }
                        case MONTH: {
                            if ((fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH)) != 0 && !haveTextMonth && (fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY)) == 0 && tm.monthOfYear >= 1 && tm.monthOfYear <= 31) {
                                tm.dayOfMonth = tm.monthOfYear;
                                tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY));
                            }
                            haveTextMonth = true;
                            tm.monthOfYear = dateToken.getValue();
                            break block0;
                        }
                        case DTZMOD: {
                            tmask.set(tmask.get() | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DTZ));
                            tm.isDST = true;
                            if (tzp == Integer.MAX_VALUE) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            tzp += dateToken.getValue() * 60;
                            break block0;
                        }
                        case DTZ: {
                            tmask.set(tmask.get() | DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                            tm.isDST = true;
                            if (tzp == Integer.MAX_VALUE) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            tzp = dateToken.getValue() * 60;
                            break block0;
                        }
                        case TZ: {
                            tm.isDST = false;
                            if (tzp == Integer.MAX_VALUE) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            tzp = dateToken.getValue() * 60;
                            break block0;
                        }
                        case IGNORE_DTF: {
                            break block0;
                        }
                        case AMPM: {
                            mer = dateToken.getValueType();
                            break block0;
                        }
                        case ADBC: {
                            bc = dateToken.getValueType() == DateTimeConstants.TokenField.BC;
                            break block0;
                        }
                        case DOW: {
                            tm.dayOfWeek = dateToken.getValue();
                            break block0;
                        }
                        case UNITS: {
                            tmask.set(0);
                            ptype = dateToken.getValueType();
                            break block0;
                        }
                        case ISOTIME: {
                            tmask.set(0);
                            if ((fmask & DateTimeConstants.DTK_DATE_M) != DateTimeConstants.DTK_DATE_M) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            if (i >= nf - 1 || fieldTypes[i + 1] != DateTimeConstants.TokenField.DTK_NUMBER && fieldTypes[i + 1] != DateTimeConstants.TokenField.DTK_TIME && fieldTypes[i + 1] != DateTimeConstants.TokenField.DTK_DATE) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            ptype = dateToken.getValueType();
                            break block0;
                        }
                        case UNKNOWN_FIELD: {
                            namedTimeZone = DateTimeUtil.pg_tzset(fields[i]);
                            if (namedTimeZone == null) {
                                throw new IllegalArgumentException("BAD Format: " + fields[i]);
                            }
                            tmask.set(DateTimeConstants.DTK_M(DateTimeConstants.TokenField.TZ));
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("BAD Format: " + fields[i]);
                }
            }
            if ((tmask.get() & fmask) != 0) {
                throw new IllegalArgumentException("BAD Format: " + fields[i]);
            }
            fmask |= tmask.get();
        }
        tm.fsecs = fsec.intValue();
        tm.timeZone = tz.get();
        DateTimeUtil.validateDate(fmask, isjulian, is2digits.get(), bc, tm);
        if (mer != null && mer != DateTimeConstants.TokenField.HR24 && tm.hours > 12) {
            throw new IllegalArgumentException("BAD Format: overflow hour: " + tm.hours);
        }
        if (mer != null && mer == DateTimeConstants.TokenField.AM && tm.hours == 12) {
            tm.hours = 0;
        } else if (mer != null && mer == DateTimeConstants.TokenField.PM && tm.hours != 12) {
            tm.hours += 12;
        }
        if (dtype == DateTimeConstants.TokenField.DTK_DATE) {
            if ((fmask & DateTimeConstants.DTK_DATE_M) != DateTimeConstants.DTK_DATE_M) {
                if ((fmask & DateTimeConstants.DTK_TIME_M) == DateTimeConstants.DTK_TIME_M) {
                    return tm;
                }
                throw new IllegalArgumentException("BAD Format: " + tm);
            }
            if (namedTimeZone != null && (fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DTZMOD)) != 0) {
                throw new IllegalArgumentException("BAD Format: " + tm);
            }
        }
        return tm;
    }

    private static String pg_tzset(String str) {
        return null;
    }

    private static int validateDate(int fmask, boolean isjulian, boolean is2digits, boolean bc, TimeMeta tm) {
        boolean leapYear;
        if ((fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.YEAR)) != 0 && !isjulian) {
            if (bc) {
                if (tm.years <= 0) {
                    throw new IllegalArgumentException("BAD Format: year overflow:" + tm.years);
                }
                tm.years = -(tm.years - 1);
            } else if (is2digits) {
                if (tm.years < 0) {
                    throw new IllegalArgumentException("BAD Format: year overflow:" + tm.years);
                }
                if (tm.years < 70) {
                    tm.years += 2000;
                } else if (tm.years < 100) {
                    tm.years += 1900;
                }
            } else if (tm.years <= 0) {
                throw new IllegalArgumentException("BAD Format: year overflow:" + tm.years);
            }
        }
        if ((fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DOY)) != 0) {
            DateTimeUtil.j2date(DateTimeUtil.date2j(tm.years, 1, 1) + tm.dayOfYear - 1, tm);
        }
        if ((fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.MONTH)) != 0 && (tm.monthOfYear < 1 || tm.monthOfYear > 12)) {
            throw new IllegalArgumentException("BAD Format: month overflow:" + tm.monthOfYear);
        }
        if ((fmask & DateTimeConstants.DTK_M(DateTimeConstants.TokenField.DAY)) != 0 && (tm.dayOfMonth < 1 || tm.dayOfMonth > 31)) {
            throw new IllegalArgumentException("BAD Format: day overflow:" + tm.dayOfMonth);
        }
        if ((fmask & DateTimeConstants.DTK_DATE_M) == DateTimeConstants.DTK_DATE_M && tm.dayOfMonth > DateTimeConstants.DAY_OF_MONTH[(leapYear = DateTimeUtil.isLeapYear(tm.years)) ? 1 : 0][tm.monthOfYear - 1]) {
            throw new IllegalArgumentException("BAD Format: day overflow:" + tm.dayOfMonth);
        }
        return 0;
    }

    public static int strtoi(String str, int startIndex, StringBuilder sb) {
        int index;
        sb.setLength(0);
        char[] chars = str.toCharArray();
        for (index = startIndex; index < chars.length && Character.isDigit(chars[index]); ++index) {
        }
        int val = index == startIndex ? 0 : Integer.parseInt(str.substring(startIndex, index));
        sb.append(chars, index, chars.length - index);
        return val;
    }

    public static long strtol(String str, int startIndex, StringBuilder sb) {
        int index;
        sb.setLength(0);
        char[] chars = str.toCharArray();
        for (index = startIndex; index < chars.length && Character.isDigit(chars[index]); ++index) {
        }
        long val = index == startIndex ? 0L : Long.parseLong(str.substring(startIndex, index));
        sb.append(chars, index, chars.length - index);
        return val;
    }

    public static double strtod(String str, int strIndex, StringBuilder sb) {
        int index;
        if (sb != null) {
            sb.setLength(0);
        }
        char[] chars = str.toCharArray();
        for (index = strIndex; index < chars.length && Character.isDigit(chars[index]); ++index) {
        }
        double val = Double.parseDouble(str.substring(0, index));
        if (sb != null) {
            sb.append(chars, index, chars.length - index);
        }
        return val;
    }

    public static boolean isPunctuation(char c) {
        return c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`' || c >= '{' && c <= '~';
    }

    public static String toString(TimeMeta tm) {
        return DateTimeUtil.encodeDateTime(tm, DateTimeConstants.DateStyle.ISO_DATES);
    }

    public static String encodeDateTime(TimeMeta tm, DateTimeConstants.DateStyle style) {
        StringBuilder sb = new StringBuilder();
        switch (style) {
            case ISO_DATES: 
            case XSO_DATES: {
                if (style == DateTimeConstants.DateStyle.ISO_DATES) {
                    sb.append(String.format("%04d-%02d-%02d %02d:%02d:", tm.years > 0 ? tm.years : -(tm.years - 1), tm.monthOfYear, tm.dayOfMonth, tm.hours, tm.minutes));
                } else {
                    sb.append(String.format("%04d-%02d-%02dT%02d:%02d:", tm.years > 0 ? tm.years : -(tm.years - 1), tm.monthOfYear, tm.dayOfMonth, tm.hours, tm.minutes));
                }
                DateTimeUtil.appendSecondsToEncodeOutput(sb, tm.secs, tm.fsecs, 6, true);
                if (tm.timeZone != 0 && tm.timeZone != Integer.MAX_VALUE) {
                    sb.append(DateTimeUtil.getTimeZoneDisplayTime(tm.timeZone));
                }
                if (tm.years > 0) break;
                sb.append(" BC");
                break;
            }
        }
        return sb.toString();
    }

    public static String encodeDate(TimeMeta tm, DateTimeConstants.DateStyle style) {
        return DateTimeUtil.encodeDate(tm.years, tm.monthOfYear, tm.dayOfMonth, style);
    }

    public static String encodeDate(int years, int monthOfYear, int dayOfMonth, DateTimeConstants.DateStyle style) {
        StringBuilder sb = new StringBuilder();
        switch (style) {
            default: 
        }
        sb.append(String.format("%04d-%02d-%02d", years > 0 ? years : -(years - 1), monthOfYear, dayOfMonth));
        return sb.toString();
    }

    public static String encodeTime(TimeMeta tm, DateTimeConstants.DateStyle style) {
        StringBuilder sb = new StringBuilder();
        switch (style) {
            default: 
        }
        sb.append(String.format("%02d:%02d:", tm.hours, tm.minutes));
        DateTimeUtil.appendSecondsToEncodeOutput(sb, tm.secs, tm.fsecs, 6, true);
        if (tm.timeZone != 0 && tm.timeZone != Integer.MAX_VALUE) {
            sb.append(DateTimeUtil.getTimeZoneDisplayTime(tm.timeZone));
        }
        return sb.toString();
    }

    public static void appendSecondsToEncodeOutput(StringBuilder sb, int sec, int fsec, int precision, boolean fillzeros) {
        if (fsec == 0) {
            if (fillzeros) {
                sb.append(String.format("%02d", Math.abs(sec)));
            } else {
                sb.append(String.format("%d", Math.abs(sec)));
            }
        } else {
            if (fillzeros) {
                sb.append(String.format("%02d", Math.abs(sec)));
            } else {
                sb.append(String.format("%d", Math.abs(sec)));
            }
            if (precision > MAX_FRACTION_LENGTH) {
                precision = MAX_FRACTION_LENGTH;
            }
            if (precision > 0) {
                char[] fracChars = String.valueOf(fsec).toCharArray();
                char[] resultChars = new char[MAX_FRACTION_LENGTH];
                int numFillZero = MAX_FRACTION_LENGTH - fracChars.length;
                int fracIdx = 0;
                for (int i = 0; i < MAX_FRACTION_LENGTH; ++i) {
                    if (i < numFillZero) {
                        resultChars[i] = 48;
                        continue;
                    }
                    resultChars[i] = fracChars[fracIdx];
                    ++fracIdx;
                }
                sb.append(".").append(resultChars, 0, precision);
            }
            DateTimeUtil.trimTrailingZeros(sb);
        }
    }

    public static void trimTrailingZeros(StringBuilder sb) {
        int len = sb.length();
        while (len > 1 && sb.charAt(len - 1) == '0' && sb.charAt(len - 2) != '.') {
            sb.setLength(--len);
        }
    }

    public static int isoweek2j(int year, int week) {
        int day4 = DateTimeUtil.date2j(year, 1, 4);
        int day0 = DateTimeUtil.j2day(day4 - 1);
        return (week - 1) * 7 + (day4 - day0);
    }

    public static void isoweek2date(int woy, TimeMeta tm) {
        DateTimeUtil.j2date(DateTimeUtil.isoweek2j(tm.years, woy), tm);
    }

    public static void isoweekdate2date(int isoweek, int wday, TimeMeta tm) {
        int jday = DateTimeUtil.isoweek2j(tm.years, isoweek);
        jday = wday > 1 ? (jday += wday - 2) : (jday += 6);
        DateTimeUtil.j2date(jday, tm);
    }

    public static int date2isoyearday(int year, int mon, int mday) {
        return DateTimeUtil.date2j(year, mon, mday) - DateTimeUtil.isoweek2j(DateTimeUtil.date2isoyear(year, mon, mday), 1) + 1;
    }

    public static void toUserTimezone(TimeMeta tm, TimeZone timeZone) {
        tm.plusMillis(timeZone.getRawOffset());
    }

    public static void toUTCTimezone(TimeMeta tm, TimeZone timeZone) {
        tm.plusMillis(0 - timeZone.getRawOffset());
    }

    public static String getTimeZoneDisplayTime(TimeZone timeZone) {
        return DateTimeUtil.getTimeZoneDisplayTime(timeZone.getRawOffset() / 1000);
    }

    public static String getTimeZoneDisplayTime(int totalSecs) {
        if (totalSecs == 0) {
            return "";
        }
        int minutes = Math.abs(totalSecs) / 60;
        int hours = minutes / 60;
        StringBuilder sb = new StringBuilder();
        sb.append(totalSecs > 0 ? "+" : "-").append(String.format("%02d", hours));
        if ((minutes -= hours * 60) > 0) {
            sb.append(":").append(String.format("%02d", minutes));
        }
        return sb.toString();
    }

    public static long getDay(TimeMeta dateTime) {
        long usecs = 0L;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(dateTime.years, dateTime.monthOfYear, dateTime.dayOfMonth, 0, 0, 0, 0)) * 1000L;
        return usecs;
    }

    public static long getHour(TimeMeta dateTime) {
        long usecs = 0L;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(dateTime.years, dateTime.monthOfYear, dateTime.dayOfMonth, dateTime.hours, 0, 0, 0)) * 1000L;
        return usecs;
    }

    public static long getMinute(TimeMeta dateTime) {
        long usecs = 0L;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(dateTime.years, dateTime.monthOfYear, dateTime.dayOfMonth, dateTime.hours, dateTime.minutes, 0, 0)) * 1000L;
        return usecs;
    }

    public static long getSecond(TimeMeta dateTime) {
        long usecs = 0L;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(dateTime.years, dateTime.monthOfYear, dateTime.dayOfMonth, dateTime.hours, dateTime.minutes, dateTime.secs, 0)) * 1000L;
        return usecs;
    }

    public static long getMonth(TimeMeta dateTime) {
        long usecs = 0L;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(dateTime.years, dateTime.monthOfYear, 1, 0, 0, 0, 0)) * 1000L;
        return usecs;
    }

    public static long getDayOfWeek(TimeMeta dateTime, int weekday) {
        if (weekday < 1 || weekday > 7) {
            throw new RuntimeException("Weekday is out of range. Actual : " + weekday);
        }
        int week = DateTimeUtil.date2isoweek(dateTime.years, dateTime.monthOfYear, dateTime.dayOfMonth);
        int jday = DateTimeUtil.isoweek2j(dateTime.years, week);
        long usecs = 0L;
        jday += weekday - 1;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(jday -= 2451545, 0, 0, 0, 0)) * 1000L;
        return usecs;
    }

    public static long getYear(TimeMeta dateTime) {
        long usecs = 0L;
        usecs = DateTimeUtil.julianTimeToJavaTime(DateTimeUtil.toJulianTimestamp(dateTime.years, 1, 1, 0, 0, 0, 0)) * 1000L;
        return usecs;
    }

    public static TimeMeta getUTCDateTime(Int8Datum int8Datum) {
        return DateTimeUtil.getUTCDateTime(int8Datum.asInt8());
    }

    public static TimeMeta getUTCDateTime(long time) {
        long usecs = time % 1000L;
        long julianTimestamp = DateTimeUtil.javaTimeToJulianTime(time / 1000L);
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.toJulianTimeMeta(julianTimestamp += usecs, tm);
        return tm;
    }
}

