/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.util.graph.DirectedGraph;
import org.apache.tajo.util.graph.DirectedGraphVisitor;

public class SimpleDirectedGraph<V, E>
implements DirectedGraph<V, E> {
    protected Map<V, Map<V, E>> directedEdges = TUtil.newLinkedHashMap();
    protected Map<V, Map<V, E>> reversedEdges = TUtil.newLinkedHashMap();

    public void clear() {
        for (Map<V, E> eachEdge : this.directedEdges.values()) {
            eachEdge.clear();
        }
        for (Map<V, E> eachEdge : this.reversedEdges.values()) {
            eachEdge.clear();
        }
        this.directedEdges.clear();
        this.reversedEdges.clear();
    }

    @Override
    public int getVertexSize() {
        return this.directedEdges.size();
    }

    @Override
    public int getEdgeNum() {
        int edgeNum = 0;
        for (Map<V, E> map : this.directedEdges.values()) {
            edgeNum += map.values().size();
        }
        return edgeNum;
    }

    @Override
    public void addEdge(V tail, V head, E edge) {
        TUtil.putToNestedMap(this.directedEdges, tail, head, edge);
        TUtil.putToNestedMap(this.reversedEdges, head, tail, edge);
    }

    @Override
    public void removeEdge(V tail, V head) {
        if (this.directedEdges.containsKey(tail)) {
            this.directedEdges.get(tail).remove(head);
            if (this.directedEdges.get(tail).isEmpty()) {
                this.directedEdges.remove(tail);
            }
            this.reversedEdges.get(head).remove(tail);
            if (this.reversedEdges.get(head).isEmpty()) {
                this.reversedEdges.remove(head);
            }
        } else {
            throw new RuntimeException("Not connected channel: " + tail + " -> " + head);
        }
    }

    @Override
    public boolean hasEdge(V tail, V head) {
        return this.directedEdges.containsKey(tail) && this.directedEdges.get(tail).containsKey(head);
    }

    @Override
    public boolean hasReversedEdge(V head, V tail) {
        return this.reversedEdges.containsKey(head) && this.reversedEdges.get(head).containsKey(tail);
    }

    @Override
    @Nullable
    public E getEdge(V tail, V head) {
        if (this.hasEdge(tail, head)) {
            return this.directedEdges.get(tail).get(head);
        }
        return null;
    }

    @Override
    @Nullable
    public E getReverseEdge(V head, V tail) {
        if (this.hasReversedEdge(head, tail)) {
            return this.reversedEdges.get(head).get(tail);
        }
        return null;
    }

    @Override
    public Collection<E> getEdgesAll() {
        ArrayList edges = Lists.newArrayList();
        for (Map<V, E> map : this.directedEdges.values()) {
            edges.addAll(map.values());
        }
        return edges;
    }

    @Override
    public int getChildCount(V v) {
        if (this.reversedEdges.containsKey(v)) {
            return this.reversedEdges.get(v).size();
        }
        return 0;
    }

    @Override
    public List<E> getIncomingEdges(V head) {
        if (this.reversedEdges.containsKey(head)) {
            return ImmutableList.copyOf(this.reversedEdges.get(head).values());
        }
        return null;
    }

    @Override
    public List<E> getOutgoingEdges(V tail) {
        if (this.directedEdges.containsKey(tail)) {
            return ImmutableList.copyOf(this.directedEdges.get(tail).values());
        }
        return null;
    }

    @Override
    public List<V> getChilds(V v) {
        ArrayList<V> childBlocks = new ArrayList<V>();
        if (this.reversedEdges.containsKey(v)) {
            for (Map.Entry<V, E> entry : this.reversedEdges.get(v).entrySet()) {
                childBlocks.add(entry.getKey());
            }
        }
        return childBlocks;
    }

    @Override
    public V getChild(V block, int idx) {
        if (this.reversedEdges.containsKey(block)) {
            int i = 0;
            for (Map.Entry<V, E> entry : this.reversedEdges.get(block).entrySet()) {
                if (idx != i++) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public V getParent(V block, int idx) {
        if (this.directedEdges.containsKey(block)) {
            int i = 0;
            for (Map.Entry<V, E> entry : this.directedEdges.get(block).entrySet()) {
                if (idx != i++) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Override
    public List<V> getParents(V block) {
        ArrayList<V> childBlocks = new ArrayList<V>();
        if (this.directedEdges.containsKey(block)) {
            for (Map.Entry<V, E> entry : this.directedEdges.get(block).entrySet()) {
                childBlocks.add(entry.getKey());
            }
        }
        return childBlocks;
    }

    @Override
    public boolean isRoot(V v) {
        return !this.directedEdges.containsKey(v);
    }

    @Override
    public boolean isLeaf(V v) {
        return !this.reversedEdges.containsKey(v);
    }

    @Override
    public int getParentCount(V block) {
        if (this.directedEdges.containsKey(block)) {
            return this.directedEdges.get(block).size();
        }
        return -1;
    }

    @Override
    public void accept(V source, DirectedGraphVisitor<V> visitor) {
        Stack stack = new Stack();
        this.visitRecursive(stack, source, visitor);
    }

    private void visitRecursive(Stack<V> stack, V current, DirectedGraphVisitor<V> visitor) {
        stack.push(current);
        for (V child : this.getChilds(current)) {
            this.visitRecursive(stack, child, visitor);
        }
        stack.pop();
        visitor.visit(stack, current);
    }

    public String toString() {
        return "G (|v| = " + this.directedEdges.size() + ")";
    }

    public String printDepthString(DepthString planStr) {
        StringBuilder output = new StringBuilder();
        String pad = new String(new char[planStr.depth * 3]).replace('\u0000', ' ');
        output.append(pad + "|-" + planStr.vertexStr).append("\n");
        return output.toString();
    }

    public String toStringGraph(V vertex) {
        StringBuilder sb = new StringBuilder();
        QueryGraphTopologyStringBuilder visitor = new QueryGraphTopologyStringBuilder();
        this.accept(vertex, visitor);
        Stack<DepthString> depthStrings = visitor.getDepthStrings();
        while (!depthStrings.isEmpty()) {
            sb.append(this.printDepthString(depthStrings.pop()));
        }
        return sb.toString();
    }

    private class QueryGraphTopologyStringBuilder
    implements DirectedGraphVisitor<V> {
        Stack<DepthString> depthString = new Stack();

        private QueryGraphTopologyStringBuilder() {
        }

        @Override
        public void visit(Stack<V> stack, V vertex) {
            this.depthString.push(new DepthString(stack.size(), vertex.toString()));
        }

        public Stack<DepthString> getDepthStrings() {
            return this.depthString;
        }
    }

    private class DepthString {
        int depth;
        String vertexStr;

        DepthString(int depth, String vertexStr) {
            this.depth = depth;
            this.vertexStr = vertexStr;
        }
    }
}

