/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.util.graph;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.util.graph.SimpleDirectedGraph;
import org.apache.tajo.util.graph.UndirectedGraph;

public class SimpleUndirectedGraph<V, E>
extends SimpleDirectedGraph<V, E>
implements UndirectedGraph<V, E> {
    @Override
    @Nullable
    public E getEdge(V tail, V head) {
        Object edge = super.getEdge(tail, head);
        if (edge != null) {
            return edge;
        }
        edge = super.getEdge(head, tail);
        if (edge != null) {
            return edge;
        }
        return null;
    }

    @Override
    public Collection<E> getEdges(V v) {
        List incomingEdges;
        ArrayList edges = Lists.newArrayList();
        List outgoingEdges = this.getOutgoingEdges(v);
        if (outgoingEdges != null) {
            edges.addAll(outgoingEdges);
        }
        if ((incomingEdges = this.getIncomingEdges(v)) != null) {
            edges.addAll(incomingEdges);
        }
        return edges;
    }

    @Override
    public int getDegree(V v) {
        return this.getEdges(v).size();
    }

    @Override
    public Collection<E> getEdgesAll() {
        ArrayList edges = Lists.newArrayList();
        for (Map map : this.directedEdges.values()) {
            edges.addAll(map.values());
        }
        return edges;
    }

    @Override
    public V getParent(V v, int idx) {
        throw new UnsupportedOperationException("Cannot support getParent(V v) in UndirectedGraph");
    }

    @Override
    public int getParentCount(V v) {
        throw new UnsupportedOperationException("Cannot support getParent(V v) in UndirectedGraph");
    }

    @Override
    public List<V> getParents(V v) {
        throw new UnsupportedOperationException("Cannot support getParent(V v) in UndirectedGraph");
    }

    @Override
    public boolean isRoot(V v) {
        throw new UnsupportedOperationException("Cannot support isRoot(V v) in UndirectedGraph");
    }

    @Override
    public boolean isLeaf(V v) {
        throw new UnsupportedOperationException("Cannot support isLeaf(V v) in UndirectedGraph");
    }
}

