/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Set;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.validation.ConstraintViolation;
import org.apache.tajo.validation.ConstraintViolationException;
import org.apache.tajo.validation.Validator;

public abstract class AbstractValidator
implements Validator {
    protected abstract <T> String getErrorMessage(T var1);

    protected abstract <T> boolean validateInternal(T var1);

    protected abstract Collection<Validator> getDependantValidators();

    @Override
    public <T> Collection<ConstraintViolation> validate(T object) {
        Set<ConstraintViolation> violations = TUtil.newHashSet();
        if (!this.validateInternal(object)) {
            ConstraintViolation violation = new ConstraintViolation();
            violation.setMessage(this.getErrorMessage(object));
            violation.setValidatorClazz(this.getClass());
            violations.add(violation);
        }
        for (Validator dependantValidator : this.getDependantValidators()) {
            violations.addAll(dependantValidator.validate(object));
        }
        return violations;
    }

    @Override
    public <T> void validate(T object, boolean generateThrow) {
        Collection<ConstraintViolation> violations = this.validate(object);
        if (violations.size() > 0 && generateThrow) {
            throw new ConstraintViolationException(violations);
        }
    }
}

