/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import java.util.Collections;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class ClassValidator
extends AbstractValidator {
    @Override
    protected <T> String getErrorMessage(T object) {
        return "ClassLoader cannot find " + object + " class.";
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof CharSequence) {
                String valueString = object.toString();
                try {
                    Class.forName(valueString);
                    result = true;
                }
                catch (ClassNotFoundException e) {
                    result = false;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

