/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.Validator;

public class MinValidator
extends AbstractValidator {
    private final String minValue;

    public MinValidator(String minValue) {
        if (!NumberUtils.isNumber((String)minValue)) {
            throw new IllegalArgumentException(minValue + " is not a Java Number.");
        }
        this.minValue = minValue;
    }

    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " should be greater than " + this.minValue;
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        boolean result = false;
        if (object != null) {
            if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
                Integer minInteger;
                Integer objInteger = Integer.decode(object.toString());
                result = objInteger.compareTo(minInteger = Integer.decode(this.minValue)) >= 0;
            } else if (object instanceof Long) {
                Long minLong;
                Long objLong = Long.decode(object.toString());
                result = objLong.compareTo(minLong = Long.decode(this.minValue)) >= 0;
            } else if (object instanceof Float || object instanceof Double) {
                Double minDouble;
                Double objDouble = Double.valueOf(object.toString());
                result = objDouble.compareTo(minDouble = Double.valueOf(this.minValue)) >= 0;
            } else if (object instanceof BigInteger) {
                BigInteger objInteger = (BigInteger)object;
                BigInteger minInteger = new BigInteger(this.minValue);
                result = objInteger.compareTo(minInteger) >= 0;
            } else if (object instanceof BigDecimal) {
                BigDecimal objDecimal = (BigDecimal)object;
                BigDecimal minDecimal = new BigDecimal(this.minValue);
                result = objDecimal.compareTo(minDecimal) >= 0;
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return Collections.emptySet();
    }
}

