/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.validation;

import java.util.Collection;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.validation.AbstractValidator;
import org.apache.tajo.validation.PathValidator;
import org.apache.tajo.validation.Validator;
import org.apache.tajo.validation.Validators;

public class PathListValidator
extends AbstractValidator {
    private static final String LIST_SEPARATOR = ",";

    @Override
    protected <T> String getErrorMessage(T object) {
        return object + " is not valid path list.";
    }

    @Override
    protected <T> boolean validateInternal(T object) {
        PathValidator validator = (PathValidator)Validators.pathUrl();
        boolean result = true;
        if (object != null) {
            if (object instanceof CharSequence) {
                String valueString = object.toString();
                if (valueString.isEmpty()) {
                    result = true;
                } else {
                    String[] splits;
                    for (String path : splits = object.toString().split(LIST_SEPARATOR)) {
                        result &= validator.validateInternal(path.trim());
                    }
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    protected Collection<Validator> getDependantValidators() {
        return TUtil.newList();
    }
}

