/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.launcher.ContainerOp;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.ContainerLauncherOperationBase;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezContainerLauncherImpl
extends ContainerLauncher {
    static final Logger LOG = LoggerFactory.getLogger(TezContainerLauncherImpl.class);
    private final ConcurrentHashMap<ContainerId, Container> containers = new ConcurrentHashMap();
    protected ThreadPoolExecutor launcherPool;
    protected static final int INITIAL_POOL_SIZE = 10;
    private final int limitOnPoolSize;
    private final Configuration conf;
    private Thread eventHandlingThread;
    protected BlockingQueue<ContainerOp> eventQueue = new LinkedBlockingQueue<ContainerOp>();
    private ContainerManagementProtocolProxy cmProxy;
    private AtomicBoolean serviceStopped = new AtomicBoolean(false);

    private Container getContainer(ContainerOp event) {
        Container old;
        ContainerId id = event.getBaseOperation().getContainerId();
        Container c = this.containers.get(id);
        if (c == null && (old = this.containers.putIfAbsent(id, c = new Container(id, event.getBaseOperation().getNodeId().toString(), event.getBaseOperation().getContainerToken()))) != null) {
            c = old;
        }
        return c;
    }

    private void removeContainerIfDone(ContainerId id) {
        Container c = this.containers.get(id);
        if (c != null && c.isCompletelyDone()) {
            this.containers.remove(id);
        }
    }

    public TezContainerLauncherImpl(ContainerLauncherContext containerLauncherContext) {
        super(containerLauncherContext);
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)containerLauncherContext.getInitialUserPayload());
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to parse user payload for " + TezContainerLauncherImpl.class.getSimpleName(), (Throwable)e);
        }
        this.conf.setInt("ipc.client.connection.maxidletime", 0);
        this.limitOnPoolSize = this.conf.getInt("tez.am.containerlauncher.thread-count-limit", 500);
        LOG.info("Upper limit on the thread pool size is " + this.limitOnPoolSize);
    }

    public void start() {
        this.cmProxy = new ContainerManagementProtocolProxy(this.conf);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf, new CustomizedRejectedExecutionHandler());
        this.eventHandlingThread = new Thread(){

            @Override
            public void run() {
                ContainerOp event = null;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        event = TezContainerLauncherImpl.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        if (!TezContainerLauncherImpl.this.serviceStopped.get()) {
                            LOG.error("Returning, interrupted : " + e);
                        }
                        return;
                    }
                    int poolSize = TezContainerLauncherImpl.this.launcherPool.getCorePoolSize();
                    if (poolSize != TezContainerLauncherImpl.this.limitOnPoolSize) {
                        int numNodes = TezContainerLauncherImpl.this.getContext().getNumNodes(TezConstants.getTezYarnServicePluginName());
                        int idealPoolSize = Math.min(TezContainerLauncherImpl.this.limitOnPoolSize, numNodes);
                        if (poolSize < idealPoolSize) {
                            int newPoolSize = Math.min(TezContainerLauncherImpl.this.limitOnPoolSize, idealPoolSize + 10);
                            LOG.info("Setting ContainerLauncher pool size to " + newPoolSize + " as number-of-nodes to talk to is " + numNodes);
                            TezContainerLauncherImpl.this.launcherPool.setCorePoolSize(newPoolSize);
                        }
                    }
                    TezContainerLauncherImpl.this.launcherPool.execute(TezContainerLauncherImpl.this.createEventProcessor(event));
                }
            }
        };
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
    }

    private void shutdownAllContainers() {
        for (Container ct : this.containers.values()) {
            if (ct == null) continue;
            ct.kill();
        }
    }

    public void shutdown() {
        if (!this.serviceStopped.compareAndSet(false, true)) {
            LOG.info("Ignoring multiple stops");
            return;
        }
        this.shutdownAllContainers();
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        if (this.launcherPool != null) {
            this.launcherPool.shutdownNow();
        }
    }

    protected EventProcessor createEventProcessor(ContainerOp event) {
        return new EventProcessor(event);
    }

    protected ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData getCMProxy(ContainerId containerID, String containerManagerBindAddr, Token containerToken) throws IOException {
        return this.cmProxy.getProxy(containerManagerBindAddr, containerID);
    }

    void sendContainerLaunchFailedMsg(ContainerId containerId, String message) {
        LOG.error(message);
        this.getContext().containerLaunchFailed(containerId, message);
    }

    public void launchContainer(ContainerLaunchRequest launchRequest) {
        try {
            this.eventQueue.put(new ContainerOp(ContainerOp.OPType.LAUNCH_REQUEST, (ContainerLauncherOperationBase)launchRequest));
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public void stopContainer(ContainerStopRequest stopRequest) {
        try {
            this.eventQueue.put(new ContainerOp(ContainerOp.OPType.STOP_REQUEST, (ContainerLauncherOperationBase)stopRequest));
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private static class CustomizedRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private CustomizedRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOG.warn("Can't submit task to ThreadPoolExecutor:" + executor);
        }
    }

    class EventProcessor
    implements Runnable {
        private ContainerOp event;

        EventProcessor(ContainerOp event) {
            this.event = event;
        }

        @Override
        public void run() {
            ContainerId containerID = this.event.getBaseOperation().getContainerId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing ContainerOperation {}", (Object)this.event);
            }
            Container c = TezContainerLauncherImpl.this.getContainer(this.event);
            switch (this.event.getOpType()) {
                case LAUNCH_REQUEST: {
                    ContainerLaunchRequest launchRequest = this.event.getLaunchRequest();
                    c.launch(launchRequest);
                    break;
                }
                case STOP_REQUEST: {
                    c.kill();
                }
            }
            TezContainerLauncherImpl.this.removeContainerIfDone(containerID);
        }
    }

    private class Container {
        private ContainerState state = ContainerState.PREP;
        private ContainerId containerID;
        private final String containerMgrAddress;
        private Token containerToken;

        public Container(ContainerId containerID, String containerMgrAddress, Token containerToken) {
            this.containerMgrAddress = containerMgrAddress;
            this.containerID = containerID;
            this.containerToken = containerToken;
        }

        public synchronized boolean isCompletelyDone() {
            return this.state == ContainerState.DONE || this.state == ContainerState.FAILED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void launch(ContainerLaunchRequest event) {
            LOG.info("Launching " + event.getContainerId());
            if (this.state == ContainerState.KILLED_BEFORE_LAUNCH) {
                this.state = ContainerState.DONE;
                TezContainerLauncherImpl.this.sendContainerLaunchFailedMsg(event.getContainerId(), "Container was killed before it was launched");
                return;
            }
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            try {
                proxy = TezContainerLauncherImpl.this.getCMProxy(this.containerID, this.containerMgrAddress, this.containerToken);
                ContainerLaunchContext containerLaunchContext = event.getContainerLaunchContext();
                StartContainerRequest startRequest = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                startRequest.setContainerToken(event.getContainerToken());
                startRequest.setContainerLaunchContext(containerLaunchContext);
                StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(StartContainersRequest.newInstance(Collections.singletonList(startRequest)));
                if (response.getFailedRequests() != null && !response.getFailedRequests().isEmpty()) {
                    throw ((SerializedException)response.getFailedRequests().get(this.containerID)).deSerialize();
                }
                TezContainerLauncherImpl.this.getContext().containerLaunched(this.containerID);
                this.state = ContainerState.RUNNING;
                if (proxy == null) return;
            }
            catch (Throwable t) {
                try {
                    String message = "Container launch failed for " + this.containerID + " : " + ExceptionUtils.getStackTrace((Throwable)t);
                    this.state = ContainerState.FAILED;
                    TezContainerLauncherImpl.this.sendContainerLaunchFailedMsg(this.containerID, message);
                    if (proxy == null) return;
                }
                catch (Throwable throwable) {
                    if (proxy == null) throw throwable;
                    TezContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
                    throw throwable;
                }
                TezContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
                return;
            }
            TezContainerLauncherImpl.this.cmProxy.mayBeCloseProxy(proxy);
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public synchronized void kill() {
            if (this.isCompletelyDone()) {
                return;
            }
            if (this.state == ContainerState.PREP) {
                this.state = ContainerState.KILLED_BEFORE_LAUNCH;
            } else {
                TezContainerLauncherImpl.LOG.info("Stopping " + this.containerID);
                proxy = null;
                try {
                    proxy = TezContainerLauncherImpl.this.getCMProxy(this.containerID, this.containerMgrAddress, this.containerToken);
                    stopRequest = (StopContainersRequest)Records.newRecord(StopContainersRequest.class);
                    stopRequest.setContainerIds(Collections.singletonList(this.containerID));
                    proxy.getContainerManagementProtocol().stopContainers(stopRequest);
                    TezContainerLauncherImpl.this.getContext().containerStopRequested(this.containerID);
                    ** if (proxy == null) goto lbl-1000
                }
                catch (Throwable t) {
                    block9: {
                        try {
                            message = "cleanup failed for container " + this.containerID + " : " + ExceptionUtils.getStackTrace((Throwable)t);
                            TezContainerLauncherImpl.this.getContext().containerStopFailed(this.containerID, message);
                            TezContainerLauncherImpl.LOG.warn(message);
                            this.state = ContainerState.DONE;
                            if (proxy == null) break block9;
                        }
                        catch (Throwable var4_5) {
                            if (proxy != null) {
                                TezContainerLauncherImpl.access$000(TezContainerLauncherImpl.this).mayBeCloseProxy(proxy);
                            }
                            throw var4_5;
                        }
                        TezContainerLauncherImpl.access$000(TezContainerLauncherImpl.this).mayBeCloseProxy(proxy);
                    }
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    TezContainerLauncherImpl.access$000(TezContainerLauncherImpl.this).mayBeCloseProxy(proxy);
                }
lbl-1000:
                // 2 sources

                {
                }
                this.state = ContainerState.DONE;
            }
        }
    }

    private static enum ContainerState {
        PREP,
        FAILED,
        RUNNING,
        DONE,
        KILLED_BEFORE_LAUNCH;

    }
}

