/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;

public class StreamingUpdateRequest
extends AbstractUpdateRequest {
    private final RequestWriter.ContentWriter contentWriter;

    public StreamingUpdateRequest(String path, RequestWriter.ContentWriter contentWriter) {
        super(SolrRequest.METHOD.POST, path);
        this.contentWriter = contentWriter;
    }

    public StreamingUpdateRequest(String path, final String content, final String contentType) {
        this(path, new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                os.write(content.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public String getContentType() {
                return contentType;
            }
        });
    }

    public StreamingUpdateRequest(String path, final File f, final String contentType) {
        this(path, new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                try (FileInputStream is = new FileInputStream(f);){
                    IOUtils.copy((InputStream)is, os);
                }
            }

            @Override
            public String getContentType() {
                return contentType;
            }
        });
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return this.contentWriter;
    }
}

