/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerReplicaStatesOps {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PerReplicaStates rs;
    List<PerReplicaStates.Operation> ops;
    private boolean preOp = true;
    final Function<PerReplicaStates, List<PerReplicaStates.Operation>> fun;

    PerReplicaStatesOps(Function<PerReplicaStates, List<PerReplicaStates.Operation>> fun) {
        this.fun = fun;
    }

    private void persist(List<PerReplicaStates.Operation> operations, String znode, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        if (operations == null || operations.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Per-replica state being persisted for : '{}', ops: {}", (Object)znode, (Object)operations);
        }
        ArrayList<Op> ops = new ArrayList<Op>(operations.size());
        for (PerReplicaStates.Operation op : operations) {
            String path = znode + "/" + op.state.asString;
            ops.add(op.typ == PerReplicaStates.Operation.Type.ADD ? Op.create(path, null, zkClient.getZkACLProvider().getACLsToAdd(path), CreateMode.PERSISTENT) : Op.delete(path, -1));
        }
        try {
            zkClient.multi(ops, true);
        }
        catch (KeeperException e) {
            log.error("multi op exception : " + e.getMessage() + zkClient.getChildren(znode, null, true));
            throw e;
        }
    }

    private static List<PerReplicaStates.Operation> addDeleteStaleNodes(List<PerReplicaStates.Operation> ops, PerReplicaStates.State rs) {
        while (rs != null) {
            ops.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.DELETE, rs));
            rs = rs.duplicate;
        }
        return ops;
    }

    public void persist(String znode, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        List<PerReplicaStates.Operation> operations = this.ops;
        for (int i = 0; i < 5; ++i) {
            try {
                this.persist(operations, znode, zkClient);
                return;
            }
            catch (KeeperException.NoNodeException | KeeperException.NodeExistsException e) {
                if (log.isInfoEnabled()) {
                    log.info("Stale state for {}, attempt: {}. retrying...", (Object)znode, (Object)i);
                }
                operations = this.refresh(PerReplicaStates.fetch(znode, zkClient, null));
                continue;
            }
        }
    }

    public PerReplicaStates getPerReplicaStates() {
        return this.rs;
    }

    public static PerReplicaStatesOps flipState(String replica, Replica.State newState, PerReplicaStates rs) {
        return new PerReplicaStatesOps(prs -> {
            ArrayList<PerReplicaStates.Operation> operations = new ArrayList<PerReplicaStates.Operation>(2);
            PerReplicaStates.State existing = prs.get(replica);
            if (existing == null) {
                operations.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(replica, newState, Boolean.FALSE, 0)));
            } else {
                operations.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(replica, newState, existing.isLeader, existing.version + 1)));
                PerReplicaStatesOps.addDeleteStaleNodes(operations, existing);
            }
            if (log.isDebugEnabled()) {
                log.debug("flipState on {}, {} -> {}, ops :{}", new Object[]{prs.path, replica, newState, operations});
            }
            return operations;
        }).init(rs);
    }

    public static PerReplicaStatesOps modifyCollection(DocCollection coll, boolean enable, PerReplicaStates rs) {
        return new PerReplicaStatesOps(prs -> enable ? PerReplicaStatesOps.enable(coll) : PerReplicaStatesOps.disable(prs)).init(rs);
    }

    private static List<PerReplicaStates.Operation> enable(DocCollection coll) {
        ArrayList<PerReplicaStates.Operation> result = new ArrayList<PerReplicaStates.Operation>();
        coll.forEachReplica((s, r) -> result.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(r.getName(), r.getState(), r.isLeader(), 0))));
        return result;
    }

    private static List<PerReplicaStates.Operation> disable(PerReplicaStates prs) {
        ArrayList<PerReplicaStates.Operation> result = new ArrayList<PerReplicaStates.Operation>();
        prs.states.forEachEntry((s, state) -> result.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.DELETE, (PerReplicaStates.State)state)));
        return result;
    }

    public static PerReplicaStatesOps flipLeader(Set<String> allReplicas, String next, PerReplicaStates rs) {
        return new PerReplicaStatesOps(prs -> {
            ArrayList<PerReplicaStates.Operation> ops = new ArrayList<PerReplicaStates.Operation>();
            if (next != null) {
                PerReplicaStates.State st = prs.get(next);
                if (st != null) {
                    if (!st.isLeader.booleanValue()) {
                        ops.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(st.replica, Replica.State.ACTIVE, Boolean.TRUE, st.version + 1)));
                        ops.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.DELETE, st));
                    }
                } else {
                    ops.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(next, Replica.State.ACTIVE, Boolean.TRUE, 0)));
                }
            }
            for (String r : allReplicas) {
                PerReplicaStates.State st = prs.get(r);
                if (st == null || Objects.equals(r, next) || !st.isLeader.booleanValue()) continue;
                ops.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(st.replica, st.state, Boolean.FALSE, st.version + 1)));
                ops.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.DELETE, st));
            }
            if (log.isDebugEnabled()) {
                log.debug("flipLeader on:{}, {} -> {}, ops: {}", prs.path, allReplicas, next, ops);
            }
            return ops;
        }).init(rs);
    }

    public static PerReplicaStatesOps deleteReplica(String replica, PerReplicaStates rs) {
        return new PerReplicaStatesOps(prs -> {
            List<Object> result;
            if (prs == null) {
                result = Collections.emptyList();
            } else {
                PerReplicaStates.State state = prs.get(replica);
                result = PerReplicaStatesOps.addDeleteStaleNodes(new ArrayList<PerReplicaStates.Operation>(), state);
            }
            return result;
        }).init(rs);
    }

    public static PerReplicaStatesOps addReplica(String replica, Replica.State state, boolean isLeader, PerReplicaStates rs) {
        return new PerReplicaStatesOps(perReplicaStates -> Collections.singletonList(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(replica, state, isLeader, 0)))).init(rs);
    }

    public static PerReplicaStatesOps downReplicas(List<String> replicas, PerReplicaStates rs) {
        return new PerReplicaStatesOps(prs -> {
            ArrayList<PerReplicaStates.Operation> operations = new ArrayList<PerReplicaStates.Operation>();
            for (String replica : replicas) {
                PerReplicaStates.State r = prs.get(replica);
                if (r != null) {
                    if (r.state == Replica.State.DOWN && !r.isLeader.booleanValue()) continue;
                    operations.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(replica, Replica.State.DOWN, Boolean.FALSE, r.version + 1)));
                    PerReplicaStatesOps.addDeleteStaleNodes(operations, r);
                    continue;
                }
                operations.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, new PerReplicaStates.State(replica, Replica.State.DOWN, Boolean.FALSE, 0)));
            }
            if (log.isDebugEnabled()) {
                log.debug("for coll: {} down replicas {}, ops {}", prs, replicas, operations);
            }
            return operations;
        }).init(rs);
    }

    public static PerReplicaStatesOps touchChildren() {
        PerReplicaStatesOps result = new PerReplicaStatesOps(prs -> {
            ArrayList<PerReplicaStates.Operation> operations = new ArrayList<PerReplicaStates.Operation>(2);
            PerReplicaStates.State st = new PerReplicaStates.State(".dummy." + System.nanoTime(), Replica.State.DOWN, Boolean.FALSE, 0);
            operations.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.ADD, st));
            operations.add(new PerReplicaStates.Operation(PerReplicaStates.Operation.Type.DELETE, st));
            if (log.isDebugEnabled()) {
                log.debug("touchChildren {}", (Object)operations);
            }
            return operations;
        });
        result.preOp = false;
        result.ops = result.refresh(null);
        return result;
    }

    PerReplicaStatesOps init(PerReplicaStates rs) {
        if (rs == null) {
            return null;
        }
        this.get(rs);
        return this;
    }

    public List<PerReplicaStates.Operation> get() {
        return this.ops;
    }

    public List<PerReplicaStates.Operation> get(PerReplicaStates rs) {
        this.ops = this.refresh(rs);
        if (this.ops == null) {
            this.ops = Collections.emptyList();
        }
        this.rs = rs;
        return this.ops;
    }

    public boolean isPreOp() {
        return this.preOp;
    }

    List<PerReplicaStates.Operation> refresh(PerReplicaStates prs) {
        if (this.fun != null) {
            return this.fun.apply(prs);
        }
        return null;
    }

    public String toString() {
        return this.ops.toString();
    }
}

