/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.prt;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.prt.PRTParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class PRTParserTest
extends TikaTest {
    @Test
    public void testPRTParserBasics() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testCADKEY.prt");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new PRTParser().parse(input, (ContentHandler)handler, metadata);
            Assertions.assertEquals((Object)"application/x-prt", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2011-06-20T16:54:00", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            String contents = handler.toString();
            PRTParserTest.assertContains((String)"Front View", (String)contents);
            PRTParserTest.assertContains((String)"Back View", (String)contents);
            PRTParserTest.assertContains((String)"Bottom View", (String)contents);
            PRTParserTest.assertContains((String)"Right View", (String)contents);
            PRTParserTest.assertContains((String)"Left View", (String)contents);
            PRTParserTest.assertContains((String)"Axonometric View", (String)contents);
            PRTParserTest.assertContains((String)"You've managed to extract all the text!", (String)contents);
            PRTParserTest.assertContains((String)"This is more text", (String)contents);
            PRTParserTest.assertContains((String)"Text Inside a PRT file", (String)contents);
        }
    }

    @Test
    public void testPRTParserComplex() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testCADKEY2.prt");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new PRTParser().parse(input, (ContentHandler)handler, metadata);
            Assertions.assertEquals((Object)"application/x-prt", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"1997-04-01T08:59:00", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals((Object)"TIKA TEST PART DESCRIPTION INFORMATION\r\n", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            String contents = handler.toString();
            PRTParserTest.assertContains((String)"ITEM", (String)contents);
            PRTParserTest.assertContains((String)"REQ.", (String)contents);
            PRTParserTest.assertContains((String)"DESCRIPTION", (String)contents);
            PRTParserTest.assertContains((String)"MAT'L", (String)contents);
            PRTParserTest.assertContains((String)"TOLERANCES UNLESS", (String)contents);
            PRTParserTest.assertContains((String)"FRACTIONS", (String)contents);
            PRTParserTest.assertContains((String)"ANGLES", (String)contents);
            PRTParserTest.assertContains((String)"Acme Corporation", (String)contents);
            PRTParserTest.assertContains((String)"DATE", (String)contents);
            PRTParserTest.assertContains((String)"CHANGE", (String)contents);
            PRTParserTest.assertContains((String)"DRAWN BY", (String)contents);
            PRTParserTest.assertContains((String)"SCALE", (String)contents);
            PRTParserTest.assertContains((String)"TIKA TEST DRAWING", (String)contents);
            PRTParserTest.assertContains((String)"TIKA LETTERS", (String)contents);
            PRTParserTest.assertContains((String)"5.82", (String)contents);
            PRTParserTest.assertContains((String)"112\u00b0", (String)contents);
            PRTParserTest.assertContains((String)"TIKA TEST LETTER", (String)contents);
            PRTParserTest.assertContains((String)"17.11", (String)contents);
            PRTParserTest.assertContains((String)"\u00d8\ufffd2.000", (String)contents);
            PRTParserTest.assertContains((String)"Diameter", (String)contents);
            PRTParserTest.assertContains((String)"The Apache Tika toolkit", (String)contents);
        }
    }
}

