/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.dwg.DWGParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class DWGParserTest {
    @Test
    public void testDWG2000Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2000.dwg");
        this.testParserAlt(input);
    }

    @Test
    public void testDWG2004Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2004.dwg");
        this.testParser(input);
    }

    @Test
    public void testDWG2004ParserNoHeaderAddress() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2004_no_header.dwg");
        this.testParserNoHeader(input);
    }

    @Test
    public void testDWG2007Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2007.dwg");
        this.testParser(input);
    }

    @Test
    public void testDWG2010Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2010.dwg");
        this.testParser(input);
    }

    @Test
    public void testDWG2010CustomPropertiesParser() throws Exception {
        InputStream testInput = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2010_custom_props.dwg");
        this.testParser(testInput);
        try (InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2010_custom_props.dwg");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata, null);
            Assertions.assertEquals((Object)"valueforcustomprop1", (Object)metadata.get("customprop1"));
            Assertions.assertEquals((Object)"valueforcustomprop2", (Object)metadata.get("customprop2"));
        }
    }

    @Test
    public void testDWGMechParser() throws Exception {
        String[] types;
        for (String type : types = new String[]{"6", "2004", "2004DX", "2005", "2006", "2007", "2008", "2009", "2010", "2011"}) {
            InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWGmech" + type + ".dwg");
            this.testParserAlt(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParser(InputStream input) throws Exception {
        try {
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata);
            Assertions.assertEquals((Object)"image/vnd.dwg", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Gym class featuring a brown fox and lazy dog", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"Nevin Nollop", (Object)metadata.get(TikaCoreProperties.CREATOR));
            TikaTest.assertContains((Object)"Pangram, fox, dog", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
            Assertions.assertEquals((Object)"Lorem ipsum", (Object)metadata.get(TikaCoreProperties.COMMENTS).substring(0, 11));
            Assertions.assertEquals((Object)"http://www.alfresco.com", (Object)metadata.get(TikaCoreProperties.RELATION));
            String content = handler.toString();
            TikaTest.assertContains((String)"The quick brown fox jumps over the lazy dog", (String)content);
            TikaTest.assertContains((String)"Gym class", (String)content);
            TikaTest.assertContains((String)"www.alfresco.com", (String)content);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParserNoHeader(InputStream input) throws Exception {
        try {
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata);
            Assertions.assertEquals((Object)"image/vnd.dwg", (Object)metadata.get("Content-Type"));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.SUBJECT));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.COMMENTS));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.RELATION));
            String content = handler.toString();
            Assertions.assertEquals((Object)"", (Object)content);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParserAlt(InputStream input) throws Exception {
        try {
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata);
            Assertions.assertEquals((Object)"image/vnd.dwg", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Test Subject", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"My Author", (Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)"My keyword1, MyKeyword2", (Object)metadata.get(TikaCoreProperties.SUBJECT));
            Assertions.assertEquals((Object)"This is a comment", (Object)metadata.get(TikaCoreProperties.COMMENTS));
            Assertions.assertEquals((Object)"bejanpol", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals((Object)"http://mycompany/drawings", (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals((Object)"MyCustomPropertyValue", (Object)metadata.get("MyCustomProperty"));
            String content = handler.toString();
            TikaTest.assertContains((String)"This is a comment", (String)content);
            TikaTest.assertContains((String)"mycompany", (String)content);
        }
        finally {
            input.close();
        }
    }
}

