/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.crypto;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.crypto.Pkcs7Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.xml.sax.ContentHandler;

public class Pkcs7ParserTest
extends TikaTest {
    public void testDetachedSignature() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testDetached.p7s");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new Pkcs7Parser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
        }
        catch (NullPointerException npe) {
            Assertions.fail((String)"should not get NPE");
        }
        catch (TikaException te) {
            Assertions.assertTrue((boolean)te.toString().contains("cannot parse detached pkcs7 signature"));
        }
    }
}

