/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xslf;

import java.io.IOException;
import java.util.Date;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.ParagraphProperties;
import org.apache.tika.parser.microsoft.ooxml.RunProperties;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFEventBasedWordExtractor;
import org.apache.xmlbeans.XmlException;

public class XSLFEventBasedPowerPointExtractor
extends POIXMLTextExtractor {
    private OPCPackage container;
    private POIXMLProperties properties;

    public XSLFEventBasedPowerPointExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this(OPCPackage.open((String)path, (PackageAccess)PackageAccess.READ));
    }

    public XSLFEventBasedPowerPointExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        super((POIXMLDocument)null);
        this.container = container;
        this.properties = new POIXMLProperties(container);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSLFEventBasedPowerPointExtractor <filename.pptx>");
            System.exit(1);
        }
        XWPFEventBasedWordExtractor extractor = new XWPFEventBasedWordExtractor(args[0]);
        System.out.println(extractor.getText());
        extractor.close();
    }

    public OPCPackage getPackage() {
        return this.container;
    }

    public POIXMLProperties.CoreProperties getCoreProperties() {
        return this.properties.getCoreProperties();
    }

    public POIXMLProperties.ExtendedProperties getExtendedProperties() {
        return this.properties.getExtendedProperties();
    }

    public POIXMLProperties.CustomProperties getCustomProperties() {
        return this.properties.getCustomProperties();
    }

    public String getText() {
        return "";
    }

    private static class XSLFToTextContentHandler
    implements OOXMLWordAndPowerPointTextHandler.XWPFBodyContentsHandler {
        private final StringBuilder buffer;

        public XSLFToTextContentHandler(StringBuilder buffer) {
            this.buffer = buffer;
        }

        @Override
        public void run(RunProperties runProperties, String contents) {
            this.buffer.append(contents);
        }

        @Override
        public void hyperlinkStart(String link) {
        }

        @Override
        public void hyperlinkEnd() {
        }

        @Override
        public void startParagraph(ParagraphProperties paragraphProperties) {
        }

        @Override
        public void endParagraph() {
            this.buffer.append("\n");
        }

        @Override
        public void startTable() {
        }

        @Override
        public void endTable() {
        }

        @Override
        public void startTableRow() {
        }

        @Override
        public void endTableRow() {
            this.buffer.append("\n");
        }

        @Override
        public void startTableCell() {
        }

        @Override
        public void endTableCell() {
            this.buffer.append("\t");
        }

        @Override
        public void startSDT() {
        }

        @Override
        public void endSDT() {
        }

        @Override
        public void startEditedSection(String editor, Date date, OOXMLWordAndPowerPointTextHandler.EditType editType) {
        }

        @Override
        public void endEditedSection() {
        }

        @Override
        public boolean isIncludeDeletedText() {
            return false;
        }

        @Override
        public void footnoteReference(String id) {
        }

        @Override
        public void endnoteReference(String id) {
        }

        @Override
        public boolean isIncludeMoveFromText() {
            return false;
        }

        @Override
        public void embeddedOLERef(String refId) {
        }

        @Override
        public void embeddedPicRef(String picFileName, String picDescription) {
        }

        @Override
        public void startBookmark(String id, String name) {
        }

        @Override
        public void endBookmark(String id) {
        }
    }
}

