/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIContainerExtractionTest;
import org.apache.tika.parser.microsoft.OldExcelParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class OldExcelParserTest
extends TikaTest {
    private static final String file = "testEXCEL_4.xls";

    @Test
    public void testDetection() throws Exception {
        DefaultDetector detector = new DefaultDetector();
        try (TikaInputStream stream = AbstractPOIContainerExtractionTest.getTestFile(file);){
            Assertions.assertEquals((Object)MediaType.application((String)"vnd.ms-excel.sheet.4"), (Object)detector.detect((InputStream)stream, new Metadata()));
        }
    }

    @Test
    @Disabled
    public void testMetadata() throws Exception {
        TikaInputStream stream = AbstractPOIContainerExtractionTest.getTestFile(file);
        Metadata metadata = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        OldExcelParser parser = new OldExcelParser();
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        Assertions.assertEquals((Object)"application/vnd.ms-excel.sheet.4", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SUBJECT));
    }

    @Test
    public void testPlainText() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (TikaInputStream stream = AbstractPOIContainerExtractionTest.getTestFile(file);){
            new OldExcelParser().parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String text = handler.toString();
        OldExcelParserTest.assertContains((String)"Size", (String)text);
        OldExcelParserTest.assertContains((String)"Returns", (String)text);
        OldExcelParserTest.assertContains((String)"11", (String)text);
        OldExcelParserTest.assertContains((String)"784", (String)text);
    }

    @Test
    public void testHTML() throws Exception {
        TikaTest.XMLResult result = this.getXML(file);
        String xml = result.xml;
        OldExcelParserTest.assertNotContained((String)"<p>Sheet 1</p>", (String)xml);
        OldExcelParserTest.assertContains((String)"<p>Table 10 -", (String)xml);
        OldExcelParserTest.assertContains((String)"<p>Tax</p>", (String)xml);
        OldExcelParserTest.assertContains((String)"<p>N/A</p>", (String)xml);
        OldExcelParserTest.assertContains((String)"<p>(1)</p>", (String)xml);
        OldExcelParserTest.assertContains((String)"<p>5.0</p>", (String)xml);
    }

    @Test
    public void testToXMLInOldExcelParser() throws Exception {
        String xml = this.getXML((String)"testEXCEL_5.xls").xml;
        OldExcelParserTest.assertContains((String)"Written and saved in Microsoft Excel X for Mac Service Release 1", (String)xml);
    }
}

