/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class SolidworksParserTest
extends TikaTest {
    @Test
    public void testPart2013SP2Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testsolidworksPart2013SP2.SLDPRT");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/sldworks", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2012-04-18T10:27:29Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CONTRIBUTOR));
            Assertions.assertEquals((Object)"2013-09-06T08:12:12Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            Assertions.assertEquals((Object)"solidworks-dcom_dev", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RIGHTS));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SOURCE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
    }

    @Test
    public void testPart2014SP0Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testsolidworksPart2014SP0.SLDPRT");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/sldworks", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2012-04-18T10:27:29Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CONTRIBUTOR));
            Assertions.assertEquals((Object)"2013-11-28T12:38:28Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            Assertions.assertEquals((Object)"solidworks-dcom_dev", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RIGHTS));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SOURCE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
    }

    @Test
    public void testAssembly2013SP2Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testsolidworksAssembly2013SP2.SLDASM");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/sldworks", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2012-04-25T09:51:38Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CONTRIBUTOR));
            Assertions.assertEquals((Object)"2013-09-06T08:11:08Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            Assertions.assertEquals((Object)"solidworks-dcom_dev", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RIGHTS));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SOURCE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
    }

    @Test
    public void testAssembly2014SP0Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testsolidworksAssembly2014SP0.SLDASM");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/sldworks", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2012-04-25T09:51:38Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CONTRIBUTOR));
            Assertions.assertEquals((Object)"2013-11-28T12:41:49Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            Assertions.assertEquals((Object)"solidworks-dcom_dev", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RIGHTS));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SOURCE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
    }

    @Test
    public void testDrawing2013SP2Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testsolidworksDrawing2013SP2.SLDDRW");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/sldworks", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2012-07-03T12:05:29Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CONTRIBUTOR));
            Assertions.assertEquals((Object)"2013-09-06T08:06:57Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            Assertions.assertEquals((Object)"solidworks-dcom_dev", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RIGHTS));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SOURCE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
    }

    @Test
    public void testDrawing2014SP0Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testsolidworksDrawing2014SP0.SLDDRW");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/sldworks", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"2012-07-03T12:05:29Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CONTRIBUTOR));
            Assertions.assertEquals((Object)"2013-11-28T12:41:49Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            Assertions.assertEquals((Object)"solidworks-dcom_dev", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.RIGHTS));
            Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.SOURCE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
    }
}

