/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.microsoft.chm.ChmBlockInfo;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.ChmItspHeader;
import org.apache.tika.parser.microsoft.chm.ChmLzxcControlData;
import org.apache.tika.parser.microsoft.chm.ChmLzxcResetTable;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestChmBlockInfo {
    private byte[] data;
    private ChmBlockInfo chmBlockInfo;
    private ChmDirectoryListingSet chmDirListCont = null;
    private ChmLzxcResetTable clrt = null;
    private ChmLzxcControlData chmLzxcControlData = null;

    @BeforeEach
    public void setUp() throws Exception {
        this.data = TestParameters.chmData;
        ChmItsfHeader chmItsHeader = new ChmItsfHeader();
        chmItsHeader.parse(ChmCommons.copyOfRange((byte[])this.data, (int)0, (int)95), chmItsHeader);
        ChmItspHeader chmItspHeader = new ChmItspHeader();
        chmItspHeader.parse(ChmCommons.copyOfRange((byte[])this.data, (int)((int)chmItsHeader.getDirOffset()), (int)((int)chmItsHeader.getDirOffset() + 84)), chmItspHeader);
        this.chmDirListCont = new ChmDirectoryListingSet(this.data, chmItsHeader, chmItspHeader);
        int indexOfControlData = this.chmDirListCont.getControlDataIndex();
        int indexOfResetTable = ChmCommons.indexOfResetTableBlock((byte[])this.data, (byte[])"LZXC".getBytes(StandardCharsets.UTF_8));
        byte[] dir_chunk = null;
        if (indexOfResetTable > 0) {
            dir_chunk = ChmCommons.copyOfRange((byte[])this.data, (int)indexOfResetTable, (int)(indexOfResetTable + ((DirectoryListingEntry)this.chmDirListCont.getDirectoryListingEntryList().get(indexOfControlData)).getLength()));
        }
        this.chmLzxcControlData = new ChmLzxcControlData();
        this.chmLzxcControlData.parse(dir_chunk, this.chmLzxcControlData);
        int indexOfFeList = this.chmDirListCont.getResetTableIndex();
        int startIndex = (int)this.chmDirListCont.getDataOffset() + ((DirectoryListingEntry)this.chmDirListCont.getDirectoryListingEntryList().get(indexOfFeList)).getOffset();
        dir_chunk = ChmCommons.copyOfRange((byte[])this.data, (int)startIndex, (int)(startIndex + ((DirectoryListingEntry)this.chmDirListCont.getDirectoryListingEntryList().get(indexOfFeList)).getLength()));
        this.clrt = new ChmLzxcResetTable();
        this.clrt.parse(dir_chunk, this.clrt);
    }

    @Test
    public void testToString() throws ChmParsingException {
        if (this.chmBlockInfo == null) {
            this.testGetChmBlockInfo();
        }
        Assertions.assertTrue((this.chmBlockInfo.toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetChmBlockInfo() throws ChmParsingException {
        for (DirectoryListingEntry directoryListingEntry : this.chmDirListCont.getDirectoryListingEntryList()) {
            this.chmBlockInfo = ChmBlockInfo.getChmBlockInfoInstance((DirectoryListingEntry)directoryListingEntry, (int)((int)this.clrt.getBlockLen()), (ChmLzxcControlData)this.chmLzxcControlData);
            Assertions.assertTrue((!ChmCommons.isEmpty((String)directoryListingEntry.getName()) && this.chmBlockInfo.toString() != null ? 1 : 0) != 0);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.data = null;
        this.chmBlockInfo = null;
    }
}

