/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.ChmItspHeader;
import org.apache.tika.parser.microsoft.chm.ChmLzxState;
import org.apache.tika.parser.microsoft.chm.ChmLzxcControlData;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestChmLzxState {
    private ChmLzxState chmLzxState;
    private int windowSize;

    @BeforeEach
    public void setUp() throws Exception {
        byte[] data = TestParameters.chmData;
        ChmItsfHeader chmItsHeader = new ChmItsfHeader();
        chmItsHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), chmItsHeader);
        ChmItspHeader chmItspHeader = new ChmItspHeader();
        chmItspHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)((int)chmItsHeader.getDirOffset()), (int)((int)chmItsHeader.getDirOffset() + 84)), chmItspHeader);
        ChmDirectoryListingSet chmDirListCont = new ChmDirectoryListingSet(data, chmItsHeader, chmItspHeader);
        int indexOfControlData = ChmCommons.indexOf((List)chmDirListCont.getDirectoryListingEntryList(), (String)"ControlData");
        int indexOfResetTable = ChmCommons.indexOfResetTableBlock((byte[])data, (byte[])"LZXC".getBytes(StandardCharsets.UTF_8));
        byte[] dir_chunk = null;
        if (indexOfResetTable > 0) {
            dir_chunk = ChmCommons.copyOfRange((byte[])data, (int)indexOfResetTable, (int)(indexOfResetTable + ((DirectoryListingEntry)chmDirListCont.getDirectoryListingEntryList().get(indexOfControlData)).getLength()));
        }
        ChmLzxcControlData clcd = new ChmLzxcControlData();
        clcd.parse(dir_chunk, clcd);
        this.windowSize = (int)clcd.getWindowSize();
    }

    @Test
    public void testChmLzxStateConstructor() throws TikaException {
        this.chmLzxState = new ChmLzxState(this.windowSize);
        Assertions.assertNotNull((Object)this.chmLzxState);
    }

    @Test
    public void testToString() throws TikaException {
        if (this.chmLzxState == null) {
            this.testChmLzxStateConstructor();
        }
        Assertions.assertTrue((this.chmLzxState.toString().length() > 20 ? 1 : 0) != 0);
    }
}

