/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.util.LocaleUtil;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class OOXMLParserTest
extends TikaTest {
    private static Locale USER_LOCALE = null;

    @BeforeAll
    public static void setUp() {
        USER_LOCALE = LocaleUtil.getUserLocale();
    }

    @AfterAll
    public static void tearDown() {
        LocaleUtil.setUserLocale((Locale)USER_LOCALE);
        Locale.setDefault(USER_LOCALE);
    }

    @BeforeEach
    public void beforeEach() {
        LocaleUtil.setUserLocale((Locale)Locale.US);
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testExcel() throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        String content = this.getText("testEXCEL.xlsx", metadata, context);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Simple Excel document", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
        OOXMLParserTest.assertContains((String)"Sample Excel Worksheet", (String)content);
        OOXMLParserTest.assertContains((String)"Numbers and their Squares", (String)content);
        OOXMLParserTest.assertContains((String)"9", (String)content);
        OOXMLParserTest.assertNotContained((String)"9.0", (String)content);
        OOXMLParserTest.assertContains((String)"196", (String)content);
        OOXMLParserTest.assertNotContained((String)"196.0", (String)content);
        Assertions.assertEquals((Object)"false", (Object)metadata.get("protected"));
    }

    @Test
    public void testExcelFormats() throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        String content = this.getText("testEXCEL-formats.xlsx", metadata, context);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)metadata.get("Content-Type"));
        OOXMLParserTest.assertContains((String)"1,599.99", (String)content);
        OOXMLParserTest.assertContains((String)"-1,599.99", (String)content);
        OOXMLParserTest.assertContains((String)"$1,599.99", (String)content);
        OOXMLParserTest.assertContains((String)"$1,599.99)", (String)content);
        Assertions.assertTrue((content.contains("1.98E08") || content.contains("1.98E+08") ? 1 : 0) != 0);
        Assertions.assertTrue((content.contains("-1.98E08") || content.contains("-1.98E+08") ? 1 : 0) != 0);
        OOXMLParserTest.assertContains((String)"2.50%", (String)content);
        if (System.getProperty("java.version").startsWith("1.5")) {
            OOXMLParserTest.assertContains((String)"2%", (String)content);
        } else {
            OOXMLParserTest.assertContains((String)"3%", (String)content);
        }
        OOXMLParserTest.assertContains((String)"6:15", (String)content);
        OOXMLParserTest.assertContains((String)"18:15", (String)content);
        OOXMLParserTest.assertContains((String)"17-May-07", (String)content);
        OOXMLParserTest.assertContains((String)"$1,599.99", (String)content);
        OOXMLParserTest.assertContains((String)"($1,599.99)", (String)content);
        OOXMLParserTest.assertContains((String)"2 1/2", (String)content);
    }

    @Test
    @Disabled(value="OOXML-Strict not currently supported by POI, see #57699")
    public void testExcelStrict() throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        String content = this.getText("testEXCEL.strict.xlsx", metadata, context);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Sample Spreadsheet", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Nick Burch", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Spreadsheet for testing", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
        OOXMLParserTest.assertContains((String)"Test spreadsheet", (String)content);
        OOXMLParserTest.assertContains((String)"This one is red", (String)content);
        OOXMLParserTest.assertContains((String)"cb=10", (String)content);
        OOXMLParserTest.assertNotContained((String)"10.0", (String)content);
        OOXMLParserTest.assertContains((String)"cb=sum", (String)content);
        OOXMLParserTest.assertNotContained((String)"13.0", (String)content);
        Assertions.assertEquals((Object)"false", (Object)metadata.get("protected"));
    }

    @Test
    public void testPowerPoint() throws Exception {
        String[] extensions = new String[]{"pptx", "pptm", "ppsm", "ppsx", "potm"};
        String[] mimeTypes = new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.template.macroenabled.12"};
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            String filename = "testPPT." + extension;
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            String content = this.getText(filename, metadata, context);
            Assertions.assertEquals((Object)mimeTypes[i], (Object)metadata.get("Content-Type"), (String)("Mime-type checking for " + filename));
            Assertions.assertEquals((Object)"Attachment Test", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Rajiv", (Object)metadata.get(TikaCoreProperties.CREATOR));
            if (extension.equals("thmx")) {
                Assertions.assertEquals((Object)"", (Object)content);
                continue;
            }
            Assertions.assertTrue((boolean)content.contains("Attachment Test"), (String)("Text missing for " + filename + "\n" + content));
            Assertions.assertTrue((boolean)content.contains("This is a test file data with the same content"), (String)("Text missing for " + filename + "\n" + content));
            Assertions.assertTrue((boolean)content.contains("content parsing"), (String)("Text missing for " + filename + "\n" + content));
            Assertions.assertTrue((boolean)content.contains("Different words to test against"), (String)("Text missing for " + filename + "\n" + content));
            Assertions.assertTrue((boolean)content.contains("Mystery"), (String)("Text missing for " + filename + "\n" + content));
        }
    }

    @Test
    public void testPowerPointMetadataEarly() throws Exception {
        String[] extensions = new String[]{"pptx", "pptm", "ppsm", "ppsx", "potm"};
        final String[] mimeTypes = new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.template.macroenabled.12"};
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            final String filename = "testPPT." + extension;
            final Metadata metadata = new Metadata();
            final int currentI = i++;
            BodyContentHandler handler = new BodyContentHandler(){

                public void startDocument() {
                    Assertions.assertEquals((Object)mimeTypes[currentI], (Object)metadata.get("Content-Type"), (String)("Mime-type checking for " + filename));
                    Assertions.assertEquals((Object)"Attachment Test", (Object)metadata.get(TikaCoreProperties.TITLE));
                    Assertions.assertEquals((Object)"Rajiv", (Object)metadata.get(TikaCoreProperties.CREATOR));
                }
            };
            ParseContext context = new ParseContext();
            try (InputStream input = this.getResourceAsStream("/test-documents/" + filename);){
                AUTO_DETECT_PARSER.parse(input, (ContentHandler)handler, metadata, context);
            }
        }
    }

    @Test
    public void testUnsupportedPowerPoint() throws Exception {
        String[] extensions = new String[]{"xps", "thmx"};
        String[] mimeTypes = new String[]{"application/vnd.ms-xpsdocument", "application/vnd.openxmlformats-officedocument"};
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            String filename = "testPPT." + extension;
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            this.getXML(filename, metadata);
            Assertions.assertEquals((Object)mimeTypes[i], (Object)metadata.get("Content-Type"), (String)("Mime-type checking for " + filename));
        }
    }

    @Test
    public void testWord() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testWORD.docx", metadata, new ParseContext());
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Sample Word Document", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertTrue((boolean)content.contains("Sample Word Document"));
    }

    @Test
    public void testWordFootnote() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("footnotes.docx");
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)xmlResult.metadata.get("Content-Type"));
        Assertions.assertTrue((boolean)xmlResult.xml.contains("snoska"));
    }

    @Test
    public void testWordHTML() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD.docx");
        String xml = result.xml;
        Metadata metadata = result.metadata;
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Sample Word Document", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertTrue((boolean)xml.contains("Sample Word Document"));
        Assertions.assertTrue((boolean)xml.contains("<h1 class=\"title\">"));
        Assertions.assertTrue((boolean)xml.contains("<h1>Heading Level 1</h1>"));
        Assertions.assertTrue((boolean)xml.contains("<h2>Heading Level 2</h2>"));
        Assertions.assertTrue((boolean)xml.contains("<h3><a name=\"OnLevel3\" />Heading Level 3</h3>"));
        Assertions.assertTrue((boolean)xml.contains("<b>BOLD</b>"));
        Assertions.assertTrue((boolean)xml.contains("<i>ITALIC</i>"));
        Assertions.assertTrue((boolean)xml.contains("<table>"));
        Assertions.assertTrue((boolean)xml.contains("<td>"));
        Assertions.assertTrue((boolean)xml.contains("<a href=\"http://tika.apache.org/\">Tika</a>"));
        OOXMLParserTest.assertContains((String)"<a href=\"#OnMainHeading\">The Main Heading Bookmark</a>", (String)xml);
        Assertions.assertTrue((boolean)xml.contains("<p class=\"signature\">This one"));
        result = this.getXML("testWORD_3imgs.docx");
        xml = result.xml;
        Assertions.assertTrue((boolean)xml.contains("<img src=\"embedded:image2.png\" alt=\"A description...\" />"), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<img src=\"embedded:image3.jpeg\" alt=\"A description...\" />"), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<img src=\"embedded:image4.png\" alt=\"A description...\" />"), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<p>The end!</p>"));
        xml = this.getXML((String)"testWORD_bold_character_runs.docx").xml;
        Assertions.assertTrue((boolean)xml.contains("F<b>oob</b>a<b>r</b>"), (String)("Bold text wasn't contiguous: " + xml));
        xml = this.getXML((String)"testWORD_bold_character_runs2.docx").xml;
        Assertions.assertTrue((boolean)xml.contains("F<b>oob</b>a<b>r</b>"), (String)("Bold text wasn't contiguous: " + xml));
    }

    @Test
    public void testWordPicturesInHeader() throws Exception {
        List metadataList = this.getRecursiveMetadata("headerPic.docx");
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Metadata m = (Metadata)metadataList.get(0);
        String mainContent = m.get(TikaCoreProperties.TIKA_CONTENT);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)m.get("Content-Type"));
        Assertions.assertTrue((boolean)mainContent.contains("<img"));
    }

    @Test
    @Disabled(value="need to add links in xhtml")
    public void testPicturesInVariousPlaces() throws Exception {
        List metadataList = this.getRecursiveMetadata("testWORD_embedded_pics.docx");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        for (int i = 1; i < 4; ++i) {
            OOXMLParserTest.assertContains((String)("header" + i + "_pic"), (String)content);
            OOXMLParserTest.assertContains((String)("footer" + i + "_pic"), (String)content);
        }
        OOXMLParserTest.assertContains((String)"body_pic.jpg", (String)content);
        OOXMLParserTest.assertContains((String)"sdt_pic.jpg", (String)content);
        OOXMLParserTest.assertContains((String)"deeply_embedded_pic", (String)content);
        OOXMLParserTest.assertContains((String)"deleted_pic", (String)content);
        OOXMLParserTest.assertContains((String)"footnotes_pic", (String)content);
        OOXMLParserTest.assertContains((String)"comments_pic", (String)content);
        OOXMLParserTest.assertContains((String)"endnotes_pic", (String)content);
        OOXMLParserTest.assertContainsCount((String)"<img src=", (String)content, (int)14);
    }

    @Test
    public void testProtectedExcelSheets() throws Exception {
        Metadata metadata = this.getXML((String)"protectedSheets.xlsx").metadata;
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("protected"));
    }

    @Test
    public void testProtectedExcelFile() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("protectedFile.xlsx");
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)xmlResult.metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"true", (Object)xmlResult.metadata.get("protected"));
        OOXMLParserTest.assertContains((String)"Office", (String)xmlResult.xml);
    }

    @Test
    public void testNullHeaders() throws Exception {
        Assertions.assertFalse((boolean)this.getXML((String)"NullHeader.docx").xml.isEmpty(), (String)"Should have found some text");
    }

    @Test
    public void testTextDecoration() throws Exception {
        String xml = this.getXML((String)"testWORD_various.docx").xml;
        OOXMLParserTest.assertContains((String)"<b>Bold</b>", (String)xml);
        OOXMLParserTest.assertContains((String)"<i>italic</i>", (String)xml);
        OOXMLParserTest.assertContains((String)"<u>underline</u>", (String)xml);
        OOXMLParserTest.assertContains((String)"<s>strikethrough</s>", (String)xml);
    }

    @Test
    public void testTextDecorationNested() throws Exception {
        String xml = this.getXML((String)"testWORD_various.docx").xml;
        OOXMLParserTest.assertContains((String)"<i>ita<s>li</s>c</i>", (String)xml);
        OOXMLParserTest.assertContains((String)"<i>ita<s>l<u>i</u></s>c</i>", (String)xml);
        OOXMLParserTest.assertContains((String)"<i><u>unde<s>r</s>line</u></i>", (String)xml);
        String txt = this.getText("testWORD_various.docx");
        OOXMLParserTest.assertContainsCount((String)"italic", (String)txt, (int)3);
        OOXMLParserTest.assertNotContained((String)"ita ", (String)txt);
        OOXMLParserTest.assertContainsCount((String)"underline", (String)txt, (int)2);
        OOXMLParserTest.assertNotContained((String)"unde ", (String)txt);
    }

    @Test
    public void testVarious() throws Exception {
        int row;
        Metadata metadata = new Metadata();
        String content = this.getText("testWORD_various.docx", metadata);
        OOXMLParserTest.assertContains((String)"Footnote appears here", (String)content);
        OOXMLParserTest.assertContains((String)"This is a footnote.", (String)content);
        OOXMLParserTest.assertContains((String)"This is the header text.", (String)content);
        OOXMLParserTest.assertContains((String)"This is the footer text.", (String)content);
        OOXMLParserTest.assertContains((String)"Here is a text box", (String)content);
        OOXMLParserTest.assertContains((String)"Bold", (String)content);
        OOXMLParserTest.assertContains((String)"italic", (String)content);
        OOXMLParserTest.assertContains((String)"underline", (String)content);
        OOXMLParserTest.assertContains((String)"superscript", (String)content);
        OOXMLParserTest.assertContains((String)"subscript", (String)content);
        OOXMLParserTest.assertContains((String)"Here is a citation:", (String)content);
        OOXMLParserTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)content);
        OOXMLParserTest.assertContains((String)"(Kramer)", (String)content);
        OOXMLParserTest.assertContains((String)"Row 1 Col 1 Row 1 Col 2 Row 1 Col 3 Row 2 Col 1 Row 2 Col 2 Row 2 Col 3", (String)content.replaceAll("\\s+", " "));
        OOXMLParserTest.assertContains((String)"Row 1 column 1 Row 2 column 1 Row 1 column 2 Row 2 column 2", (String)content.replaceAll("\\s+", " "));
        OOXMLParserTest.assertContains((String)"This is a hyperlink", (String)content);
        OOXMLParserTest.assertContains((String)"Here is a list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            OOXMLParserTest.assertContains((String)("Bullet " + row), (String)content);
        }
        OOXMLParserTest.assertContains((String)"Here is a numbered list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            OOXMLParserTest.assertContains((String)("Number bullet " + row), (String)content);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                OOXMLParserTest.assertContains((String)("Row " + row + " Col " + col), (String)content);
            }
        }
        OOXMLParserTest.assertContains((String)"Keyword1 Keyword2", (String)content);
        Assertions.assertEquals((Object)"Keyword1 Keyword2", (Object)metadata.get(Office.KEYWORDS));
        OOXMLParserTest.assertContains((Object)"Keyword1 Keyword2", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        OOXMLParserTest.assertContains((String)"Subject is here", (String)content);
        OOXMLParserTest.assertContains((Object)"Subject is here", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        Assertions.assertEquals((Object)"Subject is here", (Object)metadata.get(OfficeOpenXMLCore.SUBJECT));
        OOXMLParserTest.assertContains((String)"Suddenly some Japanese text:", (String)content);
        OOXMLParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)content);
        OOXMLParserTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)content);
        OOXMLParserTest.assertContains((String)"And then some Gothic text:", (String)content);
        OOXMLParserTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)content);
    }

    @Test
    public void testDOCXHeaderFooterNotExtraction() throws Exception {
        ParseContext parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeHeadersAndFooters(false);
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testWORD_various.docx", (ParseContext)parseContext).xml;
        OOXMLParserTest.assertNotContained((String)"This is the header text.", (String)xml);
        OOXMLParserTest.assertNotContained((String)"This is the footer text.", (String)xml);
    }

    @Test
    public void testVariousPPTX() throws Exception {
        int row;
        Metadata metadata = new Metadata();
        String xml = this.getXML((String)"testPPT_various.pptx", (Metadata)metadata).xml;
        OOXMLParserTest.assertContains((String)"<p>Footnote appears here", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>[1] This is a footnote.", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>This is the header text.</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>This is the footer text.</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>Here is a text box</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>Bold", (String)xml);
        OOXMLParserTest.assertContains((String)"italic underline superscript subscript", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>Here is a citation:", (String)xml);
        OOXMLParserTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)xml);
        OOXMLParserTest.assertContains((String)"(Kramer)", (String)xml);
        OOXMLParserTest.assertContains((String)"<table><tr>\t<td>Row 1 Col 1</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>Row 2 Col 2</td>\t<td>Row 2 Col 3</td></tr>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>Row 1 column 1</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>Row 2 column 2</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p><a href=\"http://tika.apache.org/\">This is a hyperlink</a>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>Here is a list:", (String)xml);
        for (row = 1; row <= 3; ++row) {
            OOXMLParserTest.assertContains((String)("<p>Bullet " + row), (String)xml);
        }
        OOXMLParserTest.assertContains((String)"Here is a numbered list:", (String)xml);
        for (row = 1; row <= 3; ++row) {
            OOXMLParserTest.assertContains((String)("<p>Number bullet " + row), (String)xml);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                OOXMLParserTest.assertContains((String)("Row " + row + " Col " + col), (String)xml);
            }
        }
        OOXMLParserTest.assertContains((String)"Keyword1 Keyword2", (String)xml);
        Assertions.assertEquals((Object)"Keyword1 Keyword2", (Object)metadata.get(Office.KEYWORDS));
        OOXMLParserTest.assertContains((String)"Subject is here", (String)xml);
        Assertions.assertEquals((Object)"Subject is here", (Object)metadata.get(OfficeOpenXMLCore.SUBJECT));
        OOXMLParserTest.assertContains((Object)"Keyword1 Keyword2", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        OOXMLParserTest.assertContains((Object)"Subject is here", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        OOXMLParserTest.assertContains((String)"Suddenly some Japanese text:", (String)xml);
        OOXMLParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)xml);
        OOXMLParserTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)xml);
        OOXMLParserTest.assertContains((String)"And then some Gothic text:", (String)xml);
        OOXMLParserTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)xml);
    }

    @Test
    public void testSkipHeaderFooter() throws Exception {
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeHeadersAndFooters(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testPPT_various.pptx", (ParseContext)context).xml;
        OOXMLParserTest.assertNotContained((String)"This is the header text", (String)xml);
    }

    @Test
    public void testCommentPPTX() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPPT_comment.pptx");
        OOXMLParserTest.assertContains((String)"<p class=\"slide-comment\"><b>Allison, Timothy B. (ATB)", (String)r.xml);
    }

    @Test
    public void testMasterFooter() throws Exception {
        String content = this.getText("testPPT_masterFooter.pptx");
        OOXMLParserTest.assertContains((String)"Master footer is here", (String)content);
    }

    @Test
    @Disabled(value="can't tell why this isn't working")
    public void testTurningOffMasterContent() throws Exception {
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testPPT_masterFooter.pptx", (ParseContext)context).xml;
        OOXMLParserTest.assertNotContained((String)"Master footer", (String)xml);
    }

    @Test
    public void testMasterText() throws Exception {
        String content = this.getText("testPPT_masterText.pptx");
        OOXMLParserTest.assertContains((String)"Text that I added to the master slide", (String)content);
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        content = this.getXML((String)"testPPT_masterText.pptx", (ParseContext)context).xml;
        OOXMLParserTest.assertNotContained((String)"Text that I added", (String)content);
    }

    @Test
    public void testMasterText2() throws Exception {
        String content = this.getText("testPPT_masterText2.pptx");
        OOXMLParserTest.assertContains((String)"Text that I added to the master slide", (String)content);
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        content = this.getXML((String)"testPPT_masterText2.pptx", (ParseContext)context).xml;
        OOXMLParserTest.assertNotContained((String)"Text that I added", (String)content);
    }

    @Test
    public void testWordArt() throws Exception {
        OOXMLParserTest.assertContains((String)"Here is some red word Art", (String)this.getText("testWordArt.pptx"));
    }

    @Test
    public void testExcelCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        this.getXML("testEXCEL_custom_props.xlsx", metadata, context);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2006-09-12T15:06:44Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2011-08-22T14:24:38Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"Microsoft Excel", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T22:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assertions.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    public void testWordCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        try (InputStream input = this.getResourceAsStream("/test-documents/testWORD_custom_props.docx");){
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OOXMLParser().parse(input, (ContentHandler)handler, metadata, context);
        }
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"EJ04325S", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Etienne Jouvin", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2011-07-29T16:52:00Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2012-01-03T22:14:00Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(Office.PAGE_COUNT));
        Assertions.assertEquals((Object)"2", (Object)metadata.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"My Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"My Keyword", (Object)metadata.get(Office.KEYWORDS));
        OOXMLParserTest.assertContains((Object)"My Keyword", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        Assertions.assertEquals((Object)"Normal.dotm", (Object)metadata.get(OfficeOpenXMLExtended.TEMPLATE));
        Assertions.assertEquals((Object)"My subject", (Object)metadata.get(OfficeOpenXMLCore.SUBJECT));
        Assertions.assertEquals((Object)"EDF-DIT", (Object)metadata.get(TikaCoreProperties.PUBLISHER));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T23:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assertions.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    public void testPowerPointCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        try (InputStream input = this.getResourceAsStream("/test-documents/testPPT_custom_props.pptx");){
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OOXMLParser().parse(input, (ContentHandler)handler, metadata, context);
        }
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"JOUVIN ETIENNE", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"EJ04325S", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2011-08-22T13:30:53Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2011-08-22T13:32:49Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(Office.SLIDE_COUNT));
        Assertions.assertEquals((Object)"3", (Object)metadata.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"Test extraction properties pptx", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T22:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assertions.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    public void testEmbeddedPDF() throws Exception {
        Metadata metadata = new Metadata();
        StringWriter sw = new StringWriter();
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("indent", "no");
        handler.setResult(new StreamResult(sw));
        try (InputStream input = this.getResourceAsStream("/test-documents/testWORD_embedded_pdf.docx");){
            new OOXMLParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
        }
        String xml = sw.toString();
        int i = xml.indexOf("Here is the pdf file:");
        int j = xml.indexOf("<div class=\"embedded\" id=\"rId5\"/>");
        int k = xml.indexOf("Bye Bye");
        int l = xml.indexOf("<div class=\"embedded\" id=\"rId6\"/>");
        int m = xml.indexOf("Bye for real.");
        Assertions.assertTrue((i != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((j != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((k != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((l != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((m != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((i < j ? 1 : 0) != 0);
        Assertions.assertTrue((j < k ? 1 : 0) != 0);
        Assertions.assertTrue((k < l ? 1 : 0) != 0);
        Assertions.assertTrue((l < m ? 1 : 0) != 0);
    }

    @Test
    public void testEmbeddedZipInPPTX() throws Exception {
        String xml = this.getXML((String)"test_embedded_zip.pptx").xml;
        int h = xml.indexOf("<div class=\"embedded\" id=\"slide1_rId3\" />");
        int i = xml.indexOf("Send me a note");
        int j = xml.indexOf("<div class=\"embedded\" id=\"slide2_rId4\" />");
        int k = xml.indexOf("<p>No title</p>");
        Assertions.assertTrue((h != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((i != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((j != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((k != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((h < i ? 1 : 0) != 0);
        Assertions.assertTrue((i < j ? 1 : 0) != 0);
        Assertions.assertTrue((j < k ? 1 : 0) != 0);
    }

    @Test
    public void testWordNullStyle() throws Exception {
        String xml = this.getXML((String)"testWORD_null_style.docx").xml;
        OOXMLParserTest.assertContains((String)"Test av styrt dokument", (String)xml);
    }

    @Test
    public void testNoFormat() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testWORD_no_format.docx");){
            new OOXMLParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        OOXMLParserTest.assertContains((String)"This is a piece of text that causes an exception", (String)content);
    }

    @Test
    public void testTextInsideTextBox() throws Exception {
        String xml = this.getXML((String)"testWORD_text_box.docx").xml;
        OOXMLParserTest.assertContains((String)"This text is directly in the body of the document.", (String)xml);
        OOXMLParserTest.assertContains((String)"This text is inside of a text box in the body of the document.", (String)xml);
        OOXMLParserTest.assertContains((String)"This text is inside of a text box in the header of the document.", (String)xml);
        OOXMLParserTest.assertContains((String)"This text is inside of a text box in the footer of the document.", (String)xml);
    }

    @Test
    public void testSDTInTextBox() throws Exception {
        String xml = this.getXML((String)"testWORD_sdtInTextBox.docx").xml;
        OOXMLParserTest.assertContains((String)"rich-text-content-control_inside-text-box", (String)xml);
        OOXMLParserTest.assertContainsCount((String)"inside-text", (String)xml, (int)1);
    }

    @Test
    public void testTurningOffTextBoxExtraction() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeShapeBasedContent(false);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testWORD_text_box.docx", (ParseContext)pc).xml;
        OOXMLParserTest.assertContains((String)"This text is directly in the body of the document.", (String)xml);
        OOXMLParserTest.assertNotContained((String)"This text is inside of a text box in the body of the document.", (String)xml);
        OOXMLParserTest.assertNotContained((String)"This text is inside of a text box in the header of the document.", (String)xml);
        OOXMLParserTest.assertNotContained((String)"This text is inside of a text box in the footer of the document.", (String)xml);
    }

    @Test
    public void testEmbeddedPPTXTwoSlides() throws Exception {
        String xml = this.getXML((String)"testPPT_embedded_two_slides.pptx").xml;
        OOXMLParserTest.assertContains((String)"<div class=\"embedded\" id=\"slide1_rId7\" />", (String)xml);
        OOXMLParserTest.assertContains((String)"<div class=\"embedded\" id=\"slide2_rId7\" />", (String)xml);
    }

    @Test
    public void testMissingText() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("testWORD_missing_text.docx");
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)xmlResult.metadata.get("Content-Type"));
        OOXMLParserTest.assertContains((String)"BigCompany", (String)xmlResult.xml);
        OOXMLParserTest.assertContains((String)"Seasoned", (String)xmlResult.xml);
        OOXMLParserTest.assertContains((String)"Rich_text_in_cell", (String)xmlResult.xml);
    }

    @Test
    public void testExcelTextBox() throws Exception {
        TikaTest.XMLResult r = this.getXML("testEXCEL_textbox.xlsx");
        OOXMLParserTest.assertContains((String)"some autoshape", (String)r.xml);
    }

    @Test
    public void testTurningOffTextBoxExtractionExcel() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeShapeBasedContent(false);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testEXCEL_textbox.xlsx", (ParseContext)pc).xml;
        OOXMLParserTest.assertNotContained((String)"autoshape", (String)xml);
    }

    @Test
    public void testWordMissingOOXMLBeans() throws Exception {
        String[] fileNames = new String[]{"testWORD_missing_ooxml_bean1.docx"};
        PrintStream origErr = System.err;
        for (String fileName : fileNames) {
            ByteArrayOutputStream errContent = new ByteArrayOutputStream();
            System.setErr(new PrintStream((OutputStream)errContent, true, StandardCharsets.UTF_8.name()));
            this.getXML(fileName);
            System.setErr(origErr);
            String err = errContent.toString(StandardCharsets.UTF_8.name());
            Assertions.assertTrue((err.length() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPPTXAutodate() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPPT_autodate.pptx");
        OOXMLParserTest.assertContains((String)"<p>Now</p>\n<p>2011-12-19 10:20:04 AM</p>\n", (String)result.xml);
    }

    @Test
    public void testDOCXThumbnail() throws Exception {
        String xml = this.getXML((String)"testDOCX_Thumbnail.docx").xml;
        int a = xml.indexOf("This file contains a thumbnail");
        int b = xml.indexOf("<div class=\"embedded\" id=\"/docProps/thumbnail.emf\" />");
        Assertions.assertTrue((a != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((b != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((a < b ? 1 : 0) != 0);
    }

    @Test
    public void testXLSXThumbnail() throws Exception {
        String xml = this.getXML((String)"testXLSX_Thumbnail.xlsx").xml;
        int a = xml.indexOf("This file contains an embedded thumbnail by default");
        int b = xml.indexOf("<div class=\"embedded\" id=\"/docProps/thumbnail.wmf\" />");
        Assertions.assertTrue((a != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((b != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((a < b ? 1 : 0) != 0);
    }

    @Test
    public void testPPTXThumbnail() throws Exception {
        String xml = this.getXML((String)"testPPTX_Thumbnail.pptx").xml;
        int a = xml.indexOf("<body><div class=\"slide-content\"><p>This file contains an embedded thumbnail");
        int b = xml.indexOf("<div class=\"embedded\" id=\"/docProps/thumbnail.jpeg\" />");
        Assertions.assertTrue((a != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((b != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((a < b ? 1 : 0) != 0);
    }

    @Test
    public void testEncrypted() throws Exception {
        HashMap<String, String> tests = new HashMap<String, String>();
        tests.put("testWORD_protected_passtika.docx", "This is an encrypted Word 2007 File");
        tests.put("testPPT_protected_passtika.pptx", "This is an encrypted PowerPoint 2007 slide.");
        tests.put("testEXCEL_protected_passtika.xlsx", "This is an Encrypted Excel spreadsheet.");
        tests.put("testEXCEL_protected_passtika_2.xlsx", "This is an Encrypted Excel spreadsheet with a ChunkedCipherInputStream.");
        PasswordProvider passwordProvider = new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "tika";
            }
        };
        ParseContext passwordContext = new ParseContext();
        passwordContext.set(PasswordProvider.class, (Object)passwordProvider);
        for (Map.Entry e : tests.entrySet()) {
            TikaTest.XMLResult xmlResult = this.getXML((String)e.getKey(), passwordContext);
            OOXMLParserTest.assertContains((String)((String)e.getValue()), (String)xmlResult.xml);
        }
        ParseContext context = new ParseContext();
        for (Map.Entry e : tests.entrySet()) {
            boolean exc = false;
            try {
                this.getXML((String)e.getKey());
            }
            catch (EncryptedDocumentException ex) {
                exc = true;
            }
            Assertions.assertTrue((boolean)exc);
        }
    }

    @Test
    public void testDOCXParagraphNumbering() throws Exception {
        String xml = this.getXML((String)"testWORD_numbered_list.docx").xml;
        OOXMLParserTest.assertContains((String)"1) This", (String)xml);
        OOXMLParserTest.assertContains((String)"a) Is", (String)xml);
        OOXMLParserTest.assertContains((String)"i) A multi", (String)xml);
        OOXMLParserTest.assertContains((String)"ii) Level", (String)xml);
        OOXMLParserTest.assertContains((String)"1. Within cell 1", (String)xml);
        OOXMLParserTest.assertContains((String)"b. Cell b", (String)xml);
        OOXMLParserTest.assertContains((String)"iii) List", (String)xml);
        OOXMLParserTest.assertContains((String)"2) foo", (String)xml);
        OOXMLParserTest.assertContains((String)"ii) baz", (String)xml);
        OOXMLParserTest.assertContains((String)"ii) foo", (String)xml);
        OOXMLParserTest.assertContains((String)"II. bar", (String)xml);
        OOXMLParserTest.assertContains((String)"6. six", (String)xml);
        OOXMLParserTest.assertContains((String)"7. seven", (String)xml);
        OOXMLParserTest.assertContains((String)"a. seven a", (String)xml);
        OOXMLParserTest.assertContains((String)"e. seven e", (String)xml);
        OOXMLParserTest.assertContains((String)"2. A ii 2", (String)xml);
        OOXMLParserTest.assertContains((String)"3. page break list 3", (String)xml);
        OOXMLParserTest.assertContains((String)"Some-1-CrazyFormat Greek numbering with crazy format - alpha", (String)xml);
        OOXMLParserTest.assertContains((String)"1.1.1. 1.1.1", (String)xml);
        OOXMLParserTest.assertContains((String)"1.1. 1.2-&gt;1.1  //set the value", (String)xml);
    }

    @Test
    public void testDOCXOverrideParagraphNumbering() throws Exception {
        String xml = this.getXML((String)"testWORD_override_list_numbering.docx").xml;
        OOXMLParserTest.assertContains((String)"<p>1.1.1.1...1 1.1.1.1...1</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"1st.2.3someText 1st.2.3someText", (String)xml);
        OOXMLParserTest.assertContains((String)"1st.2.2someOtherText.1 1st.2.2someOtherText.1", (String)xml);
        OOXMLParserTest.assertContains((String)"5th 5th", (String)xml);
        OOXMLParserTest.assertContains((String)"1.a.I 1.a.I", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>1.b.III 1.b.III</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"2.a.I 2.a.I", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>2.b 2.b</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"(1)) (1))", (String)xml);
        OOXMLParserTest.assertContains((String)"2.17 2.17", (String)xml);
        OOXMLParserTest.assertContains((String)"2.18.2.1 2.18.2.1", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>2 2</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>1 1</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>A A</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>B B</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>C C</p>", (String)xml);
        OOXMLParserTest.assertContains((String)"<p>4 4</p>", (String)xml);
        OOXMLParserTest.assertContains((String)">00 00", (String)xml);
        OOXMLParserTest.assertContains((String)">01 01", (String)xml);
        OOXMLParserTest.assertContains((String)">01. 01.", (String)xml);
        OOXMLParserTest.assertContains((String)">01..1 01..1", (String)xml);
        OOXMLParserTest.assertContains((String)">02 02", (String)xml);
    }

    @Test
    public void testExcelHeaderAndFooterExtraction() throws Exception {
        TikaTest.XMLResult xml = this.getXML("testEXCEL_headers_footers.xlsx");
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)xml.metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Internal spreadsheet", (Object)xml.metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Aeham Abushwashi", (Object)xml.metadata.get(TikaCoreProperties.CREATOR));
        String content = xml.xml;
        OOXMLParserTest.assertContains((String)"John Smith1", (String)content);
        OOXMLParserTest.assertContains((String)"John Smith50", (String)content);
        OOXMLParserTest.assertContains((String)"1 Corporate HQ", (String)content);
        OOXMLParserTest.assertContains((String)"Header - Corporate Spreadsheet", (String)content);
        OOXMLParserTest.assertContains((String)"Header - For Internal Use Only", (String)content);
        OOXMLParserTest.assertContains((String)"Header - Author: John Smith", (String)content);
        OOXMLParserTest.assertContains((String)"Footer - Corporate Spreadsheet", (String)content);
        OOXMLParserTest.assertContains((String)"Footer - For Internal Use Only", (String)content);
        OOXMLParserTest.assertContains((String)"Footer - Author: John Smith", (String)content);
    }

    @Test
    public void testExcelHeaderAndFooterNotExtraction() throws Exception {
        ParseContext parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeHeadersAndFooters(false);
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String content = this.getXML((String)"testEXCEL_headers_footers.xlsx", (ParseContext)parseContext).xml;
        OOXMLParserTest.assertNotContained((String)"Header - Corporate Spreadsheet", (String)content);
        OOXMLParserTest.assertNotContained((String)"Header - For Internal Use Only", (String)content);
        OOXMLParserTest.assertNotContained((String)"Header - Author: John Smith", (String)content);
        OOXMLParserTest.assertNotContained((String)"Footer - Corporate Spreadsheet", (String)content);
        OOXMLParserTest.assertNotContained((String)"Footer - For Internal Use Only", (String)content);
        OOXMLParserTest.assertNotContained((String)"Footer - Author: John Smith", (String)content);
    }

    @Test
    public void testMultiAuthorsManagers() throws Exception {
        TikaTest.XMLResult r = this.getXML("testWORD_multi_authors.docx");
        String[] authors = r.metadata.getValues(TikaCoreProperties.CREATOR);
        Assertions.assertEquals((int)3, (int)authors.length);
        Assertions.assertEquals((Object)"author2", (Object)authors[1]);
        String[] managers = r.metadata.getValues(OfficeOpenXMLExtended.MANAGER);
        Assertions.assertEquals((int)2, (int)managers.length);
        Assertions.assertEquals((Object)"manager1", (Object)managers[0]);
        Assertions.assertEquals((Object)"manager2", (Object)managers[1]);
    }

    @Test
    public void testHyperlinksInXLSX() throws Exception {
        String xml = this.getXML((String)"testEXCEL_hyperlinks.xlsx").xml;
        OOXMLParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\">", (String)xml);
        OOXMLParserTest.assertContains((String)"<a href=\"mailto:user@tika.apache.org?subject=help\">", (String)xml);
        OOXMLParserTest.assertContains((String)"<a href=\"linked_file.txt.htm\">", (String)xml);
        OOXMLParserTest.assertContains((String)"<a href=\"http://tika.apache.org/1.12/gettingstarted.html\">", (String)xml);
    }

    @Test
    public void testOrigSourcePath() throws Exception {
        Metadata embed1_zip_metadata = (Metadata)this.getRecursiveMetadata("test_recursive_embedded.docx").get(2);
        OOXMLParserTest.assertContains((Object)"C:\\Users\\tallison\\AppData\\Local\\Temp\\embed1.zip", Arrays.asList(embed1_zip_metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)));
        OOXMLParserTest.assertContains((Object)"C:\\Users\\tallison\\Desktop\\tmp\\New folder (2)\\embed1.zip", Arrays.asList(embed1_zip_metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)));
    }

    @Test
    public void testBigIntegersWGeneralFormat() throws Exception {
        String xml = this.getXML((String)"testEXCEL_big_numbers.xlsx").xml;
        OOXMLParserTest.assertContains((String)"123456789012345", (String)xml);
        OOXMLParserTest.assertContains((String)"123456789012346", (String)xml);
        Locale locale = LocaleUtil.getUserLocale();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        OOXMLParserTest.assertContains((String)("1" + symbols.getDecimalSeparator() + "23456789012345E+15</td>\t<td>1" + symbols.getDecimalSeparator() + "23456789012345E+15"), (String)xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigIntegersWGeneralFormatWLocaleIT() throws Exception {
        LocaleUtil.setUserLocale((Locale)Locale.ITALIAN);
        try {
            String xml = this.getXML((String)"testEXCEL_big_numbers.xlsx").xml;
            OOXMLParserTest.assertContains((String)"123456789012345", (String)xml);
            OOXMLParserTest.assertContains((String)"123456789012346", (String)xml);
            Locale locale = LocaleUtil.getUserLocale();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            OOXMLParserTest.assertContains((String)("1" + symbols.getDecimalSeparator() + "23456789012345E+15</td>\t<td>1" + symbols.getDecimalSeparator() + "23456789012345E+15"), (String)xml);
        }
        finally {
            LocaleUtil.setUserLocale((Locale)USER_LOCALE);
        }
    }

    @Test
    public void testBoldHyperlink() throws Exception {
        String xml = this.getXML((String)"testWORD_boldHyperlink.docx").xml;
        xml = xml.replaceAll("\\s+", " ");
        OOXMLParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\">hyper <b>link</b></a>", (String)xml);
        OOXMLParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\"><b>hyper</b> link</a>; bold", (String)xml);
    }

    @Test
    public void testLongForIntExceptionInSummaryDetails() throws Exception {
        OOXMLParserTest.assertContains((String)"bold", (String)this.getXML((String)"testWORD_totalTimeOutOfRange.docx").xml);
    }

    @Test
    public void testMacrosInDocm() throws Exception {
        for (Metadata metadata : this.getRecursiveMetadata("testWORD_macros.docm")) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assertions.fail((String)"Shouldn't have extracted macros as default");
        }
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Embolden()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Italicize()");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        OOXMLParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testWORD_macros.docm", context));
        try (InputStream is = this.getResourceAsStream("tika-config-dom-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            OOXMLParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testWORD_macros.docm", (Parser)parser));
        }
    }

    @Test
    public void testMacrosInPptm() throws Exception {
        for (Metadata metadata : this.getRecursiveMetadata("testPPT_macros.pptm")) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assertions.fail((String)"Shouldn't have extracted macros as default");
        }
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Embolden()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Italicize()");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        OOXMLParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testPPT_macros.pptm", context));
        try (InputStream is = this.getResourceAsStream("tika-config-dom-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            OOXMLParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testPPT_macros.pptm", (Parser)parser));
        }
    }

    @Test
    public void testMacroinXlsm() throws Exception {
        for (Metadata metadata : this.getRecursiveMetadata("testEXCEL_macro.xlsm")) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assertions.fail((String)"Shouldn't have extracted macros as default");
        }
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Dirty()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "dirty dirt dirt");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        OOXMLParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testEXCEL_macro.xlsm", context));
        try (InputStream is = this.getResourceAsStream("tika-config-dom-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            OOXMLParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testEXCEL_macro.xlsm", (Parser)parser));
        }
    }

    public void testBatch() throws Exception {
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setUseSAXDocxExtractor(true);
        long started = System.currentTimeMillis();
        int ex = 0;
        for (int i = 0; i < 100; ++i) {
            for (File f : this.getResourceAsFile("/test-documents").listFiles()) {
                if (!f.getName().endsWith(".docx")) continue;
                try (TikaInputStream is = TikaInputStream.get((File)f);){
                    ParseContext parseContext = new ParseContext();
                    parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
                    parseContext.set(Parser.class, (Object)new EmptyParser());
                    TikaTest.XMLResult xMLResult = this.getXML((InputStream)is, AUTO_DETECT_PARSER, new Metadata(), parseContext);
                }
                catch (Exception e) {
                    ++ex;
                }
            }
        }
        System.out.println("elapsed: " + (System.currentTimeMillis() - started) + " with " + ex + " exceptions");
    }

    @Test
    public void testInitializationViaConfig() throws Exception {
        try (InputStream is = this.getResourceAsStream("/org/apache/tika/parser/microsoft/tika-config-sax-docx.xml");){
            Assertions.assertNotNull((Object)is);
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            TikaTest.XMLResult xml = this.getXML("testWORD_2006ml.docx", (Parser)p, new Metadata());
            OOXMLParserTest.assertContains((String)"engaging title", (String)xml.xml);
        }
    }

    @Test
    public void testExcelXLSB() throws Exception {
        MediaType type;
        DefaultDetector detector = new DefaultDetector();
        Metadata m = new Metadata();
        m.add("resourceName", "excel.xlsb");
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL.xlsb");){
            type = detector.detect(input, m);
            Assertions.assertEquals((Object)"application/vnd.ms-excel.sheet.binary.macroenabled.12", (Object)type.toString());
        }
        Assertions.assertEquals((Object)false, (Object)new OfficeParser().getSupportedTypes(new ParseContext()).contains(type));
        Assertions.assertTrue((boolean)new OOXMLParser().getSupportedTypes(new ParseContext()).contains(type));
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        String content = this.getText("testEXCEL.xlsb", new Metadata(), context);
        OOXMLParserTest.assertContains((String)"This is an example spreadsheet", (String)content);
    }

    @Test
    public void testXLSBVarious() throws Exception {
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        List metadataList = this.getRecursiveMetadata("testEXCEL_various.xlsb", parseContext);
        Assertions.assertEquals((int)4, (int)metadataList.size());
        String xml = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        OOXMLParserTest.assertContains((String)"<td>13</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>13.1211231321</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>$   3.03</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>20%</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>13.12</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>123456789012345</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>1.23456789012345E+15</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"test comment2", (String)xml);
        OOXMLParserTest.assertContains((String)"comment4 (end of row)", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>1/4</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>3/9/17</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>4</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>2</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>   46/1963</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"<td>  3/128</td>", (String)xml);
        OOXMLParserTest.assertContains((String)"test textbox", (String)xml);
        OOXMLParserTest.assertContains((String)"test WordArt", (String)xml);
        OOXMLParserTest.assertContains((String)"<a href=\"http://lucene.apache.org/\">http://lucene.apache.org/</a>", (String)xml);
        OOXMLParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\">http://tika.apache.org/</a>", (String)xml);
        OOXMLParserTest.assertContains((String)"OddLeftHeader OddCenterHeader OddRightHeader", (String)xml);
        OOXMLParserTest.assertContains((String)"EvenLeftHeader EvenCenterHeader EvenRightHeader", (String)xml);
        OOXMLParserTest.assertContains((String)"FirstPageLeftHeader FirstPageCenterHeader FirstPageRightHeader", (String)xml);
        OOXMLParserTest.assertContains((String)"OddLeftFooter OddCenterFooter OddRightFooter", (String)xml);
        OOXMLParserTest.assertContains((String)"EvenLeftFooter EvenCenterFooter EvenRightFooter", (String)xml);
        OOXMLParserTest.assertContains((String)"FirstPageLeftFooter FirstPageCenterFooter FirstPageRightFooter", (String)xml);
    }

    @Test
    public void testXLSBNoHeaderFooters() throws Exception {
        ParseContext parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeHeadersAndFooters(false);
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testEXCEL_various.xlsb", (ParseContext)parseContext).xml;
        OOXMLParserTest.assertNotContained((String)"OddLeftHeader OddCenterHeader OddRightHeader", (String)xml);
        OOXMLParserTest.assertNotContained((String)"EvenLeftHeader EvenCenterHeader EvenRightHeader", (String)xml);
        OOXMLParserTest.assertNotContained((String)"FirstPageLeftHeader FirstPageCenterHeader FirstPageRightHeader", (String)xml);
        OOXMLParserTest.assertNotContained((String)"OddLeftFooter OddCenterFooter OddRightFooter", (String)xml);
        OOXMLParserTest.assertNotContained((String)"EvenLeftFooter EvenCenterFooter EvenRightFooter", (String)xml);
        OOXMLParserTest.assertNotContained((String)"FirstPageLeftFooter FirstPageCenterFooter FirstPageRightFooter", (String)xml);
    }

    @Test
    public void testPOI61034() throws Exception {
        TikaTest.XMLResult r = this.getXML("testEXCEL_poi-61034.xlsx");
        Matcher m = Pattern.compile("<h1>(Sheet\\d+)</h1>").matcher(r.xml);
        HashSet<String> seen = new HashSet<String>();
        while (m.find()) {
            String sheetName = m.group(1);
            if (seen.contains(sheetName)) {
                Assertions.fail((String)("Should only see each sheet once: " + sheetName));
            }
            seen.add(sheetName);
        }
    }

    @Test
    public void testXLSBOriginalPath() throws Exception {
        Assertions.assertEquals((Object)"C:\\Users\\tallison\\Desktop\\working\\TIKA-1945\\", (Object)this.getXML((String)"testEXCEL_diagramData.xlsb").metadata.get(TikaCoreProperties.ORIGINAL_RESOURCE_NAME));
    }

    @Test
    public void testXLSXOriginalPath() throws Exception {
        Assertions.assertEquals((Object)"C:\\Users\\tallison\\Desktop\\working\\TIKA-1945\\", (Object)this.getXML((String)"testEXCEL_diagramData.xlsx").metadata.get(TikaCoreProperties.ORIGINAL_RESOURCE_NAME));
    }

    @Test
    public void testXLSBDiagramData() throws Exception {
        OOXMLParserTest.assertContains((String)"SmartArt", (String)this.getXML((String)"testEXCEL_diagramData.xlsb").xml);
    }

    @Test
    public void testXLSXDiagramData() throws Exception {
        OOXMLParserTest.assertContains((String)"SmartArt", (String)this.getXML((String)"testEXCEL_diagramData.xlsx").xml);
    }

    @Test
    public void testDOCXDiagramData() throws Exception {
        OOXMLParserTest.assertContains((String)"From here", (String)this.getXML((String)"testWORD_diagramData.docx").xml);
    }

    @Test
    public void testPPTXDiagramData() throws Exception {
        OOXMLParserTest.assertContains((String)"President", (String)this.getXML((String)"testPPT_diagramData.pptx").xml);
    }

    @Test
    public void testXLSXChartData() throws Exception {
        String xml = this.getXML((String)"testEXCEL_charts.xlsx").xml;
        OOXMLParserTest.assertContains((String)"peach", (String)xml);
        OOXMLParserTest.assertContains((String)"March\tApril", (String)xml);
        OOXMLParserTest.assertNotContained((String)"chartSpace", (String)xml);
    }

    @Test
    public void testXLSBChartData() throws Exception {
        String xml = this.getXML((String)"testEXCEL_charts.xlsb").xml;
        OOXMLParserTest.assertContains((String)"peach", (String)xml);
        OOXMLParserTest.assertContains((String)"March\tApril", (String)xml);
        OOXMLParserTest.assertNotContained((String)"chartSpace", (String)xml);
    }

    @Test
    public void testDOCXChartData() throws Exception {
        String xml = this.getXML((String)"testWORD_charts.docx").xml;
        OOXMLParserTest.assertContains((String)"peach", (String)xml);
        OOXMLParserTest.assertContains((String)"March\tApril", (String)xml);
        OOXMLParserTest.assertNotContained((String)"chartSpace", (String)xml);
    }

    @Test
    public void testPPTXChartData() throws Exception {
        String xml = this.getXML((String)"testPPT_charts.pptx").xml;
        OOXMLParserTest.assertContains((String)"peach", (String)xml);
        OOXMLParserTest.assertContains((String)"March\tApril", (String)xml);
        OOXMLParserTest.assertNotContained((String)"chartSpace", (String)xml);
    }

    @Test
    public void testPPTXGroups() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_groups.pptx");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        OOXMLParserTest.assertContains((String)"WordArt1", (String)content);
        OOXMLParserTest.assertContains((String)"WordArt2", (String)content);
        OOXMLParserTest.assertContainsCount((String)"Ungrouped text box", (String)content, (int)1);
        OOXMLParserTest.assertContains((String)"Text box1", (String)content);
        OOXMLParserTest.assertContains((String)"Text box2", (String)content);
        OOXMLParserTest.assertContains((String)"Text box3", (String)content);
        OOXMLParserTest.assertContains((String)"Text box4", (String)content);
        OOXMLParserTest.assertContains((String)"Text box5", (String)content);
        OOXMLParserTest.assertContains((String)"href=\"http://tika.apache.org", (String)content);
        OOXMLParserTest.assertContains((String)"smart1", (String)content);
        OOXMLParserTest.assertContains((String)"MyTitle", (String)content);
        Assertions.assertEquals((Object)"/image1.jpg", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)"/thumbnail.jpeg", (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
    }

    @Test
    public void testXLSXPhoneticStrings() throws Exception {
        OOXMLParserTest.assertContains((String)"\u65e5\u672c\u30aa\u30e9\u30af\u30eb \u30cb\u30db\u30f3", (String)this.getXML((String)"testEXCEL_phonetic.xlsx").xml);
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setConcatenatePhoneticRuns(false);
        ParseContext pc = new ParseContext();
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        OOXMLParserTest.assertNotContained((String)"\u65e5\u672c\u30aa\u30e9\u30af\u30eb \u30cb\u30db\u30f3", (String)this.getXML((String)"testEXCEL_phonetic.xlsx", (ParseContext)pc).xml);
        TikaConfig tikaConfig = new TikaConfig(OfficeParser.class.getResourceAsStream("tika-config-exclude-phonetic.xml"));
        AutoDetectParser parser = new AutoDetectParser(tikaConfig);
        OOXMLParserTest.assertNotContained((String)"\u65e5\u672c\u30aa\u30e9\u30af\u30eb \u30cb\u30db\u30f3", (String)this.getXML((String)"testEXCEL_phonetic.xlsx", (Parser)parser).xml);
    }

    @Test
    public void testDOCXPhoneticStrings() throws Exception {
        OOXMLParserTest.assertContains((String)"\u6771\u4eac (\u3068\u3046\u304d\u3087\u3046)", (String)this.getXML((String)"testWORD_phonetic.docx").xml);
        OfficeParserConfig config = new OfficeParserConfig();
        config.setConcatenatePhoneticRuns(false);
        ParseContext parseContext = new ParseContext();
        parseContext.set(OfficeParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testWORD_phonetic.docx", (ParseContext)parseContext).xml;
        OOXMLParserTest.assertContains((String)"\u6771\u4eac", (String)xml);
        OOXMLParserTest.assertNotContained((String)"\u3068", (String)xml);
    }

    @Test
    public void testEmbeddedMedia() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_embeddedMP3.pptx");
        Assertions.assertEquals((int)4, (int)metadataList.size());
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assertions.assertEquals((Object)"audio/mpeg", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"image/png", (Object)((Metadata)metadataList.get(2)).get("Content-Type"));
        Assertions.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(3)).get("Content-Type"));
    }

    @Test
    public void testEmbeddedXLSInOLEObject() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_oleWorkbook.pptx");
        Assertions.assertEquals((int)4, (int)metadataList.size());
        Metadata xlsx = (Metadata)metadataList.get(2);
        OOXMLParserTest.assertContains((String)"<h1>Sheet1</h1>", (String)xlsx.get(TikaCoreProperties.TIKA_CONTENT));
        OOXMLParserTest.assertContains((String)"<td>1</td>", (String)xlsx.get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)xlsx.get("Content-Type"));
    }

    @Test
    public void testSigned() throws Exception {
        Metadata m = this.getXML((String)"testWORD_signed.docx").metadata;
        Assertions.assertEquals((Object)"true", (Object)m.get(TikaCoreProperties.HAS_SIGNATURE));
        m = this.getXML((String)"testEXCEL_signed.xlsx").metadata;
        Assertions.assertEquals((Object)"true", (Object)m.get(TikaCoreProperties.HAS_SIGNATURE));
        m = this.getXML((String)"testPPT_signed.pptx").metadata;
        Assertions.assertEquals((Object)"true", (Object)m.get(TikaCoreProperties.HAS_SIGNATURE));
    }

    @Test
    public void testTruncatedSAXDocx() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig c = new OfficeParserConfig();
        c.setUseSAXDocxExtractor(true);
        pc.set(OfficeParserConfig.class, (Object)c);
        Assertions.assertThrows(TikaException.class, () -> this.getRecursiveMetadata("testWORD_truncated.docx", pc));
    }

    @Test
    public void testDateFormat() throws Exception {
        try (InputStream is = this.getResourceAsStream("tika-config-custom-date-override.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            String xml = this.getXML((String)"testEXCEL_dateFormats.xlsx", (Parser)p).xml;
            OOXMLParserTest.assertContains((String)"2018-09-20", (String)xml);
            OOXMLParserTest.assertContains((String)"1996-08-10", (String)xml);
        }
    }

    @Test
    public void testDocSecurity() throws Exception {
        Assertions.assertEquals((Object)"PasswordProtected", (Object)((Metadata)this.getRecursiveMetadata("protectedFile.xlsx").get(0)).get(OfficeOpenXMLExtended.DOC_SECURITY_STRING));
        Assertions.assertEquals((Object)"ReadOnlyEnforced", (Object)((Metadata)this.getRecursiveMetadata("testWORD_docSecurity.docx").get(0)).get(OfficeOpenXMLExtended.DOC_SECURITY_STRING));
    }
}

