/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SXWPFExtractorTest
extends TikaTest {
    private ParseContext parseContext;

    @BeforeEach
    public void setUp() {
        this.parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setUseSAXDocxExtractor(true);
        officeParserConfig.setUseSAXPptxExtractor(true);
        this.parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
    }

    @Test
    public void basicTest() throws Exception {
        List metadataList = this.getRecursiveMetadata("testWORD_2006ml.docx", this.parseContext);
        Assertions.assertEquals((int)8, (int)metadataList.size());
        Metadata m = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"2016-11-29T00:58:00Z", (Object)m.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2016-11-29T17:54:00Z", (Object)m.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"My Document Title", (Object)m.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"This is the Author", (Object)m.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"3", (Object)m.get(OfficeOpenXMLCore.REVISION));
        Assertions.assertEquals((Object)"Allison, Timothy B.", (Object)m.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"260", (Object)m.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"3", (Object)m.get(Office.PARAGRAPH_COUNT));
        Assertions.assertEquals((Object)"1742", (Object)m.get(Office.CHARACTER_COUNT_WITH_SPACES));
        Assertions.assertEquals((Object)"12", (Object)m.get(Office.LINE_COUNT));
        Assertions.assertEquals((Object)"16.0000", (Object)m.get(OfficeOpenXMLExtended.APP_VERSION));
        String content = m.get(TikaCoreProperties.TIKA_CONTENT);
        SXWPFExtractorTest.assertContainsCount((String)"engaging title page", (String)content, (int)1);
        SXWPFExtractorTest.assertContainsCount((String)"This is the Author\n", (String)content, (int)1);
        SXWPFExtractorTest.assertContainsCount((String)"This is an engaging title page", (String)content, (int)1);
        SXWPFExtractorTest.assertContains((String)"My Document Title", (String)content);
        SXWPFExtractorTest.assertContains((String)"My Document Subtitle", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p class=\"toc_1\">\t<a href=\"#_Toc467647605\">Heading1\t3</a></p>", (String)content);
        SXWPFExtractorTest.assertContains((String)"2. Really basic 2.", (String)content);
        SXWPFExtractorTest.assertContainsCount((String)"This is a text box", (String)content, (int)1);
        SXWPFExtractorTest.assertContains((String)"<p>This is a hyperlink: <a href=\"http://tika.apache.org\">tika</a></p>", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p>This is a link to a local file: <a href=\"file:///C:/data/test.png\">test.png</a></p>", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p>This is          10 spaces</p>", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p class=\"table_of_figures\">\t<a href=\"#_Toc467647797\">Table 1: Table1 Caption\t2</a></p>", (String)content);
        SXWPFExtractorTest.assertContains((String)"<td>Embedded table r1c1", (String)content);
        SXWPFExtractorTest.assertContainsCount((String)"<p>This is text within a shape", (String)content, (int)1);
        SXWPFExtractorTest.assertContains((String)"<p>Rich text content control", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p>Simple text content control", (String)content);
        SXWPFExtractorTest.assertContains((String)"Repeating content", (String)content);
        SXWPFExtractorTest.assertContains((String)"Drop down1", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p>11/16/2016</p>", (String)content);
        SXWPFExtractorTest.assertContains((String)"tab\ttab", (String)content);
        SXWPFExtractorTest.assertContainsCount((String)"serious word art", (String)content, (int)1);
        SXWPFExtractorTest.assertContainsCount((String)"Wordartr1c1", (String)content, (int)1);
        SXWPFExtractorTest.assertContains((String)"Click or tap to enter a date", (String)content);
        SXWPFExtractorTest.assertContains((String)"<p>The <i>quick</i> brown <b>fox </b>j<i>um</i><b><i>ped</i></b> over", (String)content);
        SXWPFExtractorTest.assertContains((String)"This is a comment", (String)content);
        SXWPFExtractorTest.assertContains((String)"This is an endnote", (String)content);
        SXWPFExtractorTest.assertContains((String)"this is the footnote", (String)content);
        SXWPFExtractorTest.assertContains((String)"First page header", (String)content);
        SXWPFExtractorTest.assertContains((String)"Even page header", (String)content);
        SXWPFExtractorTest.assertContains((String)"Odd page header", (String)content);
        SXWPFExtractorTest.assertContains((String)"First page footer", (String)content);
        SXWPFExtractorTest.assertContains((String)"Even page footer", (String)content);
        SXWPFExtractorTest.assertContains((String)"Odd page footer", (String)content);
        SXWPFExtractorTest.assertNotContained((String)"frog", (String)content);
        SXWPFExtractorTest.assertContains((String)"Mattmann", (String)content);
    }

    @Test
    public void testWord() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("testWORD.docx", this.parseContext);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)xmlResult.metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Sample Word Document", (Object)xmlResult.metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Keith Bennett", (Object)xmlResult.metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertTrue((boolean)xmlResult.xml.contains("Sample Word Document"));
    }

    @Test
    public void testWordFootnote() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("footnotes.docx", this.parseContext);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)xmlResult.metadata.get("Content-Type"));
        Assertions.assertTrue((boolean)xmlResult.xml.contains("snoska"));
    }

    @Test
    public void testWordHTML() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD.docx", this.parseContext);
        String xml = result.xml;
        Metadata metadata = result.metadata;
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Sample Word Document", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertTrue((boolean)xml.contains("Sample Word Document"));
        Assertions.assertTrue((boolean)xml.contains("<h1 class=\"title\">"));
        SXWPFExtractorTest.assertContains((String)"<h1>Heading Level 1</h1>", (String)xml);
        Assertions.assertTrue((boolean)xml.contains("<h2>Heading Level 2</h2>"));
        Assertions.assertTrue((boolean)xml.contains("<h3>Heading Level 3<a name=\"OnLevel3\" /></h3>"));
        Assertions.assertTrue((boolean)xml.contains("<b>BOLD</b>"));
        Assertions.assertTrue((boolean)xml.contains("<i>ITALIC</i>"));
        Assertions.assertTrue((boolean)xml.contains("<table>"));
        Assertions.assertTrue((boolean)xml.contains("<td>"));
        Assertions.assertTrue((boolean)xml.contains("<a href=\"http://tika.apache.org/\">Tika</a>"));
        SXWPFExtractorTest.assertContains((String)"<a href=\"#OnMainHeading\">The Main Heading Bookmark</a>", (String)xml);
        Assertions.assertTrue((boolean)xml.contains("<p class=\"signature\">This one"));
        result = this.getXML("testWORD_3imgs.docx", this.parseContext);
        xml = result.xml;
        Assertions.assertTrue((boolean)xml.contains("<img src=\"embedded:image2.png\" alt=\"A description...\" />"), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<img src=\"embedded:image3.jpeg\" alt=\"A description...\" />"), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<img src=\"embedded:image4.png\" alt=\"A description...\" />"), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<p>The end!</p>"));
    }

    @Test
    public void testContiguousHTMLFormatting() throws Exception {
        String xml = this.getXML((String)"testWORD_bold_character_runs.docx", (ParseContext)this.parseContext).xml;
        Assertions.assertTrue((boolean)xml.contains("F<b>oob</b>a<b>r</b>"), (String)("Bold text wasn't contiguous: " + xml));
        xml = this.getXML((String)"testWORD_bold_character_runs2.docx", (ParseContext)this.parseContext).xml;
        Assertions.assertTrue((boolean)xml.contains("F<b>oob</b>a<b>r</b>"), (String)("Bold text wasn't contiguous: " + xml));
    }

    @Test
    public void testWordPicturesInHeader() throws Exception {
        List metadataList = this.getRecursiveMetadata("headerPic.docx", this.parseContext);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Metadata m = (Metadata)metadataList.get(0);
        String mainContent = m.get(TikaCoreProperties.TIKA_CONTENT);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)m.get("Content-Type"));
        Assertions.assertTrue((boolean)mainContent.contains("<img"));
    }

    @Test
    public void testPicturesInVariousPlaces() throws Exception {
        List metadataList = this.getRecursiveMetadata("testWORD_embedded_pics.docx", this.parseContext);
        Assertions.assertEquals((int)3, (int)metadataList.size());
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        for (int i = 1; i < 4; ++i) {
            SXWPFExtractorTest.assertContains((String)("header" + i + "_pic"), (String)content);
            SXWPFExtractorTest.assertContains((String)("footer" + i + "_pic"), (String)content);
        }
        SXWPFExtractorTest.assertContains((String)"body_pic.jpg", (String)content);
        SXWPFExtractorTest.assertContains((String)"sdt_pic.jpg", (String)content);
        SXWPFExtractorTest.assertContains((String)"deeply_embedded_pic", (String)content);
        SXWPFExtractorTest.assertContains((String)"deleted_pic", (String)content);
        SXWPFExtractorTest.assertContains((String)"footnotes_pic", (String)content);
        SXWPFExtractorTest.assertContains((String)"comments_pic", (String)content);
        SXWPFExtractorTest.assertContains((String)"endnotes_pic", (String)content);
        SXWPFExtractorTest.assertContainsCount((String)"<img src=", (String)content, (int)14);
    }

    @Test
    public void testNullHeaders() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("NullHeader.docx", this.parseContext);
        Assertions.assertEquals((Object)false, (Object)xmlResult.xml.isEmpty(), (String)"Should have found some text");
    }

    @Test
    public void testVarious() throws Exception {
        int row;
        Metadata metadata = new Metadata();
        String content = this.getText("testWORD_various.docx", metadata, this.parseContext);
        SXWPFExtractorTest.assertContains((String)"Footnote appears here", (String)content);
        SXWPFExtractorTest.assertContains((String)"This is a footnote.", (String)content);
        SXWPFExtractorTest.assertContains((String)"This is the header text.", (String)content);
        SXWPFExtractorTest.assertContains((String)"This is the footer text.", (String)content);
        SXWPFExtractorTest.assertContains((String)"Here is a text box", (String)content);
        SXWPFExtractorTest.assertContains((String)"Bold", (String)content);
        SXWPFExtractorTest.assertContains((String)"italic", (String)content);
        SXWPFExtractorTest.assertContains((String)"underline", (String)content);
        SXWPFExtractorTest.assertContains((String)"superscript", (String)content);
        SXWPFExtractorTest.assertContains((String)"subscript", (String)content);
        SXWPFExtractorTest.assertContains((String)"Here is a citation:", (String)content);
        SXWPFExtractorTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)content);
        SXWPFExtractorTest.assertContains((String)"(Kramer)", (String)content);
        SXWPFExtractorTest.assertContains((String)"Row 1 Col 1 Row 1 Col 2 Row 1 Col 3 Row 2 Col 1 Row 2 Col 2 Row 2 Col 3", (String)content.replaceAll("\\s+", " "));
        SXWPFExtractorTest.assertContains((String)"Row 1 column 1 Row 2 column 1 Row 1 column 2 Row 2 column 2", (String)content.replaceAll("\\s+", " "));
        SXWPFExtractorTest.assertContains((String)"This is a hyperlink", (String)content);
        SXWPFExtractorTest.assertContains((String)"Here is a list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            SXWPFExtractorTest.assertContains((String)("Bullet " + row), (String)content);
        }
        SXWPFExtractorTest.assertContains((String)"Here is a numbered list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            SXWPFExtractorTest.assertContains((String)("Number bullet " + row), (String)content);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                SXWPFExtractorTest.assertContains((String)("Row " + row + " Col " + col), (String)content);
            }
        }
        SXWPFExtractorTest.assertContains((String)"Keyword1 Keyword2", (String)content);
        Assertions.assertEquals((Object)"Keyword1 Keyword2", (Object)metadata.get(Office.KEYWORDS));
        SXWPFExtractorTest.assertContains((String)"Subject is here", (String)content);
        Assertions.assertEquals((Object)"Subject is here", (Object)metadata.get(OfficeOpenXMLCore.SUBJECT));
        SXWPFExtractorTest.assertContains((String)"Suddenly some Japanese text:", (String)content);
        SXWPFExtractorTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)content);
        SXWPFExtractorTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)content);
        SXWPFExtractorTest.assertContains((String)"And then some Gothic text:", (String)content);
        SXWPFExtractorTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)content);
    }

    @Test
    public void testWordCustomProperties() throws Exception {
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        Metadata metadata = this.getXML((String)"testWORD_custom_props.docx", (ParseContext)this.parseContext).metadata;
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"EJ04325S", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Etienne Jouvin", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2011-07-29T16:52:00Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2012-01-03T22:14:00Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(Office.PAGE_COUNT));
        Assertions.assertEquals((Object)"2", (Object)metadata.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"My Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"My Keyword", (Object)metadata.get(Office.KEYWORDS));
        SXWPFExtractorTest.assertContains((Object)"My Keyword", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        Assertions.assertEquals((Object)"Normal.dotm", (Object)metadata.get(OfficeOpenXMLExtended.TEMPLATE));
        Assertions.assertEquals((Object)"My subject", (Object)metadata.get(OfficeOpenXMLCore.SUBJECT));
        Assertions.assertEquals((Object)"EDF-DIT", (Object)metadata.get(TikaCoreProperties.PUBLISHER));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T23:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assertions.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    public void testEmbeddedPDF() throws Exception {
        String xml = this.getXML((String)"testWORD_embedded_pdf.docx", (ParseContext)this.parseContext).xml;
        int i = xml.indexOf("Here is the pdf file:");
        int j = xml.indexOf("<div class=\"embedded\" id=\"rId5\" />");
        int k = xml.indexOf("Bye Bye");
        int l = xml.indexOf("<div class=\"embedded\" id=\"rId6\" />");
        int m = xml.indexOf("Bye for real.");
        Assertions.assertTrue((i != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((j != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((k != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((l != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((m != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((i < j ? 1 : 0) != 0);
        Assertions.assertTrue((j < k ? 1 : 0) != 0);
        Assertions.assertTrue((k < l ? 1 : 0) != 0);
        Assertions.assertTrue((l < m ? 1 : 0) != 0);
    }

    @Test
    public void testWordNullStyle() throws Exception {
        String xml = this.getXML((String)"testWORD_null_style.docx").xml;
        SXWPFExtractorTest.assertContains((String)"Test av styrt dokument", (String)xml);
    }

    @Test
    public void testNoFormat() throws Exception {
        SXWPFExtractorTest.assertContains((String)"This is a piece of text that causes an exception", (String)this.getXML((String)"testWORD_no_format.docx", (ParseContext)this.parseContext).xml);
    }

    @Test
    public void testSkipDeleted() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeDeletedContent(true);
        officeParserConfig.setUseSAXDocxExtractor(true);
        officeParserConfig.setIncludeMoveFromContent(true);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        TikaTest.XMLResult r = this.getXML("testWORD_2006ml.docx", pc);
        SXWPFExtractorTest.assertContains((String)"frog", (String)r.xml);
        SXWPFExtractorTest.assertContainsCount((String)"Second paragraph", (String)r.xml, (int)2);
    }

    @Test
    public void testTextInsideTextBox() throws Exception {
        String xml = this.getXML((String)"testWORD_text_box.docx", (ParseContext)this.parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"This text is directly in the body of the document.", (String)xml);
        SXWPFExtractorTest.assertContains((String)"This text is inside of a text box in the body of the document.", (String)xml);
        SXWPFExtractorTest.assertContains((String)"This text is inside of a text box in the header of the document.", (String)xml);
        SXWPFExtractorTest.assertContains((String)"This text is inside of a text box in the footer of the document.", (String)xml);
    }

    @Test
    public void testTurningOffTextBoxExtraction() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeShapeBasedContent(false);
        officeParserConfig.setUseSAXDocxExtractor(true);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testWORD_text_box.docx", (ParseContext)pc).xml;
        SXWPFExtractorTest.assertContains((String)"This text is directly in the body of the document.", (String)xml);
        SXWPFExtractorTest.assertNotContained((String)"This text is inside of a text box in the body of the document.", (String)xml);
        SXWPFExtractorTest.assertNotContained((String)"This text is inside of a text box in the header of the document.", (String)xml);
        SXWPFExtractorTest.assertNotContained((String)"This text is inside of a text box in the footer of the document.", (String)xml);
    }

    @Test
    public void testMissingText() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("testWORD_missing_text.docx", this.parseContext);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)xmlResult.metadata.get("Content-Type"));
        SXWPFExtractorTest.assertContains((String)"BigCompany", (String)xmlResult.xml);
        SXWPFExtractorTest.assertContains((String)"Seasoned", (String)xmlResult.xml);
        SXWPFExtractorTest.assertContains((String)"Rich_text_in_cell", (String)xmlResult.xml);
    }

    @Test
    public void testWordMissingOOXMLBeans() throws Exception {
        String[] fileNames = new String[]{"testWORD_missing_ooxml_bean1.docx"};
        PrintStream origErr = System.err;
        for (String fileName : fileNames) {
            ByteArrayOutputStream errContent = new ByteArrayOutputStream();
            System.setErr(new PrintStream((OutputStream)errContent, true, StandardCharsets.UTF_8.name()));
            this.getXML(fileName, this.parseContext);
            System.setErr(origErr);
            String err = errContent.toString(StandardCharsets.UTF_8.name());
            Assertions.assertTrue((err.length() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDOCXThumbnail() throws Exception {
        String xml = this.getXML((String)"testDOCX_Thumbnail.docx", (ParseContext)this.parseContext).xml;
        int a = xml.indexOf("This file contains a thumbnail");
        int b = xml.indexOf("<div class=\"embedded\" id=\"/docProps/thumbnail.emf\" />");
        Assertions.assertTrue((a != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((b != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((a < b ? 1 : 0) != 0);
    }

    @Test
    public void testEncrypted() throws Exception {
        HashMap<String, String> tests = new HashMap<String, String>();
        tests.put("testWORD_protected_passtika.docx", "This is an encrypted Word 2007 File");
        Metadata m = new Metadata();
        PasswordProvider passwordProvider = metadata -> "tika";
        OfficeParserConfig opc = new OfficeParserConfig();
        opc.setUseSAXDocxExtractor(true);
        ParseContext passwordContext = new ParseContext();
        passwordContext.set(PasswordProvider.class, (Object)passwordProvider);
        passwordContext.set(OfficeParserConfig.class, (Object)opc);
        for (Map.Entry e : tests.entrySet()) {
            SXWPFExtractorTest.assertContains((String)((String)e.getValue()), (String)this.getXML((String)((String)e.getKey()), (ParseContext)passwordContext).xml);
        }
        for (Map.Entry e : tests.entrySet()) {
            boolean exc = false;
            try {
                this.getXML((String)e.getKey(), this.parseContext);
            }
            catch (EncryptedDocumentException ex) {
                exc = true;
            }
            Assertions.assertTrue((boolean)exc);
        }
    }

    @Test
    public void testDOCXParagraphNumbering() throws Exception {
        String xml = this.getXML((String)"testWORD_numbered_list.docx", (ParseContext)this.parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"add a list here", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1) This", (String)xml);
        SXWPFExtractorTest.assertContains((String)"a) Is", (String)xml);
        SXWPFExtractorTest.assertContains((String)"i) A multi", (String)xml);
        SXWPFExtractorTest.assertContains((String)"ii) Level", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1. Within cell 1", (String)xml);
        SXWPFExtractorTest.assertContains((String)"b. Cell b", (String)xml);
        SXWPFExtractorTest.assertContains((String)"iii) List", (String)xml);
        SXWPFExtractorTest.assertContains((String)"2) foo", (String)xml);
        SXWPFExtractorTest.assertContains((String)"ii) baz", (String)xml);
        SXWPFExtractorTest.assertContains((String)"ii) foo", (String)xml);
        SXWPFExtractorTest.assertContains((String)"II. bar", (String)xml);
        SXWPFExtractorTest.assertContains((String)"6. six", (String)xml);
        SXWPFExtractorTest.assertContains((String)"7. seven", (String)xml);
        SXWPFExtractorTest.assertContains((String)"a. seven a", (String)xml);
        SXWPFExtractorTest.assertContains((String)"e. seven e", (String)xml);
        SXWPFExtractorTest.assertContains((String)"2. A ii 2", (String)xml);
        SXWPFExtractorTest.assertContains((String)"3. page break list 3", (String)xml);
        SXWPFExtractorTest.assertContains((String)"Some-1-CrazyFormat Greek numbering with crazy format - alpha", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1.1.1. 1.1.1", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1.1. 1.2-&gt;1.1  //set the value", (String)xml);
    }

    @Test
    public void testDOCXOverrideParagraphNumbering() throws Exception {
        String xml = this.getXML((String)"testWORD_override_list_numbering.docx").xml;
        SXWPFExtractorTest.assertContains((String)"<p>1.1.1.1...1 1.1.1.1...1</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1st.2.3someText 1st.2.3someText", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1st.2.2someOtherText.1 1st.2.2someOtherText.1", (String)xml);
        SXWPFExtractorTest.assertContains((String)"5th 5th", (String)xml);
        SXWPFExtractorTest.assertContains((String)"1.a.I 1.a.I", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>1.b.III 1.b.III</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"2.a.I 2.a.I", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>2.b 2.b</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"(1)) (1))", (String)xml);
        SXWPFExtractorTest.assertContains((String)"2.17 2.17", (String)xml);
        SXWPFExtractorTest.assertContains((String)"2.18.2.1 2.18.2.1", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>2 2</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>1 1</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>A A</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>B B</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>C C</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<p>4 4</p>", (String)xml);
        SXWPFExtractorTest.assertContains((String)">00 00", (String)xml);
        SXWPFExtractorTest.assertContains((String)">01 01", (String)xml);
        SXWPFExtractorTest.assertContains((String)">01. 01.", (String)xml);
        SXWPFExtractorTest.assertContains((String)">01..1 01..1", (String)xml);
        SXWPFExtractorTest.assertContains((String)">02 02", (String)xml);
    }

    @Test
    public void testMultiAuthorsManagers() throws Exception {
        TikaTest.XMLResult r = this.getXML("testWORD_multi_authors.docx", this.parseContext);
        String[] authors = r.metadata.getValues(TikaCoreProperties.CREATOR);
        Assertions.assertEquals((int)3, (int)authors.length);
        Assertions.assertEquals((Object)"author2", (Object)authors[1]);
        String[] managers = r.metadata.getValues(OfficeOpenXMLExtended.MANAGER);
        Assertions.assertEquals((int)2, (int)managers.length);
        Assertions.assertEquals((Object)"manager1", (Object)managers[0]);
        Assertions.assertEquals((Object)"manager2", (Object)managers[1]);
    }

    @Test
    public void testOrigSourcePath() throws Exception {
        Metadata embed1_zip_metadata = (Metadata)this.getRecursiveMetadata("test_recursive_embedded.docx", this.parseContext).get(2);
        SXWPFExtractorTest.assertContains((Object)"C:\\Users\\tallison\\AppData\\Local\\Temp\\embed1.zip", Arrays.asList(embed1_zip_metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)));
        SXWPFExtractorTest.assertContains((Object)"C:\\Users\\tallison\\Desktop\\tmp\\New folder (2)\\embed1.zip", Arrays.asList(embed1_zip_metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)));
    }

    @Test
    public void testBoldHyperlink() throws Exception {
        String xml = this.getXML((String)"testWORD_boldHyperlink.docx", (ParseContext)this.parseContext).xml;
        xml = xml.replaceAll("\\s+", " ");
        SXWPFExtractorTest.assertContains((String)"<a href=\"http://tika.apache.org/\">hyper <b>link</b></a>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<a href=\"http://tika.apache.org/\"><b>hyper</b> link</a>; bold", (String)xml);
    }

    @Test
    public void testLongForIntExceptionInSummaryDetails() throws Exception {
        SXWPFExtractorTest.assertContains((String)"bold", (String)this.getXML((String)"testWORD_totalTimeOutOfRange.docx", (ParseContext)this.parseContext).xml);
    }

    @Test
    public void testMacrosInDocm() throws Exception {
        Metadata parsedBy = new Metadata();
        parsedBy.add(TikaCoreProperties.TIKA_PARSED_BY, "org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFEventBasedWordExtractor");
        List metadataList = this.getRecursiveMetadata("testWORD_macros.docm", this.parseContext);
        for (Metadata metadata : metadataList) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assertions.fail((String)"Shouldn't have extracted macros as default");
        }
        SXWPFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        officeParserConfig.setUseSAXDocxExtractor(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        metadataList = this.getRecursiveMetadata("testWORD_macros.docm", context);
        SXWPFExtractorTest.assertContains((String)"quick", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        SXWPFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Embolden()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Italicize()");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        SXWPFExtractorTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
        SXWPFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        try (InputStream is = this.getResourceAsStream("tika-config-sax-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            metadataList = this.getRecursiveMetadata("testWORD_macros.docm", (Parser)parser);
            SXWPFExtractorTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
            SXWPFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        }
    }

    @Test
    public void testEmbedded() throws Exception {
        List metadataList = this.getRecursiveMetadata("testWORD_embeded.docx", this.parseContext);
        Metadata main = (Metadata)metadataList.get(0);
        String content = main.get(TikaCoreProperties.TIKA_CONTENT);
        SXWPFExtractorTest.assertContains((String)"<img src=\"embedded:image2.jpeg\" alt=\"A description...\" />", (String)content);
        SXWPFExtractorTest.assertContains((String)"<div class=\"embedded\" id=\"rId8\" />", (String)content);
        Assertions.assertEquals((int)16, (int)metadataList.size());
    }

    @Test
    public void testDotx() throws Exception {
        List metadataList = this.getRecursiveMetadata("testWORD_template.docx", this.parseContext);
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        SXWPFExtractorTest.assertContains((String)"Metallica", (String)content);
        SXWPFExtractorTest.assertContains((String)"Hetfield", (String)content);
        SXWPFExtractorTest.assertContains((String)"one eye open", (String)content);
        SXWPFExtractorTest.assertContains((String)"Getting the perfect", (String)content);
        SXWPFExtractorTest.assertContains((String)"table rows", (String)content);
        metadataList = this.getRecursiveMetadata("testWORD_template.dotx", this.parseContext);
        content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        SXWPFExtractorTest.assertContainsCount((String)"ready to write", (String)content, (int)2);
    }

    @Test
    public void testDiagramData() throws Exception {
        SXWPFExtractorTest.assertContains((String)"From here", (String)this.getXML((String)"testWORD_diagramData.docx", (ParseContext)this.parseContext).xml);
    }

    @Test
    public void testDOCXChartData() throws Exception {
        String xml = this.getXML((String)"testWORD_charts.docx", (ParseContext)this.parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"peach", (String)xml);
        SXWPFExtractorTest.assertContains((String)"March\tApril", (String)xml);
        SXWPFExtractorTest.assertNotContained((String)"chartSpace", (String)xml);
    }

    @Test
    public void testHeaderFooterNotExtraction() throws Exception {
        ParseContext parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeHeadersAndFooters(false);
        officeParserConfig.setUseSAXDocxExtractor(true);
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testWORD_various.docx", (ParseContext)parseContext).xml;
        SXWPFExtractorTest.assertNotContained((String)"This is the header text.", (String)xml);
        SXWPFExtractorTest.assertNotContained((String)"This is the footer text.", (String)xml);
    }

    @Test
    public void testDOCXPhoneticStrings() throws Exception {
        OfficeParserConfig config = new OfficeParserConfig();
        config.setUseSAXDocxExtractor(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(OfficeParserConfig.class, (Object)config);
        SXWPFExtractorTest.assertContains((String)"\u6771\u4eac (\u3068\u3046\u304d\u3087\u3046)", (String)this.getXML((String)"testWORD_phonetic.docx", (ParseContext)parseContext).xml);
        config.setConcatenatePhoneticRuns(false);
        String xml = this.getXML((String)"testWORD_phonetic.docx", (ParseContext)parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"\u6771\u4eac", (String)xml);
        SXWPFExtractorTest.assertNotContained((String)"\u3068", (String)xml);
    }

    @Test
    public void testTextDecoration() throws Exception {
        String xml = this.getXML((String)"testWORD_various.docx", (ParseContext)this.parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"<b>Bold</b>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<i>italic</i>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<u>underline</u>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<strike>strikethrough</strike>", (String)xml);
    }

    @Test
    public void testTextDecorationNested() throws Exception {
        String xml = this.getXML((String)"testWORD_various.docx", (ParseContext)this.parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"<i>ita<strike>li</strike>c</i>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<i>ita<strike>l<u>i</u></strike>c</i>", (String)xml);
        SXWPFExtractorTest.assertContains((String)"<i><u>unde</u><strike><u>r</u></strike><u>line</u></i>", (String)xml);
        String txt = this.getText("testWORD_various.docx", new Metadata(), this.parseContext);
        SXWPFExtractorTest.assertContainsCount((String)"italic", (String)txt, (int)3);
        SXWPFExtractorTest.assertNotContained((String)"ita ", (String)txt);
        SXWPFExtractorTest.assertContainsCount((String)"underline", (String)txt, (int)2);
        SXWPFExtractorTest.assertNotContained((String)"unde ", (String)txt);
    }

    @Test
    public void testSDTInTextBox() throws Exception {
        String xml = this.getXML((String)"testWORD_sdtInTextBox.docx", (ParseContext)this.parseContext).xml;
        SXWPFExtractorTest.assertContains((String)"rich-text-content-control_inside-text-box", (String)xml);
        SXWPFExtractorTest.assertContainsCount((String)"inside-text", (String)xml, (int)1);
    }
}

