/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TruncatedOOXMLTest
extends TikaTest {
    @Test
    public void testWordTrunc14435() throws Exception {
        List metadataList = this.getRecursiveMetadata(this.truncate("testWORD_various.docx", 14435), true);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Metadata metadata = (Metadata)metadataList.get(0);
        String content = metadata.get(TikaCoreProperties.TIKA_CONTENT);
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)metadata.get("Content-Type"));
        TruncatedOOXMLTest.assertContains((String)"This is the header", (String)content);
        TruncatedOOXMLTest.assertContains((String)"This is the footer text", (String)content);
        TruncatedOOXMLTest.assertContains((String)"Suddenly some Japanese", (String)content);
    }

    @Test
    public void testTruncation() throws Exception {
        int length = (int)this.getResourceAsFile("/test-documents/testWORD_various.docx").length();
        Random r = new Random();
        for (int i = 0; i < 50; ++i) {
            int targetLength = r.nextInt(length);
            InputStream is = this.truncate("testWORD_various.docx", targetLength);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            Assertions.assertEquals((int)targetLength, (int)bos.toByteArray().length);
        }
        try {
            InputStream is = this.truncate("testWORD_various.docx", length + 1);
            Assertions.fail((String)"should have thrown EOF");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    @Disabled(value="for dev/debugging only")
    public void listStreams() throws Exception {
        File tstDir = new File(this.getResourceAsUri("/test-documents"));
        for (File f : tstDir.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".xlsx")) continue;
            try (FileInputStream is = new FileInputStream(f);){
                ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream((InputStream)is);
                ZipArchiveEntry zae = zipArchiveInputStream.getNextZipEntry();
                int cnt = 0;
                while (zae != null && !zae.isDirectory() && ++cnt <= 10) {
                    System.out.println(f.getName() + " : " + zae.getName());
                    if (zae.getName().equals("_rels/.rels")) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)bos);
                        System.out.println(new String(bos.toByteArray(), StandardCharsets.UTF_8));
                    }
                    zae = zipArchiveInputStream.getNextZipEntry();
                }
            }
            catch (Exception e) {
                System.out.println(f.getName() + " : " + e.getMessage());
            }
        }
    }
}

