/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.util.List;
import org.apache.tika.MultiThreadedTikaTest;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.utils.XMLReaderUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class Word2006MLParserTest
extends MultiThreadedTikaTest {
    @AfterAll
    public static void tearDown() throws TikaException {
        XMLReaderUtils.setPoolSize((int)10);
    }

    @Test
    public void basicTest() throws Exception {
        List metadataList = this.getRecursiveMetadata("testWORD_2006ml.xml");
        Assertions.assertEquals((int)9, (int)metadataList.size());
        Metadata m = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"2016-11-29T17:54:00Z", (Object)m.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2016-11-29T17:54:00Z", (Object)m.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"My Document Title", (Object)m.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"This is the Author", (Object)m.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"2", (Object)m.get(OfficeOpenXMLCore.REVISION));
        Assertions.assertEquals((Object)"Allison, Timothy B.", (Object)m.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"0", (Object)m.get(OfficeOpenXMLExtended.DOC_SECURITY));
        Assertions.assertEquals((Object)"260", (Object)m.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"3", (Object)m.get(Office.PARAGRAPH_COUNT));
        Assertions.assertEquals((Object)"1742", (Object)m.get(Office.CHARACTER_COUNT_WITH_SPACES));
        Assertions.assertEquals((Object)"12", (Object)m.get(Office.LINE_COUNT));
        Assertions.assertEquals((Object)"16.0000", (Object)m.get(OfficeOpenXMLExtended.APP_VERSION));
        String content = m.get(TikaCoreProperties.TIKA_CONTENT);
        Word2006MLParserTest.assertContainsCount((String)"This is the Author", (String)content, (int)1);
        Word2006MLParserTest.assertContainsCount((String)"This is an engaging title page", (String)content, (int)1);
        Word2006MLParserTest.assertContains((String)"My Document Title", (String)content);
        Word2006MLParserTest.assertContains((String)"My Document Subtitle", (String)content);
        Word2006MLParserTest.assertContains((String)"<p>\t<a href=\"#_Toc467647605\">Heading1\t3</a></p>", (String)content);
        Word2006MLParserTest.assertContains((String)"Really basic 2.", (String)content);
        Word2006MLParserTest.assertContainsCount((String)"This is a text box", (String)content, (int)1);
        Word2006MLParserTest.assertContains((String)"<p>This is          10 spaces</p>", (String)content);
        Word2006MLParserTest.assertContains((String)"<p>\t<a href=\"#_Toc467647797\">Table 1: Table1 Caption\t2</a>", (String)content);
        Word2006MLParserTest.assertContains((String)"<td>Embedded table r1c1", (String)content);
        Word2006MLParserTest.assertContainsCount((String)"<p>This is text within a shape", (String)content, (int)1);
        Word2006MLParserTest.assertContains((String)"<p>Rich text content control", (String)content);
        Word2006MLParserTest.assertContains((String)"<p>Simple text content control", (String)content);
        Word2006MLParserTest.assertContains((String)"Repeating content", (String)content);
        Word2006MLParserTest.assertContains((String)"Drop down1", (String)content);
        Word2006MLParserTest.assertContains((String)"<p>11/16/2016</p>", (String)content);
        Word2006MLParserTest.assertContains((String)"tab\ttab", (String)content);
        Word2006MLParserTest.assertContainsCount((String)"serious word art", (String)content, (int)1);
        Word2006MLParserTest.assertContainsCount((String)"Wordartr1c1", (String)content, (int)1);
        Word2006MLParserTest.assertContains((String)"Click or tap to enter a date", (String)content);
        Word2006MLParserTest.assertContains((String)"<p>The <i>quick</i> brown <b>fox </b>j<i>um</i><b><i>ped</i></b> over", (String)content);
        Word2006MLParserTest.assertContains((String)"This is a comment", (String)content);
        Word2006MLParserTest.assertContains((String)"This is an endnote", (String)content);
        Word2006MLParserTest.assertContains((String)"this is the footnote", (String)content);
        Word2006MLParserTest.assertContains((String)"First page header", (String)content);
        Word2006MLParserTest.assertContains((String)"Even page header", (String)content);
        Word2006MLParserTest.assertContains((String)"Odd page header", (String)content);
        Word2006MLParserTest.assertContains((String)"First page footer", (String)content);
        Word2006MLParserTest.assertContains((String)"Even page footer", (String)content);
        Word2006MLParserTest.assertContains((String)"Odd page footer", (String)content);
        Word2006MLParserTest.assertNotContained((String)"frog", (String)content);
        Word2006MLParserTest.assertContains((String)"Mattmann", (String)content);
        Word2006MLParserTest.assertContainsCount((String)"Second paragraph", (String)content, (int)1);
    }

    @Test
    public void testSkipDeletedAndMoveFrom() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeDeletedContent(true);
        officeParserConfig.setIncludeMoveFromContent(true);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        TikaTest.XMLResult r = this.getXML("testWORD_2006ml.xml", pc);
        Word2006MLParserTest.assertContains((String)"frog", (String)r.xml);
        Word2006MLParserTest.assertContainsCount((String)"Second paragraph", (String)r.xml, (int)2);
    }

    @Test
    @Timeout(value=60000L)
    public void testMultiThreaded() throws Exception {
        XMLReaderUtils.setPoolSize((int)4);
        int numThreads = XMLReaderUtils.getPoolSize() * 2;
        ParseContext[] contexts = new ParseContext[numThreads];
        for (int i = 0; i < contexts.length; ++i) {
            contexts[i] = new ParseContext();
        }
        this.testMultiThreaded(AUTO_DETECT_PARSER, contexts, numThreads, 2, pathname -> pathname.getName().equals("testWORD_2006ml.xml"));
    }
}

