/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.feed;

import java.io.InputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.feed.FeedParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class FeedParserTest {
    @Test
    public void testRSSParser() throws Exception {
        for (String rssFile : new String[]{"/test-documents/rsstest_091.rss", "/test-documents/rsstest_20.rss"}) {
            try (InputStream input = FeedParserTest.class.getResourceAsStream(rssFile);){
                Metadata metadata = new Metadata();
                BodyContentHandler handler = new BodyContentHandler();
                ParseContext context = new ParseContext();
                new FeedParser().parse(input, (ContentHandler)handler, metadata, context);
                String content = handler.toString();
                Assertions.assertNotNull((Object)content);
                Assertions.assertEquals((Object)"Sample RSS File for Junit test", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
                Assertions.assertEquals((Object)"TestChannel", (Object)metadata.get(TikaCoreProperties.TITLE));
            }
        }
    }

    @Test
    public void testAtomParser() throws Exception {
        try (InputStream input = FeedParserTest.class.getResourceAsStream("/test-documents/testATOM.atom");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            new FeedParser().parse(input, (ContentHandler)handler, metadata, context);
            String content = handler.toString();
            Assertions.assertNotNull((Object)content);
            Assertions.assertEquals((Object)"Sample Atom File for Junit test", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"Test Atom Feed", (Object)metadata.get(TikaCoreProperties.TITLE));
        }
    }
}

