/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.junit.jupiter.api.BeforeEach;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractPkgTest
extends TikaTest {
    protected ParseContext trackingContext;
    protected ParseContext recursingContext;
    protected EmbeddedTrackingParser tracker;

    @BeforeEach
    public void setUp() throws Exception {
        this.tracker = new EmbeddedTrackingParser();
        this.trackingContext = new ParseContext();
        this.trackingContext.set(Parser.class, (Object)this.tracker);
        this.recursingContext = new ParseContext();
        this.recursingContext.set(Parser.class, (Object)AUTO_DETECT_PARSER);
    }

    protected static class EmbeddedTrackingParser
    extends AbstractParser {
        protected List<String> filenames = new ArrayList<String>();
        protected List<String> mediatypes = new ArrayList<String>();
        protected List<String> createdAts = new ArrayList<String>();
        protected List<String> modifiedAts = new ArrayList<String>();
        protected byte[] lastSeenStart;

        protected EmbeddedTrackingParser() {
        }

        public void reset() {
            this.filenames.clear();
            this.mediatypes.clear();
            this.createdAts.clear();
            this.modifiedAts.clear();
        }

        public Set<MediaType> getSupportedTypes(ParseContext context) {
            return AUTO_DETECT_PARSER.getSupportedTypes(context);
        }

        public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            this.filenames.add(metadata.get("resourceName"));
            this.mediatypes.add(metadata.get("Content-Type"));
            this.createdAts.add(metadata.get(TikaCoreProperties.CREATED));
            this.modifiedAts.add(metadata.get(TikaCoreProperties.MODIFIED));
            this.lastSeenStart = new byte[32];
            stream.read(this.lastSeenStart);
        }
    }
}

