/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.zip.CompressorConstants;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.CompressorParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CompressorParserTest
extends TikaTest {
    private static Set<MediaType> NOT_COVERED = new HashSet<MediaType>();

    @BeforeAll
    public static void setUp() {
        NOT_COVERED.add(MediaType.application((String)"x-lz4-block"));
        NOT_COVERED.add(MediaType.application((String)"x-snappy-raw"));
        NOT_COVERED.add(MediaType.application((String)"deflate64"));
    }

    @Test
    public void testCoverage() throws Exception {
        CompressorStreamFactory archiveStreamFactory = new CompressorStreamFactory(true, 1000);
        CompressorParser compressorParser = new CompressorParser();
        ParseContext parseContext = new ParseContext();
        for (String name : archiveStreamFactory.getInputStreamCompressorNames()) {
            MediaType mt = CompressorConstants.getMediaType((String)name);
            if (NOT_COVERED.contains(mt)) continue;
            if (mt.equals((Object)MediaType.OCTET_STREAM)) {
                Assertions.fail((String)("getting octet-stream for: " + name));
            }
            if (compressorParser.getSupportedTypes(parseContext).contains(mt)) continue;
            Assertions.fail((String)("CompressorParser should support: " + mt.toString()));
        }
    }

    @Test
    public void testQuineXHTML() throws Exception {
        Assumptions.assumeTrue((CompressorParserTest.class.getResourceAsStream("/test-documents/quine.gz") != null ? 1 : 0) != 0);
        Assertions.assertThrows(TikaException.class, () -> this.getXML("quine.gz"));
    }

    @Test
    public void testQuineRecursive() throws Exception {
        Assumptions.assumeTrue((CompressorParserTest.class.getResourceAsStream("/test-documents/quine.gz") != null ? 1 : 0) != 0);
        this.getRecursiveMetadata("quine.gz");
    }
}

