/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.zip.PackageConstants;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.PackageParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PackageParserTest
extends TikaTest {
    @Test
    public void testCoverage() throws Exception {
        ArchiveStreamFactory archiveStreamFactory = new ArchiveStreamFactory(StandardCharsets.UTF_8.name());
        PackageParser packageParser = new PackageParser();
        ParseContext parseContext = new ParseContext();
        for (String name : archiveStreamFactory.getInputStreamArchiveNames()) {
            MediaType mt = PackageConstants.getMediaType((String)name);
            if (mt.equals((Object)MediaType.OCTET_STREAM)) {
                Assertions.fail((String)("getting octet-stream for: " + name));
            }
            if (packageParser.getSupportedTypes(parseContext).contains(mt)) continue;
            Assertions.fail((String)("PackageParser should support: " + mt.toString()));
        }
    }

    @Test
    public void testSpecializations() throws Exception {
        TikaConfig config = TikaConfig.getDefaultConfig();
        MediaTypeRegistry mediaTypeRegistry = config.getMimeRepository().getMediaTypeRegistry();
        HashSet<MediaType> currentSpecializations = new HashSet<MediaType>();
        MediaType tar = MediaType.parse((String)"application/x-tar");
        for (MediaType type : mediaTypeRegistry.getTypes()) {
            if (!mediaTypeRegistry.isSpecializationOf(type, MediaType.APPLICATION_ZIP) && !mediaTypeRegistry.isSpecializationOf(type, tar)) continue;
            currentSpecializations.add(type);
        }
        for (MediaType mediaType : currentSpecializations) {
            Assertions.assertTrue((boolean)PackageParser.PACKAGE_SPECIALIZATIONS.contains(mediaType), (String)("missing: " + mediaType));
        }
        Assertions.assertEquals((int)currentSpecializations.size(), (int)PackageParser.PACKAGE_SPECIALIZATIONS.size());
    }
}

