/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.pkg.AbstractPkgTest;
import org.apache.tika.parser.pkg.RarParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class RarParserTest
extends AbstractPkgTest {
    @Test
    public void testEmbedded() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (Iterator<String> stream = this.getResourceAsStream("/test-documents/test-documents.rar");){
            AUTO_DETECT_PARSER.parse((InputStream)((Object)stream), (ContentHandler)handler, metadata, this.trackingContext);
        }
        Assertions.assertEquals((int)9, (int)this.tracker.filenames.size());
        Assertions.assertEquals((int)9, (int)this.tracker.mediatypes.size());
        Assertions.assertEquals((int)9, (int)this.tracker.modifiedAts.size());
        Assertions.assertEquals((Object)"test-documents/testEXCEL.xls", (Object)this.tracker.filenames.get(0));
        Assertions.assertEquals((Object)"test-documents/testHTML.html", (Object)this.tracker.filenames.get(1));
        Assertions.assertEquals((Object)"test-documents/testOpenOffice2.odt", (Object)this.tracker.filenames.get(2));
        Assertions.assertEquals((Object)"test-documents/testPDF.pdf", (Object)this.tracker.filenames.get(3));
        Assertions.assertEquals((Object)"test-documents/testPPT.ppt", (Object)this.tracker.filenames.get(4));
        Assertions.assertEquals((Object)"test-documents/testRTF.rtf", (Object)this.tracker.filenames.get(5));
        Assertions.assertEquals((Object)"test-documents/testTXT.txt", (Object)this.tracker.filenames.get(6));
        Assertions.assertEquals((Object)"test-documents/testWORD.doc", (Object)this.tracker.filenames.get(7));
        Assertions.assertEquals((Object)"test-documents/testXML.xml", (Object)this.tracker.filenames.get(8));
        for (String type : this.tracker.mediatypes) {
            Assertions.assertNull((Object)type);
        }
        for (String crt : this.tracker.createdAts) {
            Assertions.assertNull((Object)crt);
        }
        for (String mod : this.tracker.modifiedAts) {
            Assertions.assertNotNull((Object)mod);
            Assertions.assertTrue((boolean)mod.startsWith("20"), (String)("Modified at " + mod));
        }
        String content = handler.toString();
        RarParserTest.assertContains((String)"test-documents/testHTML.html", (String)content);
        RarParserTest.assertContains((String)"test-documents/testEXCEL.xls", (String)content);
        RarParserTest.assertContains((String)"test-documents/testOpenOffice2.odt", (String)content);
        RarParserTest.assertContains((String)"test-documents/testPDF.pdf", (String)content);
        RarParserTest.assertContains((String)"test-documents/testPPT.ppt", (String)content);
        RarParserTest.assertContains((String)"test-documents/testRTF.rtf", (String)content);
        RarParserTest.assertContains((String)"test-documents/testTXT.txt", (String)content);
        RarParserTest.assertContains((String)"test-documents/testWORD.doc", (String)content);
        RarParserTest.assertContains((String)"test-documents/testXML.xml", (String)content);
    }

    @Test
    public void testEncryptedRar() throws Exception {
        RarParser parser = new RarParser();
        try (InputStream input = this.getResourceAsStream("/test-documents/test-documents-enc.rar");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            context.set(PasswordProvider.class, (Object)new PasswordProvider(){

                public String getPassword(Metadata metadata) {
                    return "ApacheTika";
                }
            });
            parser.parse(input, (ContentHandler)handler, metadata, this.trackingContext);
            Assertions.fail((String)"No support yet for Encrypted RAR files");
        }
        catch (EncryptedDocumentException encryptedDocumentException) {
            // empty catch block
        }
    }
}

