/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.pkg.AbstractPkgTest;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ZipParserTest
extends AbstractPkgTest {
    @Test
    public void testEmbedded() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/test-documents.zip");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, this.trackingContext);
        }
        Assertions.assertEquals((int)9, (int)this.tracker.filenames.size());
        Assertions.assertEquals((int)9, (int)this.tracker.mediatypes.size());
        Assertions.assertEquals((int)9, (int)this.tracker.modifiedAts.size());
        Assertions.assertEquals((Object)"testEXCEL.xls", (Object)this.tracker.filenames.get(0));
        Assertions.assertEquals((Object)"testHTML.html", (Object)this.tracker.filenames.get(1));
        Assertions.assertEquals((Object)"testOpenOffice2.odt", (Object)this.tracker.filenames.get(2));
        Assertions.assertEquals((Object)"testPDF.pdf", (Object)this.tracker.filenames.get(3));
        Assertions.assertEquals((Object)"testPPT.ppt", (Object)this.tracker.filenames.get(4));
        Assertions.assertEquals((Object)"testRTF.rtf", (Object)this.tracker.filenames.get(5));
        Assertions.assertEquals((Object)"testTXT.txt", (Object)this.tracker.filenames.get(6));
        Assertions.assertEquals((Object)"testWORD.doc", (Object)this.tracker.filenames.get(7));
        Assertions.assertEquals((Object)"testXML.xml", (Object)this.tracker.filenames.get(8));
        for (String type : this.tracker.mediatypes) {
            Assertions.assertNull((Object)type);
        }
        for (String crt : this.tracker.createdAts) {
            Assertions.assertNull((Object)crt);
        }
        for (String mod : this.tracker.modifiedAts) {
            Assertions.assertNotNull((Object)mod);
            Assertions.assertTrue((boolean)mod.startsWith("20"), (String)("Modified at " + mod));
        }
    }

    @Test
    public void testUnsupportedZipCompressionMethod() throws Exception {
        String content = new Tika().parseToString(this.getResourceAsStream("/test-documents/moby.zip"));
        ZipParserTest.assertContains((String)"README", (String)content);
    }

    @Test
    public void testCustomEncoding() throws Exception {
        ArchiveStreamFactory factory = new ArchiveStreamFactory();
        factory.setEntryEncoding("SJIS");
        this.trackingContext.set(ArchiveStreamFactory.class, (Object)factory);
        try (TikaInputStream stream = TikaInputStream.get((byte[])Base64.decodeBase64((String)"UEsDBBQAAAAIAI+CvUCDo3+zIgAAACgAAAAOAAAAk/qWe4zqg4GDgi50eHRr2tj0qulsc2pzRHN609Gm7Y1OvFxNYLHJv6ZV97yCiQEAUEsBAhQLFAAAAAgAj4K9QIOjf7MiAAAAKAAAAA4AAAAAAAAAAAAgAAAAAAAAAJP6lnuM6oOBg4IudHh0UEsFBgAAAAABAAEAPAAAAE4AAAAAAA=="));){
            AUTO_DETECT_PARSER.parse((InputStream)stream, (ContentHandler)new DefaultHandler(), new Metadata(), this.trackingContext);
        }
        Assertions.assertEquals((int)1, (int)this.tracker.filenames.size());
        Assertions.assertEquals((Object)"\u65e5\u672c\u8a9e\u30e1\u30e2.txt", (Object)this.tracker.filenames.get(0));
    }

    @Test
    public void testQuineRecursiveParserWrapper() throws Exception {
        Assumptions.assumeTrue((ZipParserTest.class.getResourceAsStream("/test-documents/droste.zip") != null ? 1 : 0) != 0);
        this.getRecursiveMetadata("droste.zip");
    }

    @Test
    public void testQuine() {
        Assumptions.assumeTrue((ZipParserTest.class.getResourceAsStream("/test-documents/droste.zip") != null ? 1 : 0) != 0);
        Assertions.assertThrows(TikaException.class, () -> this.getXML("droste.zip"));
    }

    @Test
    public void testZipUsingStoredWithDataDescriptor() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testZip_with_DataDescriptor.zip");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, this.trackingContext);
            Assertions.assertEquals((int)5, (int)this.tracker.filenames.size());
            Assertions.assertEquals((Object)"en0", (Object)this.tracker.filenames.get(0));
            Assertions.assertEquals((Object)"en1", (Object)this.tracker.filenames.get(1));
            Assertions.assertEquals((Object)"en2", (Object)this.tracker.filenames.get(2));
            Assertions.assertEquals((Object)"en3", (Object)this.tracker.filenames.get(3));
            Assertions.assertEquals((Object)"en4", (Object)this.tracker.filenames.get(4));
            Assertions.assertEquals((int)1, (int)this.tracker.lastSeenStart[0]);
            Assertions.assertEquals((int)2, (int)this.tracker.lastSeenStart[1]);
            Assertions.assertEquals((int)3, (int)this.tracker.lastSeenStart[2]);
            Assertions.assertEquals((int)4, (int)this.tracker.lastSeenStart[3]);
        }
    }
}

