/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.envi;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.envi.EnviHeaderParser;
import org.apache.tika.sax.ToXMLContentHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class EnviHeaderParserTest {
    private Parser parser;
    private ToXMLContentHandler handler;
    private Metadata metadata;

    @BeforeEach
    public void setUp() {
        this.setParser((Parser)new EnviHeaderParser());
        this.setHandler(new ToXMLContentHandler());
        this.setMetadata(new Metadata());
    }

    @AfterEach
    public void tearDown() {
        this.setParser(null);
        this.setHandler(null);
        this.setMetadata(null);
    }

    @Test
    public void testParseGlobalMetadata() throws Exception {
        try (InputStream stream = EnviHeaderParser.class.getResourceAsStream("/test-documents/envi_test_header.hdr");){
            Assertions.assertNotNull((Object)stream, (String)"Test ENVI file 'envi_test_header.hdr' not found");
            this.parser.parse(stream, (ContentHandler)this.handler, this.metadata, new ParseContext());
        }
        String content = this.handler.toString();
        TikaTest.assertContains((String)"<body><p>ENVI</p>", (String)content);
        TikaTest.assertContains((String)"<p>samples = 2400</p>", (String)content);
        TikaTest.assertContains((String)"<p>lines   = 2400</p>", (String)content);
        TikaTest.assertContains((String)"<p>map info = {Sinusoidal, 1.5000, 1.5000, -10007091.3643, 5559289.2856, 4.6331271653e+02, 4.6331271653e+02, , units=Meters}</p>", (String)content);
        TikaTest.assertContains((String)"content=\"application/envi.hdr\"", (String)content);
        TikaTest.assertContains((String)"projection info = {16, 6371007.2, 0.000000, 0.0, 0.0, Sinusoidal, units=Meters}", (String)content);
    }

    @Test
    public void testParseGlobalMetadataMultiLineMetadataValues() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)EnviHeaderParserTest.class.getResourceAsStream("/ground-truth/EnviHeaderGroundTruth.txt"), (OutputStream)bos);
        String expected = new String(bos.toByteArray(), StandardCharsets.UTF_8).trim();
        EnviHeaderParser parser = new EnviHeaderParser();
        ToXMLContentHandler handler = new ToXMLContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = EnviHeaderParser.class.getResourceAsStream("/test-documents/ang20150420t182050_corr_v1e_img.hdr");){
            Assertions.assertNotNull((Object)stream, (String)"Test ENVI file 'ang20150420t182050_corr_v1e_img.hdr' not found");
            parser.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        TikaTest.assertContains((String)"<body><p>ENVI</p>", (String)content);
        TikaTest.assertContains((String)"<p>description = {  Georeferenced Image built from input GLT. [Wed Jun 10 04:37:54 2015] [Wed  Jun 10 04:48:52 2015]}</p>", (String)content);
        TikaTest.assertContains((String)"<p>samples = 739</p>", (String)content);
        TikaTest.assertContains((String)"<p>lat/lon = { 36.79077627261556, -108.48370867914815 }</p>", (String)content);
        TikaTest.assertContains((String)"<p>map info = { UTM , 1.000 , 1.000 , 724522.127 , 4074620.759 , 1.1000000000e+00 , 1.1000000000e+00 , 12 , North , WGS-84 , units=Meters , rotation=75.00000000 }</p>", (String)content);
        TikaTest.assertContains((String)expected, (String)content);
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public ToXMLContentHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ToXMLContentHandler handler) {
        this.handler = handler;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

