/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hwpf.converter.NumberFormatter;

public abstract class AbstractListManager {
    private static final String BULLET = "\u00b7";
    protected Map<Integer, ParagraphLevelCounter> listLevelMap = new HashMap<Integer, ParagraphLevelCounter>();
    protected Map<Integer, LevelTuple[]> overrideTupleMap = new HashMap<Integer, LevelTuple[]>();

    protected class LevelTuple {
        private final int start;
        private final int restart;
        private final String lvlText;
        private final String numFmt;
        private final boolean isLegal;

        public LevelTuple(String lvlText) {
            this.lvlText = lvlText;
            this.start = 1;
            this.restart = -1;
            this.numFmt = "decimal";
            this.isLegal = false;
        }

        public LevelTuple(int start, int restart, String lvlText, String numFmt, boolean isLegal) {
            this.start = start;
            this.restart = restart;
            this.lvlText = lvlText;
            this.numFmt = numFmt;
            this.isLegal = isLegal;
        }
    }

    protected class ParagraphLevelCounter {
        private final Integer NOT_SEEN_YET = -1;
        private final Integer FIRST_SKIPPED = -2;
        private final LevelTuple[] levelTuples;
        Pattern LEVEL_INTERPOLATOR = Pattern.compile("%(\\d+)");
        private List<Integer> counts = new ArrayList<Integer>();
        private int lastLevel = -1;

        public ParagraphLevelCounter(LevelTuple[] levelTuples) {
            this.levelTuples = levelTuples;
        }

        public int getNumberOfLevels() {
            return this.levelTuples.length;
        }

        public String incrementLevel(int levelNumber, LevelTuple[] overrideLevelTuples) {
            for (int i = this.lastLevel + 1; i < levelNumber; ++i) {
                if (i >= this.counts.size()) {
                    int val = this.getStart(i, overrideLevelTuples);
                    this.counts.add(i, val);
                    continue;
                }
                int count = this.counts.get(i);
                if (count != this.NOT_SEEN_YET) continue;
                count = this.getStart(i, overrideLevelTuples);
                this.counts.set(i, count);
            }
            if (levelNumber < this.counts.size()) {
                this.resetAfter(levelNumber, overrideLevelTuples);
                int count = this.counts.get(levelNumber);
                count = count == this.NOT_SEEN_YET ? this.getStart(levelNumber, overrideLevelTuples) : ++count;
                this.counts.set(levelNumber, count);
                this.lastLevel = levelNumber;
                return this.format(levelNumber, overrideLevelTuples);
            }
            this.counts.add(levelNumber, this.getStart(levelNumber, overrideLevelTuples));
            this.lastLevel = levelNumber;
            return this.format(levelNumber, overrideLevelTuples);
        }

        private String format(int level, LevelTuple[] overrideLevelTuples) {
            if (level < 0 || level >= this.levelTuples.length) {
                return "";
            }
            boolean isLegal = overrideLevelTuples != null ? overrideLevelTuples[level].isLegal : this.levelTuples[level].isLegal;
            String numFmt = this.getNumFormat(level, isLegal, overrideLevelTuples);
            if ("bullet".equals(numFmt)) {
                return "\u00b7 ";
            }
            String lvlText = overrideLevelTuples == null || overrideLevelTuples[level].lvlText == null ? this.levelTuples[level].lvlText : overrideLevelTuples[level].lvlText;
            StringBuilder sb = new StringBuilder();
            Matcher m = this.LEVEL_INTERPOLATOR.matcher(lvlText);
            int last = 0;
            while (m.find()) {
                sb.append(lvlText.substring(last, m.start()));
                String lvlString = m.group(1);
                int lvlNum = -1;
                try {
                    lvlNum = Integer.parseInt(lvlString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                String numString = "";
                numString = this.formatNum(lvlNum - 1, isLegal, overrideLevelTuples);
                sb.append(numString);
                last = m.end();
            }
            sb.append(lvlText.substring(last));
            if (sb.length() > 0) {
                sb.append(" ");
            }
            return sb.toString();
        }

        private String formatNum(int lvlNum, boolean isLegal, LevelTuple[] overrideLevelTuples) {
            int numFmtStyle = 0;
            String numFmt = this.getNumFormat(lvlNum, isLegal, overrideLevelTuples);
            int count = this.getCount(lvlNum);
            if (count < 0) {
                count = 1;
            }
            if ("lowerLetter".equals(numFmt)) {
                numFmtStyle = 4;
            } else if ("lowerRoman".equals(numFmt)) {
                numFmtStyle = 2;
            } else if ("decimal".equals(numFmt)) {
                numFmtStyle = 0;
            } else if ("upperLetter".equals(numFmt)) {
                numFmtStyle = 3;
            } else if ("upperRoman".equals(numFmt)) {
                numFmtStyle = 1;
            } else {
                if ("bullet".equals(numFmt)) {
                    return "";
                }
                if ("ordinal".equals(numFmt)) {
                    return this.ordinalize(count);
                }
                if ("decimalZero".equals(numFmt)) {
                    return "0" + NumberFormatter.getNumber((int)count, (int)0);
                }
                if ("none".equals(numFmt)) {
                    return "";
                }
            }
            try {
                return NumberFormatter.getNumber((int)count, (int)numFmtStyle);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        }

        private String ordinalize(int count) {
            String countString = Integer.toString(count);
            if (countString.endsWith("1")) {
                return countString + "st";
            }
            if (countString.endsWith("2")) {
                return countString + "nd";
            }
            if (countString.endsWith("3")) {
                return countString + "rd";
            }
            return countString + "th";
        }

        private String getNumFormat(int lvlNum, boolean isLegal, LevelTuple[] overrideLevelTuples) {
            if (lvlNum < 0 || lvlNum >= this.levelTuples.length) {
                return "decimal";
            }
            if (isLegal) {
                return "decimal";
            }
            return overrideLevelTuples == null || overrideLevelTuples[lvlNum].numFmt == null ? this.levelTuples[lvlNum].numFmt : overrideLevelTuples[lvlNum].numFmt;
        }

        private int getCount(int lvlNum) {
            if (lvlNum < 0 || lvlNum >= this.counts.size()) {
                return 1;
            }
            return this.counts.get(lvlNum);
        }

        private void resetAfter(int startlevelNumber, LevelTuple[] overrideLevelTuples) {
            for (int levelNumber = startlevelNumber + 1; levelNumber < this.counts.size(); ++levelNumber) {
                int cnt = this.counts.get(levelNumber);
                if (cnt == this.NOT_SEEN_YET || cnt == this.FIRST_SKIPPED) continue;
                if (this.levelTuples.length > levelNumber) {
                    int restart;
                    int n = restart = overrideLevelTuples == null || overrideLevelTuples[levelNumber].restart < 0 ? this.levelTuples[levelNumber].restart : overrideLevelTuples[levelNumber].restart;
                    if (restart == 0) {
                        return;
                    }
                    if (restart != -1 && startlevelNumber > restart - 1) continue;
                    this.counts.set(levelNumber, this.NOT_SEEN_YET);
                    continue;
                }
                this.counts.set(levelNumber, this.NOT_SEEN_YET);
            }
        }

        private int getStart(int levelNumber, LevelTuple[] overrideLevelTuples) {
            if (levelNumber >= this.levelTuples.length) {
                return 1;
            }
            return overrideLevelTuples == null || overrideLevelTuples[levelNumber].start < 0 ? this.levelTuples[levelNumber].start : overrideLevelTuples[levelNumber].start;
        }
    }
}

