/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.Serializable;
import org.apache.tika.exception.AccessPermissionException;
import org.apache.tika.metadata.AccessPermissions;
import org.apache.tika.metadata.Metadata;

public class AccessChecker
implements Serializable {
    private static final long serialVersionUID = 6492570218190936986L;
    private final boolean needToCheck;
    private final boolean allowAccessibility;

    public AccessChecker() {
        this.needToCheck = false;
        this.allowAccessibility = true;
    }

    public AccessChecker(boolean allowExtractionForAccessibility) {
        this.needToCheck = true;
        this.allowAccessibility = allowExtractionForAccessibility;
    }

    public void check(Metadata metadata) throws AccessPermissionException {
        if (!this.needToCheck) {
            return;
        }
        if ("false".equals(metadata.get(AccessPermissions.EXTRACT_CONTENT))) {
            if (this.allowAccessibility) {
                if ("true".equals(metadata.get(AccessPermissions.EXTRACT_FOR_ACCESSIBILITY))) {
                    return;
                }
                throw new AccessPermissionException("Content extraction for accessibility is not allowed.");
            }
            throw new AccessPermissionException("Content extraction is not allowed.");
        }
    }
}

