/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.transcribe.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompressionType;
import com.amazonaws.services.s3.model.ExpressionType;
import com.amazonaws.services.s3.model.InputSerialization;
import com.amazonaws.services.s3.model.JSONInput;
import com.amazonaws.services.s3.model.JSONOutput;
import com.amazonaws.services.s3.model.JSONType;
import com.amazonaws.services.s3.model.OutputSerialization;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.SelectObjectContentEvent;
import com.amazonaws.services.s3.model.SelectObjectContentEventVisitor;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.SelectRecordsInputStream;
import com.amazonaws.services.transcribe.AmazonTranscribeAsync;
import com.amazonaws.services.transcribe.AmazonTranscribeAsyncClientBuilder;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.LanguageCode;
import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.TranscriptionJob;
import com.amazonaws.services.transcribe.model.TranscriptionJobStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AmazonTranscribe
extends AbstractParser
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonTranscribe.class);
    private AmazonTranscribeAsync amazonTranscribeAsync;
    private AmazonS3 amazonS3;
    private String bucketName;
    private String region;
    private boolean isAvailable;
    private String clientId;
    private String clientSecret;
    private AWSStaticCredentialsProvider credsProvider;
    protected static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.audio((String)"x-flac"), MediaType.audio((String)"mp3"), MediaType.audio((String)"mpeg"), MediaType.video((String)"ogg"), MediaType.audio((String)"vnd.wave"), MediaType.audio((String)"mp4"), MediaType.video((String)"mp4"), MediaType.application((String)"mp4"), MediaType.video((String)"quicktime"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        if (!this.isAvailable) {
            return Collections.EMPTY_SET;
        }
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!this.isAvailable) {
            return;
        }
        String jobName = this.getJobKey();
        LanguageCode languageCode = (LanguageCode)context.get(LanguageCode.class);
        this.uploadFileToBucket(stream, jobName);
        StartTranscriptionJobRequest startTranscriptionJobRequest = new StartTranscriptionJobRequest();
        Media media = new Media();
        media.setMediaFileUri(this.amazonS3.getUrl(this.bucketName, jobName).toString());
        startTranscriptionJobRequest.withMedia(media).withOutputBucketName(this.bucketName).withTranscriptionJobName(jobName).setRequestCredentialsProvider((AWSCredentialsProvider)this.credsProvider);
        if (languageCode != null) {
            startTranscriptionJobRequest.withLanguageCode(languageCode);
        } else {
            startTranscriptionJobRequest.withIdentifyLanguage(Boolean.valueOf(true));
        }
        this.amazonTranscribeAsync.startTranscriptionJob(startTranscriptionJobRequest);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        String text = this.getTranscriptText(jobName);
        xhtml.startElement("p");
        xhtml.characters(text);
        xhtml.endElement("p");
        xhtml.endDocument();
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Field
    public void setClientId(String id) {
        this.clientId = id;
        this.isAvailable = this.checkAvailable();
    }

    @Field
    public void setClientSecret(String secret) {
        this.clientSecret = secret;
        this.isAvailable = this.checkAvailable();
    }

    @Field
    public void setBucket(String bucket) {
        this.bucketName = bucket;
        this.isAvailable = this.checkAvailable();
    }

    @Field
    public void setRegion(String region) {
        this.region = region;
        this.isAvailable = this.checkAvailable();
    }

    private boolean checkAvailable() {
        return this.clientId != null && this.clientSecret != null && this.bucketName != null;
    }

    private String getJobKey() {
        return UUID.randomUUID().toString();
    }

    private void uploadFileToBucket(InputStream inputStream, String jobName) throws TikaException {
        PutObjectRequest request = new PutObjectRequest(this.bucketName, jobName, inputStream, null);
        try {
            PutObjectResult putObjectResult = this.amazonS3.putObject(request);
        }
        catch (SdkClientException e) {
            throw new TikaException("File Upload to AWS Failed");
        }
    }

    private String getTranscriptText(String fileNameS3) throws AmazonServiceException, SdkClientException, IOException {
        TranscriptionJob transcriptionJob = this.retrieveObjectWhenJobCompleted(fileNameS3);
        String text = null;
        if (transcriptionJob != null && !TranscriptionJobStatus.FAILED.name().equals(transcriptionJob.getTranscriptionJobStatus())) {
            InputSerialization inputSerialization = new InputSerialization().withJson(new JSONInput().withType(JSONType.DOCUMENT)).withCompressionType(CompressionType.NONE);
            OutputSerialization outputSerialization = new OutputSerialization().withJson(new JSONOutput());
            SelectObjectContentRequest request = (SelectObjectContentRequest)new SelectObjectContentRequest().withBucketName(this.bucketName).withKey(fileNameS3 + ".json").withExpression("Select s.results.transcripts[0].transcript from S3Object s").withExpressionType(ExpressionType.SQL).withRequestCredentialsProvider((AWSCredentialsProvider)this.credsProvider);
            request.setInputSerialization(inputSerialization);
            request.setOutputSerialization(outputSerialization);
            final AtomicBoolean isResultComplete = new AtomicBoolean(false);
            try (SelectObjectContentResult result = this.amazonS3.selectObjectContent(request);){
                SelectRecordsInputStream resultInputStream = result.getPayload().getRecordsInputStream(new SelectObjectContentEventVisitor(){

                    public void visit(SelectObjectContentEvent.StatsEvent event) {
                        LOG.debug("Received Stats, Bytes Scanned: " + event.getDetails().getBytesScanned() + " Bytes Processed: " + event.getDetails().getBytesProcessed());
                    }

                    public void visit(SelectObjectContentEvent.EndEvent event) {
                        isResultComplete.set(true);
                        LOG.debug("Received End Event. Result is complete.");
                    }
                });
                text = new BufferedReader(new InputStreamReader((InputStream)resultInputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            }
            if (!isResultComplete.get()) {
                throw new IOException("S3 Select request was incomplete as End Event was not received.");
            }
        }
        JSONParser parser = new JSONParser();
        JSONObject obj = null;
        try {
            obj = (JSONObject)parser.parse(text);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
        return obj.get((Object)"transcript").toString();
    }

    private TranscriptionJob retrieveObjectWhenJobCompleted(String jobName) {
        GetTranscriptionJobResult innerResult;
        String status;
        GetTranscriptionJobRequest getTranscriptionJobRequest = new GetTranscriptionJobRequest();
        getTranscriptionJobRequest.withRequestCredentialsProvider((AWSCredentialsProvider)this.credsProvider);
        getTranscriptionJobRequest.setTranscriptionJobName(jobName);
        do {
            innerResult = this.amazonTranscribeAsync.getTranscriptionJob(getTranscriptionJobRequest);
            status = innerResult.getTranscriptionJob().getTranscriptionJobStatus();
        } while (!TranscriptionJobStatus.COMPLETED.name().equals(status) && !TranscriptionJobStatus.FAILED.name().equals(status));
        return innerResult.getTranscriptionJob();
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        if (!this.checkAvailable()) {
            return;
        }
        try {
            BasicAWSCredentials creds = new BasicAWSCredentials(this.clientId, this.clientSecret);
            this.credsProvider = new AWSStaticCredentialsProvider((AWSCredentials)creds);
            this.amazonS3 = this.region != null ? (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credsProvider)).withRegion(this.region)).build() : (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credsProvider)).build();
            if (!this.amazonS3.doesBucketExistV2(this.bucketName)) {
                try {
                    this.amazonS3.createBucket(this.bucketName);
                }
                catch (AmazonS3Exception e) {
                    throw new TikaConfigException("couldn't create bucket", (Throwable)e);
                }
            }
            this.amazonTranscribeAsync = (AmazonTranscribeAsync)((AmazonTranscribeAsyncClientBuilder)((AmazonTranscribeAsyncClientBuilder)AmazonTranscribeAsyncClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credsProvider)).withRegion(this.region)).build();
        }
        catch (Exception e) {
            LOG.warn("Exception reading config file", (Throwable)e);
            this.isAvailable = false;
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        this.isAvailable = this.checkAvailable();
    }
}

