/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class StoreBase
extends LifecycleBase
implements Store {
    protected static final String storeName = "StoreBase";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.session");
    protected Manager manager;

    public String getStoreName() {
        return storeName;
    }

    @Override
    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void processExpires() {
        String[] keys = null;
        if (!this.getState().isAvailable()) {
            return;
        }
        try {
            keys = this.keys();
        }
        catch (IOException e) {
            this.manager.getContext().getLogger().error((Object)"Error getting keys", (Throwable)e);
            return;
        }
        if (this.manager.getContext().getLogger().isDebugEnabled()) {
            this.manager.getContext().getLogger().debug((Object)(this.getStoreName() + ": processExpires check number of " + keys.length + " sessions"));
        }
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < keys.length; ++i) {
            try {
                int timeIdle;
                StandardSession session = (StandardSession)this.load(keys[i]);
                if (session == null || (timeIdle = (int)((timeNow - session.getThisAccessedTime()) / 1000L)) < session.getMaxInactiveInterval()) continue;
                if (this.manager.getContext().getLogger().isDebugEnabled()) {
                    this.manager.getContext().getLogger().debug((Object)(this.getStoreName() + ": processExpires expire store session " + keys[i]));
                }
                boolean isLoaded = false;
                if (this.manager instanceof PersistentManagerBase) {
                    isLoaded = ((PersistentManagerBase)this.manager).isLoaded(keys[i]);
                } else {
                    try {
                        if (this.manager.findSession(keys[i]) != null) {
                            isLoaded = true;
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (isLoaded) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(keys[i]);
                continue;
            }
            catch (Exception e) {
                this.manager.getContext().getLogger().error((Object)("Session: " + keys[i] + "; "), (Throwable)e);
                try {
                    this.remove(keys[i]);
                    continue;
                }
                catch (IOException e2) {
                    this.manager.getContext().getLogger().error((Object)"Error removing key", (Throwable)e2);
                }
            }
        }
    }

    @Override
    protected void initInternal() {
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected void destroyInternal() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.manager == null) {
            sb.append("Manager is null");
        } else {
            sb.append(this.manager);
        }
        sb.append(']');
        return sb.toString();
    }
}

