/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.LocalClientState;

public class ThreadLocalClientState
implements ClientState {
    private Map<Thread, LocalClientState> state = Collections.synchronizedMap(new WeakHashMap());
    private LocalClientState initialState;
    private Map<Thread, Long> checkpointMap;
    private long timeToKeepState;

    public ThreadLocalClientState(String baseURI) {
        this(baseURI, Collections.emptyMap());
    }

    public ThreadLocalClientState(String baseURI, Map<String, Object> properties) {
        this.initialState = new LocalClientState(URI.create(baseURI), properties);
    }

    public ThreadLocalClientState(String baseURI, long timeToKeepState) {
        this(baseURI, timeToKeepState, Collections.emptyMap());
    }

    public ThreadLocalClientState(String baseURI, long timeToKeepState, Map<String, Object> properties) {
        this.initialState = new LocalClientState(URI.create(baseURI), properties);
        this.timeToKeepState = timeToKeepState;
    }

    public ThreadLocalClientState(LocalClientState initialState, long timeToKeepState) {
        this.initialState = initialState;
        this.timeToKeepState = timeToKeepState;
    }

    @Override
    public void setCurrentBuilder(UriBuilder currentBuilder) {
        this.getState().setCurrentBuilder(currentBuilder);
    }

    @Override
    public UriBuilder getCurrentBuilder() {
        return this.getState().getCurrentBuilder();
    }

    @Override
    public void setBaseURI(URI baseURI) {
        this.getState().setBaseURI(baseURI);
    }

    @Override
    public URI getBaseURI() {
        return this.getState().getBaseURI();
    }

    @Override
    public void setResponse(Response response) {
        this.getState().setResponse(response);
    }

    @Override
    public Response getResponse() {
        return this.getState().getResponse();
    }

    @Override
    public void setRequestHeaders(MultivaluedMap<String, String> requestHeaders) {
        this.getState().setRequestHeaders(requestHeaders);
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.getState().getRequestHeaders();
    }

    @Override
    public MultivaluedMap<String, String> getTemplates() {
        return this.getState().getTemplates();
    }

    @Override
    public void setTemplates(MultivaluedMap<String, String> map) {
        this.getState().setTemplates(map);
    }

    @Override
    public void reset() {
        this.removeThreadLocalState(Thread.currentThread());
    }

    @Override
    public ClientState newState(URI currentURI, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> templates) {
        LocalClientState ls = (LocalClientState)this.getState().newState(currentURI, headers, templates);
        return new ThreadLocalClientState(ls, this.timeToKeepState);
    }

    @Override
    public ClientState newState(URI currentURI, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> templates, Map<String, Object> properties) {
        LocalClientState ls = (LocalClientState)this.getState().newState(currentURI, headers, templates, properties);
        return new ThreadLocalClientState(ls, this.timeToKeepState);
    }

    private void removeThreadLocalState(Thread t) {
        this.state.remove(t);
        if (this.checkpointMap != null) {
            this.checkpointMap.remove(t);
        }
    }

    protected ClientState getState() {
        LocalClientState cs = this.state.get(Thread.currentThread());
        if (cs == null) {
            cs = new LocalClientState(this.initialState);
            this.state.put(Thread.currentThread(), cs);
            if (this.timeToKeepState > 0L) {
                this.prepareCheckpointMap();
                long currentTime = System.currentTimeMillis();
                this.checkpointMap.put(Thread.currentThread(), currentTime);
                CleanupThread clThread = new CleanupThread(Thread.currentThread(), currentTime);
                clThread.setName("Client state cleanup thread " + clThread.hashCode());
                clThread.start();
            }
        }
        return cs;
    }

    public void setTimeToKeepState(long timeToKeepState) {
        this.timeToKeepState = timeToKeepState;
        if (timeToKeepState > 0L) {
            this.prepareCheckpointMap();
        }
    }

    private void prepareCheckpointMap() {
        if (this.checkpointMap == null) {
            this.checkpointMap = new ConcurrentHashMap<Thread, Long>();
        }
    }

    private class CleanupThread
    extends Thread {
        private Thread thread;
        private long originalTime;

        CleanupThread(Thread thread, long originalTime) {
            this.thread = thread;
            this.originalTime = originalTime;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(ThreadLocalClientState.this.timeToKeepState);
                long actualTime = (Long)ThreadLocalClientState.this.checkpointMap.get(this.thread);
                if (actualTime == this.originalTime) {
                    ThreadLocalClientState.this.removeThreadLocalState(this.thread);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

