/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.Handler;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class BaseHandlerChainBuilder {
    private static final String HANDLER_CHAINS_E = "handler-chains";
    private static final String HANDLER_CHAIN_E = "handler-chain";
    private final ResourceBundle bundle;
    private final URL handlerFileURL;

    protected BaseHandlerChainBuilder(ResourceBundle bundle, URL handlerFileURL) {
        this.bundle = bundle;
        this.handlerFileURL = handlerFileURL;
    }

    protected List<Handler> build(String namespace, Element el, QName portQName, QName serviceQName, String bindingID) {
        if (!HANDLER_CHAINS_E.equals(el.getLocalName())) {
            String xml = StaxUtils.toString(el);
            throw new WebServiceException(BundleUtils.getFormattedString(this.bundle, "NOT_VALID_ROOT_ELEMENT", namespace.equals(el.getNamespaceURI()), HANDLER_CHAINS_E.equals(el.getLocalName()), xml, this.handlerFileURL));
        }
        ArrayList<Handler> chain = new ArrayList<Handler>();
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            el = (Element)node;
            if (!namespace.equals(el.getNamespaceURI())) {
                throw new WebServiceException(BundleUtils.getFormattedString(this.bundle, "NOT_VALID_NAMESPACE", el.getNamespaceURI()));
            }
            if (!HANDLER_CHAIN_E.equals(el.getLocalName())) {
                String xml = StaxUtils.toString(el);
                throw new WebServiceException(BundleUtils.getFormattedString(this.bundle, "NOT_VALID_ELEMENT_IN_HANDLER", xml));
            }
            this.processHandlerChainElement(namespace, el, chain, portQName, serviceQName, bindingID);
        }
        return chain;
    }

    private void processHandlerChainElement(String namespace, Element el, List<Handler> chain, QName portQName, QName serviceQName, String bindingID) {
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node cur = node;
            if (!(cur instanceof Element)) continue;
            el = (Element)cur;
            if (!namespace.equals(el.getNamespaceURI())) {
                String xml = StaxUtils.toString(el);
                throw new WebServiceException(BundleUtils.getFormattedString(this.bundle, "NOT_VALID_ELEMENT_IN_HANDLER", xml));
            }
            String name = el.getLocalName();
            if ("port-name-pattern".equals(name)) {
                if (this.patternMatches(el, portQName)) continue;
                return;
            }
            if ("service-name-pattern".equals(name)) {
                if (this.patternMatches(el, serviceQName)) continue;
                return;
            }
            if (!"protocol-bindings".equals(name)) continue;
            if (this.protocolMatches(el, bindingID)) continue;
            return;
        }
    }

    private boolean protocolMatches(Element el, String id) {
        if (id == null) {
            return true;
        }
        String name = el.getTextContent().trim();
        StringTokenizer st = new StringTokenizer(name, " ", false);
        boolean result = false;
        while (st.hasMoreTokens() && !result) {
            result = result || this.singleProtocolMatches(st.nextToken(), id);
        }
        return result;
    }

    private boolean singleProtocolMatches(String name, String id) {
        if ("##SOAP11_HTTP".equals(name)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http".contains(id) || "http://schemas.xmlsoap.org/soap/".contains(id);
        }
        if ("##SOAP11_HTTP_MTOM".equals(name)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".contains(id) || "http://schemas.xmlsoap.org/soap/?mtom=true".contains(id);
        }
        if ("##SOAP12_HTTP".equals(name)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/".contains(id) || "http://schemas.xmlsoap.org/wsdl/soap12/".contains(id);
        }
        if ("##SOAP12_HTTP_MTOM".equals(name)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".contains(id) || "http://schemas.xmlsoap.org/wsdl/soap12/?mtom=true".contains(id);
        }
        if ("##XML_HTTP".equals(name)) {
            name = "http://www.w3.org/2004/08/wsdl/http";
        }
        return name.contains(id);
    }

    private boolean patternMatches(Element el, QName comp) {
        if (comp == null) {
            return true;
        }
        String namePattern = el.getTextContent().trim();
        if ("*".equals(namePattern)) {
            return true;
        }
        int idx = namePattern.indexOf(58);
        if (idx < 0) {
            String xml = StaxUtils.toString(el);
            throw new WebServiceException(BundleUtils.getFormattedString(this.bundle, "NOT_A_QNAME_PATTER", namePattern, xml));
        }
        String pfx = namePattern.substring(0, idx);
        String ns = el.lookupNamespaceURI(pfx);
        if (ns == null) {
            ns = pfx;
        }
        if (!ns.equals(comp.getNamespaceURI())) {
            return false;
        }
        String localPart = namePattern.substring(idx + 1, namePattern.length());
        if (localPart.contains("*")) {
            return Pattern.matches(this.mapPattern(localPart), comp.getLocalPart());
        }
        return localPart.equals(comp.getLocalPart());
    }

    private String mapPattern(String s) {
        StringBuilder buf = new StringBuilder(s);
        block4: for (int x = 0; x < buf.length(); ++x) {
            switch (buf.charAt(x)) {
                case '*': {
                    buf.insert(x, '.');
                    ++x;
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '\\': 
                case '^': 
                case '{': 
                case '}': {
                    buf.insert(x, '\\');
                    ++x;
                    continue block4;
                }
            }
        }
        return buf.toString();
    }

    abstract void processHandlerElement(Element var1, List<Handler> var2);
}

