/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.entity.cmp.ComplexCmpHome;
import org.apache.openejb.test.entity.cmp2.ComplexCmp2TestClient;

public class Complex2RemoteIntfcTests
extends ComplexCmp2TestClient {
    public Complex2RemoteIntfcTests() {
        super("RemoteIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp2/ComplexCmpHome");
        this.ejbHome = (ComplexCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Forth Bean");
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            Complex2RemoteIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            Complex2RemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            Complex2RemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        Complex2RemoteIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            Complex2RemoteIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            Complex2RemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            Complex2RemoteIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            Complex2RemoteIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            Complex2RemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        Complex2RemoteIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void BUG_test05_invokeAfterSystemException() {
        try {
            this.ejbObject.businessMethod("This refernce is invalid");
            Complex2RemoteIntfcTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Throwable e) {
            Complex2RemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

