/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import java.util.ArrayList;
import java.util.Map;
import org.apache.openejb.test.singleton.BasicSingletonInterceptedRemote;
import org.apache.openejb.test.singleton.BasicSingletonLocalTestClient;

public class SingletonInterceptorTests
extends BasicSingletonLocalTestClient {
    private BasicSingletonInterceptedRemote remoteInterceptor;

    public SingletonInterceptorTests() {
        super("BasicSingletonIntercepted.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("BasicSingletonInterceptedBusinessRemote");
        SingletonInterceptorTests.assertNotNull((String)"The BasicSingletonInterceptedBusinessRemote object is null", (Object)obj);
        this.remoteInterceptor = (BasicSingletonInterceptedRemote)obj;
        SingletonInterceptorTests.assertNotNull((String)"Remote interceptor is null", (Object)this.remoteInterceptor);
    }

    public void test01_interceptorChaining() {
        String reverseMe = "Intercept";
        String reversedString = this.remoteInterceptor.reverse("Intercept");
        SingletonInterceptorTests.assertEquals((Object)"tpecretnI", (Object)reversedString);
        Map contextData = this.remoteInterceptor.getContextData();
        SingletonInterceptorTests.assertNotNull((Object)contextData.containsKey("reverse"));
        Map innerMap = (Map)contextData.get("reverse");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        SingletonInterceptorTests.assertEquals((Object)"ddInterceptor", interceptorsList.get(0));
        SingletonInterceptorTests.assertEquals((Object)"secondClassInterceptor", interceptorsList.get(1));
        SingletonInterceptorTests.assertEquals((Object)"superClassInterceptor", interceptorsList.get(2));
        SingletonInterceptorTests.assertEquals((Object)"classInterceptor", interceptorsList.get(3));
        SingletonInterceptorTests.assertEquals((Object)"methodInterceptor", interceptorsList.get(4));
        SingletonInterceptorTests.assertEquals((Object)"superBeanInterceptor", interceptorsList.get(5));
        SingletonInterceptorTests.assertEquals((Object)"inBeanInterceptor", interceptorsList.get(6));
    }

    public void test02_methodProfile() {
        String reverseMe = "Intercept";
        String reversedString = this.remoteInterceptor.reverse("Intercept");
        SingletonInterceptorTests.assertEquals((Object)"tpecretnI", (Object)reversedString);
        Map contextData = this.remoteInterceptor.getContextData();
        SingletonInterceptorTests.assertTrue((boolean)contextData.containsKey("reverse"));
        Map innerMap = (Map)contextData.get("reverse");
        Object[] params = (Object[])innerMap.get("PARAMETERS");
        SingletonInterceptorTests.assertNotNull((String)"value of PARAMETERS key is null", (Object)params);
        SingletonInterceptorTests.assertEquals((long)1L, (long)params.length);
        SingletonInterceptorTests.assertEquals((Object)"Intercept", (Object)params[0].toString());
    }

    public void test03_excludeClassInterceptors() {
        Map contextData = this.remoteInterceptor.getContextData();
        SingletonInterceptorTests.assertNotNull((Object)contextData.containsKey("getContextData"));
        Map innerMap = (Map)contextData.get("getContextData");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        SingletonInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        SingletonInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        SingletonInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by secondClassInterceptor()", (boolean)interceptorsList.contains("secondClassInterceptor"));
        SingletonInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by ddInterceptor()", (boolean)interceptorsList.contains("ddInterceptor"));
    }

    public void test04_excludeClassInterceptors_02() {
        String catString = this.remoteInterceptor.concat("Inter", "cept");
        SingletonInterceptorTests.assertEquals((Object)"Intercept", (Object)catString);
        Map contextData = this.remoteInterceptor.getContextData();
        SingletonInterceptorTests.assertNotNull((Object)contextData.containsKey("concat"));
        Map innerMap = (Map)contextData.get("concat");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        SingletonInterceptorTests.assertFalse((String)"concat() should not have been intercepted by superClassInterceptor()", (boolean)interceptorsList.contains("superClassInterceptor"));
        SingletonInterceptorTests.assertFalse((String)"concat() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        SingletonInterceptorTests.assertFalse((String)"concat() should not have been intercepted by ddInterceptor()", (boolean)interceptorsList.contains("ddInterceptor"));
        SingletonInterceptorTests.assertFalse((String)"concat() should not have been intercepted by secondClassInterceptor()", (boolean)interceptorsList.contains("secondClassInterceptor"));
    }
}

