/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import org.apache.openejb.test.beans.TimerSync;
import org.apache.openejb.test.object.OperationsPolicy;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;

public class BMTStatelessAllowedOperationsTests
extends BasicStatelessTestClient {
    protected TimerSync timerSync;

    public BMTStatelessAllowedOperationsTests() {
        super("BMTAllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BeanManagedBasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)obj;
        this.ejbObject = this.ejbHome.createObject();
        this.ejbHandle = this.ejbObject.getHandle();
        this.timerSync = (TimerSync)this.initialContext.lookup("TimerSyncBeanBusinessRemote");
        this.ejbObject.businessMethod("let's go!");
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test05_ejbTimeout() {
        try {
            this.ejbObject.scheduleTimer("BmtStatelessAllowedOperationsTests");
            this.timerSync.waitFor("BmtStatelessAllowedOperationsTests");
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbTimeout");
            BMTStatelessAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTStatelessAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTStatelessAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

