/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import java.rmi.RemoteException;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessObject;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessPojoEjbObjectTests
extends BasicStatelessTestClient {
    public StatelessPojoEjbObjectTests() {
        super("PojoEJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessPojoHome");
        this.ejbHome = (BasicStatelessHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    public void test01_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            StatelessPojoEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            StatelessPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            StatelessPojoEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            StatelessPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        BasicStatelessObject otherEJBObject = null;
        try {
            otherEJBObject = this.ejbHome.createObject();
            StatelessPojoEjbObjectTests.assertTrue((String)"The EJBObjects are not identical", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
            StatelessPojoEjbObjectTests.assertTrue((String)"The EJBObject and the OtherEJBObject are not identical", (boolean)this.ejbObject.isIdentical((EJBObject)otherEJBObject));
        }
        catch (Exception e) {
            StatelessPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_remove() {
        try {
            this.ejbObject.remove();
            this.ejbObject.businessMethod("Should not throw an exception");
        }
        catch (Exception e) {
            StatelessPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_getPrimaryKey() {
        try {
            Object object = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            StatelessPojoEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            StatelessPojoEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessPojoEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }
}

