/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.catalina.startup.Catalina;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.tomee.bootstrap.Archive;
import org.apache.tomee.bootstrap.Ports;

public class Server {
    private static final Log log = LogFactory.getLog(Server.class);
    private final File home;
    private final URI uri;

    public Server(File home, int port) {
        this.home = home;
        this.uri = URI.create("http://localhost:" + port);
    }

    public URI getURI() {
        return this.uri;
    }

    public File getHome() {
        return this.home;
    }

    private static void cp(File conf, String resource) {
        try {
            URL url = Server.resolve(resource);
            IO.copy((InputStream)IO.read((URL)url), (File)new File(conf, resource));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static URL resolve(String resource) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = loader.getResources("tomee/conf/" + resource);
        ArrayList<URL> list = Collections.list(resources);
        if (list.size() == 0) {
            throw new MissingResourceException(resource);
        }
        if (list.size() == 1) {
            return (URL)list.get(0);
        }
        Server.sort(list);
        return (URL)list.get(0);
    }

    public static void sort(List<URL> list) {
        Collections.sort(list, Server::compare);
    }

    private static int compare(URL o1, URL o2) {
        String a = o1.toExternalForm();
        String b = o2.toExternalForm();
        int modifier = 0;
        if (a.contains("tomee-bootstrap")) {
            modifier += 1000;
        }
        if (b.contains("tomee-bootstrap")) {
            modifier -= 1000;
        }
        return a.compareTo(b) + modifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int httpPort;
        private int shutdownPort;
        private int ajpPort;
        protected final ArrayList<Consumer<File>> homeConsumers = new ArrayList();
        protected final ArrayList<Consumer<Builder>> builderConsumers = new ArrayList();
        protected final Archive modifications = Archive.archive();

        public Builder httpPort(int port) {
            this.httpPort = port;
            return this;
        }

        public Builder ajpPort(int port) {
            this.ajpPort = port;
            return this;
        }

        public Builder shutdownPort(int port) {
            this.shutdownPort = port;
            return this;
        }

        public Builder add(String destinationPath, byte[] bytes) {
            this.modifications.add(destinationPath, bytes);
            return this;
        }

        public Builder add(String destinationPath, Supplier<byte[]> content) {
            this.modifications.add(destinationPath, content);
            return this;
        }

        public Builder add(String destinationPath, String content) {
            this.modifications.add(destinationPath, content);
            return this;
        }

        public Builder add(String destinationPath, File content) {
            this.modifications.add(destinationPath, content);
            return this;
        }

        public Builder add(String name, Archive contents) {
            this.modifications.add(name, contents);
            return this;
        }

        public Builder home(Consumer<File> customization) {
            this.homeConsumers.add(customization);
            return this;
        }

        public Builder and(Consumer<Builder> consumer) {
            this.builderConsumers.add(consumer);
            return this;
        }

        protected void applyHomeConsumers(File home) {
            for (Consumer<File> customization : this.homeConsumers) {
                customization.accept(home);
            }
        }

        protected void applyModifications(File home) {
            try {
                this.modifications.toDir(home);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to apply home modifications to " + home.getAbsolutePath(), e);
            }
        }

        protected void applyBuilderConsumers() {
            for (Consumer<Builder> consumer : this.builderConsumers) {
                consumer.accept(this);
            }
        }

        public Server build() {
            long start = System.currentTimeMillis();
            this.applyBuilderConsumers();
            File home = Files.mkdir((File)Files.tmpdir(), (String)"apache-tomee");
            File conf = Files.mkdir((File)home, (String)"conf");
            File logs = Files.mkdir((File)home, (String)"logs");
            File webapps = Files.mkdir((File)home, (String)"webapps");
            Server.cp(conf, "catalina.policy");
            Server.cp(conf, "catalina.properties");
            Server.cp(conf, "context.xml");
            Server.cp(conf, "jaspic-providers.xml");
            Server.cp(conf, "jaspic-providers.xsd");
            Server.cp(conf, "logging.properties");
            Server.cp(conf, "server.xml");
            Server.cp(conf, "system.properties");
            Server.cp(conf, "tomcat-users.xml");
            Server.cp(conf, "tomcat-users.xsd");
            Server.cp(conf, "tomee.xml");
            Server.cp(conf, "web.xml");
            this.applyModifications(home);
            Iterator<Integer> ports = Ports.allocate(3).iterator();
            int http = this.httpPort > 0 ? this.httpPort : ports.next();
            int shutdown = this.shutdownPort > 0 ? this.shutdownPort : ports.next();
            int ajp = this.ajpPort > 0 ? this.ajpPort : ports.next();
            try {
                File serverxml = new File(conf, "server.xml");
                String content = this.setPorts(http, shutdown, ajp).andThen(this::addServerListener).andThen(this::setUtilityThreadsAsDaemon).apply(IO.slurp((File)serverxml));
                IO.copy((InputStream)IO.read((String)content), (File)serverxml);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to modify server.xml", e);
            }
            this.applyHomeConsumers(home);
            System.setProperty("catalina.home", home.getAbsolutePath());
            System.setProperty("catalina.base", home.getAbsolutePath());
            URLClassLoader loader = new URLClassLoader(new URL[0], Server.class.getClassLoader());
            Catalina catalina = new Catalina();
            catalina.setParentClassLoader((ClassLoader)loader);
            catalina.setAwait(false);
            catalina.load();
            catalina.start();
            long elapsed = System.currentTimeMillis() - start;
            String message = "Full bootstrap in [" + elapsed + "] milliseconds";
            log.info((Object)message);
            return new Server(home, http);
        }

        private Function<String, String> setPorts(int http, int shutdown, int ajp) {
            return s -> s.replace("8080", "" + http).replace("8005", "" + shutdown).replace("8009", "" + ajp);
        }

        private String setUtilityThreadsAsDaemon(String serverXml) {
            return serverXml.replace("utilityThreadsAsDaemon=\"true\"", "").replace("utilityThreadsAsDaemon=\"false\"", "").replace("shutdown=\"SHUTDOWN\"", "shutdown=\"SHUTDOWN\" utilityThreadsAsDaemon=\"true\"");
        }

        private String addServerListener(String serverXml) {
            if (serverXml.contains("<Listener className=\"org.apache.tomee.catalina.ServerListener\"")) {
                return serverXml;
            }
            return serverXml.replaceFirst("<Listener ", "<Listener className=\"org.apache.tomee.catalina.ServerListener\"/>\n  <Listener ");
        }
    }

    public static class MissingResourceException
    extends RuntimeException {
        public MissingResourceException(String message) {
            super(message);
        }
    }
}

