/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.XMLDocumentImpl;
import org.apache.tuscany.sdo.helper.XMLStreamHelper;
import org.apache.tuscany.sdo.util.resource.DataObjectXMLStreamReader;
import org.apache.tuscany.sdo.util.resource.XMLDocumentStreamReader;
import org.apache.tuscany.sdo.util.resource.XMLStreamSerializer;
import org.eclipse.emf.ecore.resource.Resource;

public class XMLStreamHelperImpl
implements XMLStreamHelper {
    protected HelperContext helperContext;

    public XMLStreamHelperImpl(HelperContext hc) {
        this.helperContext = hc;
    }

    private Map checkSetOptions(Map options) {
        if (this.helperContext != null) {
            return ((HelperContextImpl)this.helperContext).getMergedOption(options);
        }
        return options;
    }

    public XMLDocument load(XMLStreamReader reader) throws XMLStreamException, IllegalStateException {
        if (reader.getEventType() != 7) {
            throw new IllegalStateException();
        }
        return this.loadDocument(reader, null);
    }

    public void save(XMLDocument document, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader = this.createXMLStreamReader(document);
        new XMLStreamSerializer().serialize(reader, writer);
    }

    public void save(XMLDocument document, XMLStreamWriter writer, Map options) throws XMLStreamException {
        XMLStreamReader reader = this.createXMLStreamReader(document);
        options = this.checkSetOptions(options);
        new XMLStreamSerializer().serialize(reader, writer, options);
    }

    public XMLStreamReader createXMLStreamReader(XMLDocument document) throws XMLStreamException {
        DataObjectXMLStreamReader reader = new DataObjectXMLStreamReader(document.getRootObject(), document.getRootElementURI(), document.getRootElementName(), this.helperContext.getTypeHelper());
        return new XMLDocumentStreamReader(reader);
    }

    public final DataObject loadObject(XMLStreamReader reader, Map options) throws XMLStreamException, IllegalStateException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException();
        }
        reader = new XMLDocumentStreamReader(reader);
        return this.loadDocument(reader, options).getRootObject();
    }

    public DataObject loadObject(XMLStreamReader reader) throws XMLStreamException, IllegalStateException {
        return this.loadObject(reader, null);
    }

    public void saveObject(DataObject sdo, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader = this.createXMLStreamReader(sdo);
        new XMLStreamSerializer().serialize(new XMLDocumentStreamReader(reader), writer);
    }

    public void saveObject(DataObject sdo, XMLStreamWriter writer, Map options) throws XMLStreamException {
        XMLStreamReader reader = this.createXMLStreamReader(sdo);
        options = this.checkSetOptions(options);
        new XMLStreamSerializer().serialize(new XMLDocumentStreamReader(reader), writer, options);
    }

    public XMLStreamReader createXMLStreamReader(DataObject dataObject) {
        String rootElementURI;
        String rootElementName;
        if (dataObject == null) {
            return null;
        }
        Property property = dataObject.getContainmentProperty();
        if (property != null) {
            rootElementName = property.getName();
            rootElementURI = property.getType().getURI();
        } else {
            rootElementName = dataObject.getType().getName();
            rootElementURI = dataObject.getType().getURI();
        }
        return new DataObjectXMLStreamReader(dataObject, rootElementURI, rootElementName, this.helperContext.getTypeHelper());
    }

    protected XMLDocument loadDocument(XMLStreamReader reader, Map options) throws XMLStreamException {
        try {
            XMLDocumentImpl document = new XMLDocumentImpl(((HelperContextImpl)this.helperContext).extendedMetaData, null);
            options = this.checkSetOptions(options);
            document.load(reader, options);
            return document;
        }
        catch (Exception e) {
            Resource.IOWrappedException ioe;
            if (e instanceof Resource.IOWrappedException && (ioe = (Resource.IOWrappedException)e).getWrappedException() instanceof XMLStreamException) {
                throw (XMLStreamException)ioe.getWrappedException();
            }
            throw new RuntimeException(e);
        }
    }

    public HelperContext getHelperContext() {
        return this.helperContext;
    }
}

