/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.impl;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.SDOPackage;
import org.apache.tuscany.sdo.impl.DataGraphImpl;
import org.apache.tuscany.sdo.impl.DataObjectImpl;
import org.apache.tuscany.sdo.util.BasicSequence;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.DelegatingFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ChangeSummaryImpl
extends ChangeDescriptionImpl
implements ChangeSummary {
    protected DataGraph eDataGraph = null;
    protected DataObject dataObject = null;
    protected SDOChangeRecorder changeRecorder = null;
    protected Set cachedDeletedObjects = null;
    protected List cachedCreatedObjects = null;
    protected Map cachedSDOObjectChanges = this.createThreadSafeMap();
    protected boolean isStale = false;
    private static Class concurrentHashMapClazz = null;
    private static boolean isThreadSafeMapClazzIdentified = false;
    private static String[] concurrentHashMapClazzNames = new String[]{"java.util.concurrent.ConcurrentHashMap", "edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap"};

    protected ChangeSummaryImpl() {
    }

    protected EClass eStaticClass() {
        return SDOPackage.eINSTANCE.getChangeSummary();
    }

    public boolean isLogging() {
        return this.changeRecorder != null;
    }

    public DataGraph getEDataGraph() {
        return this.eDataGraph;
    }

    public NotificationChain basicSetEDataGraph(DataGraph newEDataGraph, NotificationChain msgs) {
        DataGraph oldEDataGraph = this.eDataGraph;
        this.eDataGraph = newEDataGraph;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldEDataGraph, (Object)newEDataGraph);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setEDataGraph(DataGraph newEDataGraph) {
        if (newEDataGraph != this.eDataGraph) {
            NotificationChain msgs = null;
            if (this.eDataGraph != null) {
                msgs = ((InternalEObject)this.eDataGraph).eInverseRemove((InternalEObject)this, 2, DataGraph.class, msgs);
            }
            if (newEDataGraph != null) {
                msgs = ((InternalEObject)newEDataGraph).eInverseAdd((InternalEObject)this, 2, DataGraph.class, msgs);
            }
            if ((msgs = this.basicSetEDataGraph(newEDataGraph, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newEDataGraph, (Object)newEDataGraph));
        }
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(DataObject newDataObject) {
        this.dataObject = newDataObject;
    }

    public void beginLogging() {
        if (this.isLogging()) {
            throw new IllegalStateException("Already logging");
        }
        this.getObjectsToAttach().clear();
        this.getObjectChanges().clear();
        this.getResourceChanges().clear();
        this.oldContainmentInformation = null;
        this.beginRecording();
    }

    private void beginRecording() {
        this.changeRecorder = new SDOChangeRecorder();
        if (this.eDataGraph != null) {
            this.changeRecorder.beginRecording(Collections.singleton(((DataGraphImpl)this.eDataGraph).getRootResource()));
        } else if (this.dataObject != null) {
            this.changeRecorder.beginRecording(Collections.singleton(this.dataObject));
        } else {
            throw new IllegalStateException("ChangeSummary not attached to any data objects");
        }
    }

    public void resumeLogging() {
        if (this.isLogging()) {
            throw new IllegalStateException("Already logging");
        }
        this.oldContainmentInformation = null;
        this.beginRecording();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    if (this.eDataGraph != null) {
                        msgs = ((InternalEObject)this.eDataGraph).eInverseRemove((InternalEObject)this, 2, DataGraph.class, msgs);
                    }
                    return this.basicSetEDataGraph((DataGraph)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eInternalContainer() != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getObjectChanges()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getObjectsToAttach()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return ((InternalEList)this.getResourceChanges()).basicRemove((Object)otherEnd, msgs);
                }
                case 4: {
                    return this.basicSetEDataGraph(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (coreType) {
                    return this.getObjectChanges();
                }
                return this.getObjectChanges().map();
            }
            case 1: {
                return this.getObjectsToDetach();
            }
            case 2: {
                return this.getObjectsToAttach();
            }
            case 3: {
                return this.getResourceChanges();
            }
            case 4: {
                return this.getEDataGraph();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                ((EStructuralFeature.Setting)this.getObjectChanges()).set(newValue);
                return;
            }
            case 1: {
                this.getObjectsToDetach().clear();
                this.getObjectsToDetach().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getObjectsToAttach().clear();
                this.getObjectsToAttach().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getResourceChanges().clear();
                this.getResourceChanges().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setEDataGraph((DataGraph)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getObjectChanges().clear();
                return;
            }
            case 1: {
                this.getObjectsToDetach().clear();
                return;
            }
            case 2: {
                this.getObjectsToAttach().clear();
                return;
            }
            case 3: {
                this.getResourceChanges().clear();
                return;
            }
            case 4: {
                this.setEDataGraph(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.objectChanges != null && !this.objectChanges.isEmpty();
            }
            case 1: {
                return this.objectsToDetach != null && !this.objectsToDetach.isEmpty();
            }
            case 2: {
                return this.objectsToAttach != null && !this.objectsToAttach.isEmpty();
            }
            case 3: {
                return this.resourceChanges != null && !this.resourceChanges.isEmpty();
            }
            case 4: {
                return this.eDataGraph != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    protected void uncache() {
        this.cachedDeletedObjects = null;
        this.cachedCreatedObjects = null;
        this.cachedSDOObjectChanges.clear();
    }

    public void endLogging() {
        if (!this.isLogging()) {
            throw new IllegalStateException("Not currently logging");
        }
        this.changeRecorder.endRecording();
        this.changeRecorder.dispose();
        this.changeRecorder = null;
    }

    public boolean isCreated(DataObject dataObject) {
        return this.getCachedCreatedObjects().contains(dataObject);
    }

    public boolean isDeleted(DataObject dataObject) {
        return this.getCachedDeletedObjects().contains(dataObject);
    }

    protected Set getCachedDeletedObjects() {
        if (this.cachedDeletedObjects == null) {
            if (this.isStale()) {
                this.changeRecorder.consolidateChanges();
            }
            this.cachedDeletedObjects = new HashSet();
            TreeIterator i = EcoreUtil.getAllContents((Collection)this.getObjectsToAttach());
            while (i.hasNext()) {
                this.cachedDeletedObjects.add(i.next());
            }
        }
        return this.cachedDeletedObjects;
    }

    protected List getCachedCreatedObjects() {
        if (this.cachedCreatedObjects == null) {
            if (this.isStale()) {
                this.changeRecorder.consolidateChanges();
            }
            this.cachedCreatedObjects = super.getObjectsToDetach();
        }
        return this.cachedCreatedObjects;
    }

    public List getChangedDataObjects() {
        UniqueEList.FastCompare result = new UniqueEList.FastCompare((Collection)this.getCachedDeletedObjects());
        result.addAll((Collection)this.getCachedCreatedObjects());
        Iterator i = this.getObjectChanges().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            result.add(entry.getKey());
        }
        return result;
    }

    public List getOldValues(DataObject dataObject) {
        List settings;
        List sdoSettings = (List)this.cachedSDOObjectChanges.get(dataObject);
        if (sdoSettings != null) {
            return sdoSettings;
        }
        if (this.isStale()) {
            this.changeRecorder.consolidateChanges();
        }
        if ((settings = (List)this.getObjectChanges().get((Object)dataObject)) == null) {
            settings = Collections.EMPTY_LIST;
        } else {
            for (int i = 0; i < settings.size(); ++i) {
                FeatureChange change = (FeatureChange)settings.get(i);
                EStructuralFeature feature = change.getFeature();
                if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) continue;
                final List values = (List)change.getValue();
                if (sdoSettings == null) {
                    sdoSettings = new BasicEList((Collection)settings);
                }
                DelegatingFeatureMap featureMap = new DelegatingFeatureMap((InternalEObject)dataObject, feature){
                    protected final List theList;
                    {
                        super(x0, x1);
                        this.theList = values;
                    }

                    protected List delegateList() {
                        return this.theList;
                    }
                };
                sdoSettings.set(i, SDOFactory.eINSTANCE.createChangeSummarySetting(feature, new BasicSequence((FeatureMap.Internal)featureMap), change.isSet()));
                for (int k = 0; k < featureMap.size(); ++k) {
                    EStructuralFeature f = featureMap.getEStructuralFeature(k);
                    sdoSettings.add(SDOFactory.eINSTANCE.createChangeSummarySetting(f, featureMap.get(f, false), true));
                }
            }
        }
        sdoSettings = sdoSettings != null ? sdoSettings : settings;
        this.cachedSDOObjectChanges.put(dataObject, sdoSettings);
        return sdoSettings;
    }

    public boolean isModified(DataObject dataObject) {
        return this.getObjectChanges().containsKey((Object)dataObject) && !this.isDeleted(dataObject) && !this.isCreated(dataObject);
    }

    public void summarize() {
        if (!this.isLogging()) {
            throw new IllegalStateException("Not currently logging");
        }
        this.changeRecorder.summarize();
    }

    public ChangeSummary.Setting getOldValue(DataObject dataObject, Property property) {
        Iterator i = this.getOldValues(dataObject).iterator();
        while (i.hasNext()) {
            ChangeSummary.Setting setting = (ChangeSummary.Setting)i.next();
            if (setting.getProperty() != property) continue;
            return setting;
        }
        return null;
    }

    public DataObject getOldContainer(DataObject dataObject) {
        return (DataObject)this.getOldContainer((EObject)dataObject);
    }

    public Property getOldContainmentProperty(DataObject dataObject) {
        return (Property)this.getOldContainmentFeature((EObject)dataObject);
    }

    public Sequence getOldSequence(DataObject dataObject) {
        EAttribute mixedFeature = BasicExtendedMetaData.INSTANCE.getMixedFeature((EClass)dataObject.getType());
        if (mixedFeature != null) {
            return (Sequence)this.getOldValue(dataObject, (Property)mixedFeature).getValue();
        }
        return null;
    }

    public void undoChanges() {
        if (this.isLogging()) {
            this.changeRecorder.summarize();
        } else {
            this.uncache();
        }
        this.apply();
    }

    public DataGraph getDataGraph() {
        return this.getEDataGraph();
    }

    protected Map getOldContainmentInformation() {
        if (this.oldContainmentInformation == null) {
            if (this.isStale()) {
                this.changeRecorder.consolidateChanges();
            }
            super.getOldContainmentInformation();
        }
        return this.oldContainmentInformation;
    }

    protected boolean isStale() {
        return this.isLogging() && this.isStale;
    }

    public DataObject getRootObject() {
        if (this.eDataGraph != null) {
            return this.eDataGraph.getRootObject();
        }
        if (this.dataObject != null) {
            return this.dataObject;
        }
        return null;
    }

    protected static boolean isContainmentReference(Object feature) {
        return feature instanceof EReference && ((EReference)feature).isContainment();
    }

    public DataObject getOldDataObject(DataObject dataObject) {
        List changes = (List)this.getObjectChanges().get((Object)dataObject);
        if (changes == null) {
            return dataObject;
        }
        EObject oldDataObject = EcoreUtil.copy((EObject)((EObject)dataObject));
        Iterator fIter = changes.iterator();
        while (fIter.hasNext()) {
            int index;
            FeatureChange featureChange = (FeatureChange)fIter.next();
            featureChange.apply(oldDataObject);
            EStructuralFeature feature = featureChange.getFeature();
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                FeatureMap featureMap = (FeatureMap)oldDataObject.eGet(feature);
                index = featureMap.size();
                while (index != 0) {
                    if (!ChangeSummaryImpl.isContainmentReference(featureMap.getEStructuralFeature(--index))) continue;
                    featureMap.setValue(index, (Object)this.getOldDataObject((DataObject)featureMap.getValue(index)));
                }
                continue;
            }
            if (!ChangeSummaryImpl.isContainmentReference(feature)) continue;
            Object value = oldDataObject.eGet(feature);
            if (feature.isMany()) {
                changes = (List)value;
                index = changes.size();
                while (index != 0) {
                    changes.set(--index, this.getOldDataObject((DataObject)changes.get(index)));
                }
                continue;
            }
            oldDataObject.eSet(feature, (Object)this.getOldDataObject((DataObject)value));
        }
        return (DataObject)oldDataObject;
    }

    private Map createThreadSafeMap() {
        if (!isThreadSafeMapClazzIdentified) {
            concurrentHashMapClazz = ChangeSummaryImpl.loadConcurrentHashMapClazz();
            isThreadSafeMapClazzIdentified = true;
        }
        Map threadSafeMap = null;
        if (concurrentHashMapClazz == null) {
            threadSafeMap = Collections.synchronizedMap(new HashMap());
        } else {
            try {
                threadSafeMap = (Map)concurrentHashMapClazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return threadSafeMap;
    }

    private static Class loadConcurrentHashMapClazz() {
        Class<?> mapClazz = null;
        for (int i = 0; i < concurrentHashMapClazzNames.length; ++i) {
            String concurrentHashMapClazzName = concurrentHashMapClazzNames[i];
            try {
                mapClazz = Class.forName(concurrentHashMapClazzName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (mapClazz != null) break;
            try {
                mapClazz = Class.forName(concurrentHashMapClazzName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mapClazz != null) break;
        }
        return mapClazz;
    }

    protected class SDOChangeRecorder
    extends ChangeRecorder {
        public void beginRecording(ChangeDescription changeDescription, Collection rootObjects) {
            ChangeSummaryImpl.this.uncache();
            super.beginRecording(changeDescription, rootObjects);
        }

        protected ChangeDescription createChangeDescription() {
            return ChangeSummaryImpl.this;
        }

        protected FeatureChange createFeatureChange(EObject eObject, EStructuralFeature eStructuralFeature, Object value, boolean isSet) {
            Property property = (Property)eStructuralFeature;
            if (property.isReadOnly() && ((DataObject)eObject).getDataGraph() != null) {
                throw new IllegalStateException("The property '" + property.getName() + "' of type '" + property.getContainingType().getName() + "' is read only");
            }
            return (FeatureChange)SDOFactory.eINSTANCE.createChangeSummarySetting(eStructuralFeature, value, isSet);
        }

        protected void consolidateChanges() {
            ChangeSummaryImpl.this.uncache();
            ChangeSummaryImpl.this.isStale = false;
            boolean isUncontainedRoot = ChangeSummaryImpl.this.dataObject != null && ((EObject)ChangeSummaryImpl.this.dataObject).eContainer() == null && ((EObject)ChangeSummaryImpl.this.dataObject).eResource() == null;
            super.consolidateChanges();
            if (isUncontainedRoot && this.changeDescription.getObjectsToAttach().contains((Object)ChangeSummaryImpl.this.dataObject)) {
                this.changeDescription.getObjectsToAttach().remove((Object)ChangeSummaryImpl.this.dataObject);
            }
        }

        protected void addAdapter(Notifier notifier) {
            if (!this.loadingTargets) {
                return;
            }
            if (notifier instanceof DataObjectImpl) {
                ((DataObjectImpl)notifier).setChangeRecorder(this);
            } else {
                super.addAdapter(notifier);
            }
        }

        protected void removeAdapter(Notifier notifier) {
            if (notifier instanceof DataObjectImpl) {
                ((DataObjectImpl)notifier).setChangeRecorder(null);
            } else {
                super.removeAdapter(notifier);
            }
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object notifier = notification.getNotifier();
            if (notifier instanceof EObject) {
                ChangeSummaryImpl.this.cachedSDOObjectChanges.remove(notifier);
                Object feature = notification.getFeature();
                if (feature instanceof Property && ((Property)feature).isContainment()) {
                    ChangeSummaryImpl.this.cachedCreatedObjects = null;
                    ChangeSummaryImpl.this.cachedDeletedObjects = null;
                    ChangeSummaryImpl.this.oldContainmentInformation = null;
                }
                ChangeSummaryImpl.this.isStale = true;
            }
        }
    }
}

